/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.descriptor;

import java.io.File;
import java.util.Vector;
import jeus.tool.common.xml.XMLTree;
import jeus.util.file.FileUtils;

public class WLApplication {
    public static int EAR_TYPE = 1;
    public static int EJB_TYPE = 2;
    public static int WEB_TYPE = 3;
    public static int EJB_TYPE_DIR = 4;
    public static int WEB_TYPE_DIR = 5;
    public static int NOTSUPPORTED = -1;
    public static String APPLICATION = "Application";
    public static String PATH = "Path";
    public static String URI = "URI";
    public static String EJB_COMPONENT = "EJBComponent";
    public static String WEB_COMPONENT = "WebAppComponent";
    public static String NAME = "Name";
    public static String FS = System.getProperty("file.separator");
    int type = -1;
    String path;
    String appName;
    String uri;

    public WLApplication(XMLTree appTree) {
        if (appTree == null) {
            return;
        }
        if (appTree.getName() == null) {
            return;
        }
        if (appTree.getName().equals(APPLICATION)) {
            this.appName = (String)appTree.getAttribute(NAME);
            String tempPath = (String)appTree.getAttribute(PATH);
            tempPath = tempPath.replace('/', FS.charAt(0));
            if ((tempPath = tempPath.replace('\\', FS.charAt(0))) == null) {
                return;
            }
            File pathFile = new File(tempPath);
            if (!pathFile.exists()) {
                return;
            }
            if (pathFile.isFile() && tempPath.endsWith(".ear")) {
                String name;
                String[] DirAndFile = FileUtils.separateDirAndFile((String)tempPath);
                String fullFileName = DirAndFile[1];
                this.appName = name = fullFileName.substring(0, fullFileName.lastIndexOf(".ear"));
                this.type = EAR_TYPE;
                this.path = tempPath;
            }
            if (pathFile.isDirectory()) {
                XMLTree tree;
                Vector ejbComponent = appTree.getElements(EJB_COMPONENT);
                Vector webComponent = appTree.getElements(WEB_COMPONENT);
                if (ejbComponent.size() == 1 && webComponent.size() == 0) {
                    tree = (XMLTree)ejbComponent.get(0);
                    String uri = (String)tree.getAttribute(URI);
                    this.appName = (String)tree.getAttribute(NAME);
                    this.path = tempPath + FS + uri;
                    this.type = !FileUtils.isExploded((String)this.path) ? EJB_TYPE : EJB_TYPE_DIR;
                } else if (ejbComponent.size() == 0 && webComponent.size() == 1) {
                    tree = (XMLTree)webComponent.get(0);
                    String uri = (String)tree.getAttribute(URI);
                    this.appName = (String)tree.getAttribute(NAME);
                    this.path = tempPath + FS + uri;
                    this.type = uri.endsWith(".war") ? EJB_TYPE : WEB_TYPE_DIR;
                } else {
                    this.type = NOTSUPPORTED;
                }
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.appName;
    }

    public String getPath() {
        return this.path;
    }
}

