/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.descriptor;

import java.util.ArrayList;
import java.util.Enumeration;
import jeus.descriptor.jms.DestinationDescriptor;
import jeus.tool.common.xml.XMLTree;

public class WLJMSServerDescriptor {
    public String JMS_SERVER = "JMSServer";
    public String JMS_QUEUE = "JMSQueue";
    public String JMS_TOPIC = "JMSTopic";
    public String JNDI_NAME = "JNDIName";
    public String NAME = "Name";
    public String STORE = "Store";
    public static final int QUEUE_INDEX = 1;
    public static final int TOPIC_INDEX = 2;
    public static ArrayList destDescriptor = new ArrayList();
    String dataSourceName;

    public WLJMSServerDescriptor(XMLTree jmsServerTree) {
        if (jmsServerTree != null) {
            DestinationDescriptor dc;
            XMLTree destTree;
            this.dataSourceName = (String)jmsServerTree.getAttribute(this.STORE);
            Enumeration destEnum = jmsServerTree.elements(this.JMS_QUEUE);
            while (destEnum.hasMoreElements()) {
                destTree = (XMLTree)destEnum.nextElement();
                dc = new DestinationDescriptor();
                dc.setType(1);
                dc.setName((String)destTree.getAttribute(this.NAME));
                dc.setJNDIName((String)destTree.getAttribute(this.JNDI_NAME));
                this.addDestination(dc);
            }
            destEnum = jmsServerTree.elements(this.JMS_TOPIC);
            while (destEnum.hasMoreElements()) {
                destTree = (XMLTree)destEnum.nextElement();
                dc = new DestinationDescriptor();
                dc.setType(2);
                dc.setName((String)destTree.getAttribute(this.NAME));
                dc.setJNDIName((String)destTree.getAttribute(this.JNDI_NAME));
                this.addDestination(dc);
            }
        }
    }

    public static int getTypeFromDestination(String name) {
        if (name == null) {
            return 1;
        }
        for (int i = 0; i < destDescriptor.size(); ++i) {
            DestinationDescriptor dc = (DestinationDescriptor)destDescriptor.get(i);
            if (!name.equals(dc.getName())) continue;
            return dc.getType();
        }
        return 1;
    }

    public void addDestination(DestinationDescriptor dc) {
        destDescriptor.add(dc);
    }

    public ArrayList getDestinations() {
        return destDescriptor;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String value) {
        this.dataSourceName = value;
    }
}

