/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.desctojaxb;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.ejb.JNDIInfo;
import jeus.tool.converter.common.ModuleConversion;
import jeus.tool.converter.weblogic.descriptor.ColumnMap;
import jeus.tool.converter.weblogic.descriptor.FieldMap;
import jeus.tool.converter.weblogic.descriptor.WLBeanDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLJarDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLMethod;
import jeus.tool.converter.weblogic.descriptor.WLQuery;
import jeus.tool.converter.weblogic.descriptor.WLRelationDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLRelationRoleDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLResourceBeanDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLResourceDescriptor;
import jeus.tool.converter.weblogic.xmltowldesc.WLJarConverter;
import jeus.tool.converter.weblogic.xmltowldesc.WLResourceConverter;
import jeus.util.JeusException;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.xml.binding.jeusDD.BeanlistType;
import jeus.xml.binding.jeusDD.CmFieldType;
import jeus.xml.binding.jeusDD.ColumnMapType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.DbVendorType;
import jeus.xml.binding.jeusDD.EjbModuleInfoType;
import jeus.xml.binding.jeusDD.EjbRelationMapType;
import jeus.xml.binding.jeusDD.FindMethodType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.JeusRelationshipRoleType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SchemaInfoType;
import jeus.xml.binding.jeusDD.TypePropertyType;

public class EJBDDJaxbConverter {
    private String FS = System.getProperty("file.separator");
    private String WEBLOGIC_RDBMS_POSTFIX = "-rdbms-jar.xml";
    private Hashtable DB_VENDOR_INFO = new Hashtable();
    private boolean is_jeus_main_info = false;
    private WLJarDescriptor wlEjbDdInfo = null;
    private WLResourceDescriptor wlResourceDes = null;
    private ObjectFactory ejbDDfactory = new ObjectFactory();

    public String constructJaxbObject(String sourcePath, String targetDir, String moduleName, boolean ejbDDOnly) throws JAXBException, IOException {
        this.wlEjbDdInfo = (WLJarDescriptor)WLJarConverter.readConfigureValue(sourcePath);
        if (this.wlEjbDdInfo == null) {
            return null;
        }
        String[] dirAndFilName = FileUtils.separateDirAndFile((String)sourcePath);
        String metaInfPath = dirAndFilName[0];
        this.getWLResourceDescriptor(metaInfPath);
        JeusEjbDdType ejbDD = this.ejbDDfactory.createJeusEjbDdType();
        EjbModuleInfoType moduleInfo = this.ejbDDfactory.createEjbModuleInfoType();
        ejbDD.setModuleInfo(moduleInfo);
        ejbDD.setBeanlist(this.fillBeanList());
        if (this.wlResourceDes != null) {
            this.fillEjbRelationMap(ejbDD);
        }
        return this.saveDD(ejbDD, moduleName, targetDir, ejbDDOnly);
    }

    private String saveDD(JeusEjbDdType webDD, String moduleName, String targetDir, boolean DDOnly) throws JAXBException, IOException {
        File targetFile = null;
        targetFile = DDOnly ? new File(targetDir + this.FS + "jeus-ejb-dd_" + moduleName + ".xml") : new File(targetDir + this.FS + "jeus-ejb-dd.xml");
        ObjectFactory fac = new ObjectFactory();
        ModuleConversion.marshalDescriptor(fac.createJeusEjbDd(webDD), "jeus.xml.binding.jeusDD", targetFile);
        return targetFile.getAbsolutePath();
    }

    private BeanlistType fillBeanList() throws JAXBException {
        BeanlistType beanList = this.ejbDDfactory.createBeanlistType();
        Enumeration enum1 = this.wlEjbDdInfo.getBeans().elements();
        while (enum1.hasMoreElements()) {
            WLBeanDescriptor wlBean = (WLBeanDescriptor)enum1.nextElement();
            JeusBeanType jeusBean = this.ejbDDfactory.createJeusBeanType();
            jeusBean.setEjbName(wlBean.getEJBName());
            jeusBean.setExportName(wlBean.getJNDIName());
            jeusBean.setLocalExportName(wlBean.getLocalJNDIName());
            if (this.fillRef(wlBean.getEJBRefs()) != null) {
                jeusBean.setEjbRef(this.fillRef(wlBean.getEJBRefs()));
            }
            if (this.fillRef(wlBean.getResourceRefs()) != null) {
                jeusBean.setResRef(this.fillRef(wlBean.getResourceRefs()));
            }
            if (this.fillRef(wlBean.getResourceEnvRefs()) != null) {
                jeusBean.setResEnvRef(this.fillRef(wlBean.getResourceEnvRefs()));
            }
            if (this.wlResourceDes != null) {
                SchemaInfoType schemaInfo = null;
                try {
                    schemaInfo = this.fillSchemaInfo(wlBean.getEJBName());
                    if (schemaInfo != null) {
                        jeusBean.setSchemaInfo(schemaInfo);
                    }
                }
                catch (JeusException e) {
                    JeusLogger.getLogger((String)"jeus.converter").log(Level.SEVERE, "Fail to convert <schema-info> element", e);
                }
            }
            if (wlBean.getDestinationJndiName() != null) {
                jeusBean.setDestination(wlBean.getDestinationJndiName());
                jeusBean.setConnectionFactoryName(wlBean.getConnectionFacJndiName());
            }
            beanList.getJeusBean().add(jeusBean);
        }
        return beanList;
    }

    private void fillEjbRelationMap(JeusEjbDdType ejbDD) throws JAXBException {
        Enumeration relations = this.wlResourceDes.getRelations().elements();
        while (relations.hasMoreElements()) {
            WLRelationDescriptor relationDesc = (WLRelationDescriptor)relations.nextElement();
            EjbRelationMapType ejbRelationMap = this.ejbDDfactory.createEjbRelationMapType();
            ejbRelationMap.setRelationName(relationDesc.getRelationName());
            ejbRelationMap.setTableName(relationDesc.getTableName());
            Vector roles = relationDesc.getRelationRoles();
            if (roles.size() == 1) {
                WLRelationRoleDescriptor role = (WLRelationRoleDescriptor)roles.get(0);
                JeusRelationshipRoleType jeusRelationshipRole = this.ejbDDfactory.createJeusRelationshipRoleType();
                jeusRelationshipRole.setRelationshipRoleName(role.getRoleName());
                Enumeration colMaps = role.getColMaps().elements();
                while (colMaps.hasMoreElements()) {
                    ColumnMap colMap = (ColumnMap)colMaps.nextElement();
                    ColumnMapType columnMap = this.ejbDDfactory.createColumnMapType();
                    columnMap.setForeignKeyColumn(colMap.getForeignKey());
                    columnMap.setTargetPrimaryKeyColumn(colMap.getKey());
                    jeusRelationshipRole.getColumnMap().add(columnMap);
                }
                ejbRelationMap.getJeusRelationshipRole().add(jeusRelationshipRole);
            } else if (roles.size() == 2) {
                WLRelationRoleDescriptor role1 = (WLRelationRoleDescriptor)roles.get(0);
                WLRelationRoleDescriptor role2 = (WLRelationRoleDescriptor)roles.get(1);
                JeusRelationshipRoleType jeusRelationshipRole1 = this.ejbDDfactory.createJeusRelationshipRoleType();
                JeusRelationshipRoleType jeusRelationshipRole2 = this.ejbDDfactory.createJeusRelationshipRoleType();
                this.fillJoinColumnMap(jeusRelationshipRole1, role2, role1, ejbRelationMap);
                this.fillJoinColumnMap(jeusRelationshipRole2, role1, role2, ejbRelationMap);
            }
            ejbDD.getEjbRelationMap().add(ejbRelationMap);
        }
    }

    private void fillJoinColumnMap(JeusRelationshipRoleType jeusRelationshipRole1, WLRelationRoleDescriptor role2, WLRelationRoleDescriptor role1, EjbRelationMapType ejbRelationMap) throws JAXBException {
        jeusRelationshipRole1.setRelationshipRoleName(role2.getRoleName());
        Enumeration colMaps = role1.getColMaps().elements();
        while (colMaps.hasMoreElements()) {
            ColumnMap colMap = (ColumnMap)colMaps.nextElement();
            ColumnMapType columnMap = this.ejbDDfactory.createColumnMapType();
            columnMap.setForeignKeyColumn(colMap.getForeignKey());
            columnMap.setTargetPrimaryKeyColumn(colMap.getKey());
            jeusRelationshipRole1.getColumnMap().add(columnMap);
        }
        ejbRelationMap.getJeusRelationshipRole().add(jeusRelationshipRole1);
    }

    private SchemaInfoType fillSchemaInfo(String myName) throws JAXBException, JeusException {
        this.getJeusMainInfo();
        SchemaInfoType schemaInfo = this.ejbDDfactory.createSchemaInfoType();
        Enumeration enum1 = this.wlResourceDes.getRscBeans().elements();
        while (enum1.hasMoreElements()) {
            WLResourceBeanDescriptor rscBeanDesc = (WLResourceBeanDescriptor)enum1.nextElement();
            if (!myName.equals(rscBeanDesc.getEJBName())) continue;
            String dbSourceName = rscBeanDesc.getDataSourceName();
            schemaInfo.setDataSourceName(dbSourceName);
            String vendorName = (String)this.DB_VENDOR_INFO.get(dbSourceName);
            if (vendorName == null) {
                System.out.println("[NOTE] can't find vendor info for '" + dbSourceName + "' : setting 'oracle' by default.");
                schemaInfo.setDbVendor(DbVendorType.valueOf((String)"oracle"));
            } else if (vendorName.equals("undefined")) {
                System.out.println("[NOTE] there is a vendor for " + dbSourceName + " which EJB does not support in Jeus : setting 'oracle' by default.");
                schemaInfo.setDbVendor(DbVendorType.valueOf((String)"oracle"));
            } else {
                System.out.println("[NOTE] setting vendor as '" + vendorName + "' for '" + dbSourceName + "'");
                schemaInfo.setDbVendor(DbVendorType.valueOf((String)vendorName));
            }
            schemaInfo.setTableName(rscBeanDesc.getTableName());
            if (rscBeanDesc.getFieldMaps() != null) {
                Enumeration fmenum = rscBeanDesc.getFieldMaps().elements();
                while (fmenum.hasMoreElements()) {
                    FieldMap fm = (FieldMap)fmenum.nextElement();
                    CmFieldType cmField = this.ejbDDfactory.createCmFieldType();
                    cmField.setField(fm.getCMPField());
                    cmField.setColumnName(fm.getDBMSColumn());
                    cmField.setType(fm.getDBMSColumnType());
                    schemaInfo.getCmField().add(cmField);
                }
            }
            if (rscBeanDesc.getQuerys() != null) {
                Enumeration quenum = rscBeanDesc.getQuerys().elements();
                while (quenum.hasMoreElements()) {
                    WLQuery wlQuery = (WLQuery)quenum.nextElement();
                    FindMethodType jeusQuery = this.ejbDDfactory.createFindMethodType();
                    WLMethod wlQueryMethod = wlQuery.getMethod();
                    MethodParamType jeusQueyMethod = this.ejbDDfactory.createMethodParamType();
                    jeusQueyMethod.setMethodName(wlQueryMethod.getMethodName());
                    MethodParamsType jeusQueyMethodParams = this.ejbDDfactory.createMethodParamsType();
                    for (int i = 0; i < wlQueryMethod.getMethodParams().size(); ++i) {
                        String wlMethodParam = (String)wlQueryMethod.getMethodParams().elementAt(i);
                        jeusQueyMethodParams.getMethodParam().add(wlMethodParam);
                    }
                    jeusQueyMethod.setMethodParams(jeusQueyMethodParams);
                    jeusQuery.setQueryMethod(jeusQueyMethod);
                    jeusQuery.setSql(wlQuery.getQuery());
                }
            }
            return schemaInfo;
        }
        return null;
    }

    private JndiRefType fillRef(Vector wlRefs) throws JAXBException {
        Enumeration wlRefEnum = wlRefs.elements();
        JndiRefType jeusRef = this.ejbDDfactory.createJndiRefType();
        while (wlRefEnum.hasMoreElements()) {
            JNDIInfo wlJndi = (JNDIInfo)wlRefEnum.nextElement();
            JndiInfoType jeusJndi = this.ejbDDfactory.createJndiInfoType();
            jeusJndi.setExportName((String)wlJndi.getTarget());
            jeusJndi.setRefName(wlJndi.getRefName());
            jeusRef.getJndiInfo().add(jeusJndi);
        }
        return jeusRef;
    }

    private Vector getWLRscXMLList(String absPath) {
        File absFile = new File(absPath);
        File[] listFiles = absFile.listFiles();
        if (listFiles == null) {
            return null;
        }
        if (listFiles.length == 0) {
            return null;
        }
        Vector<File> rscXMLList = new Vector<File>();
        for (int i = 0; i < listFiles.length; ++i) {
            File oneFile = listFiles[i];
            String fileName = oneFile.getName();
            if (!oneFile.isFile() || fileName == null || !fileName.startsWith("weblogic") || !fileName.endsWith(this.WEBLOGIC_RDBMS_POSTFIX)) continue;
            rscXMLList.add(oneFile);
        }
        return rscXMLList;
    }

    private void getWLResourceDescriptor(String metaInfPath) throws JeusException {
        this.wlResourceDes = null;
        Vector wlRscXMLList = this.getWLRscXMLList(metaInfPath);
        if (wlRscXMLList != null && wlRscXMLList.size() > 0) {
            for (int i = 0; i < wlRscXMLList.size(); ++i) {
                File wlRscFile = (File)wlRscXMLList.get(i);
                if (!wlRscFile.exists()) continue;
                WLResourceDescriptor tmpDesc = (WLResourceDescriptor)WLResourceConverter.readToolOption(wlRscFile.getPath());
                this.wlResourceDes = new WLResourceDescriptor();
                this.wlResourceDes.getRscBeans().addAll(tmpDesc.getRscBeans());
                this.wlResourceDes.getRelations().addAll(tmpDesc.getRelations());
                this.wlResourceDes.setVersionString(tmpDesc.getVersionString());
            }
        }
    }

    private void getJeusMainInfo() throws JeusException {
        if (this.is_jeus_main_info) {
            return;
        }
        try {
            this.DB_VENDOR_INFO.clear();
            JeusSystemType jeusMainJaxb = JeusMainDescriptorJB.getJeusMainDescriptor();
            List databaseList = jeusMainJaxb.getResource().getDataSource().getDatabase();
            if (databaseList == null) {
                return;
            }
            for (int i = 0; i < databaseList.size(); ++i) {
                DatabaseType database = (DatabaseType)databaseList.get(i);
                if (database.getVendor().equals((Object)"others")) {
                    String vendor = this.findActualVendor(database);
                    this.DB_VENDOR_INFO.put(database.getExportName(), vendor);
                    continue;
                }
                this.DB_VENDOR_INFO.put(database.getExportName(), database.getVendor());
            }
            this.is_jeus_main_info = true;
        }
        catch (Exception e) {
            throw new JeusException("Fail to get db infomation from JEUSMain.xml");
        }
    }

    private String findActualVendor(DatabaseType database) {
        if (database.getDataSourceClassName().indexOf("oracle") != -1) {
            return "oracle";
        }
        if (database.getDataSourceClassName().indexOf("sybase") != -1) {
            return "sybase";
        }
        if (database.getDataSourceClassName().indexOf("microsoft") != -1) {
            return "mssql";
        }
        if (database.getDataSourceClassName().indexOf("db2") != -1) {
            return "db2";
        }
        if (database.getDataSourceClassName().indexOf("blackbox") != -1) {
            List properties = database.getProperty();
            String driverName = null;
            for (int i = 0; i < properties.size(); ++i) {
                TypePropertyType property = (TypePropertyType)properties.get(i);
                if (!property.getName().equals("DriverClassName")) continue;
                driverName = property.getValue();
            }
            if (driverName == null) {
                return "undefined";
            }
            if (driverName.indexOf("oracle") != -1) {
                return "oracle";
            }
            if (driverName.indexOf("sybase") != -1) {
                return "sybase";
            }
            if (driverName.indexOf("microsoft") != -1) {
                return "mssql";
            }
            if (driverName.indexOf("db2") != -1) {
                return "db2";
            }
        }
        return "undefined";
    }
}

