/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.xmltowldesc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.weblogic.descriptor.WLApplication;
import jeus.tool.converter.weblogic.descriptor.WLDBConnPoolDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDataSourceDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDomainConfigDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLJMSConnectionFactoryDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLJMSServerDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLServerConfigDescriptor;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Converter;

public class WLDomainConfigConverter
extends XMLConverter {
    public static final String DOMAIN = "Domain";
    public static final String NAME = "Name";
    public static final String JNDI_NAME = "JNDIName";
    public static final String APPLICATION = "Application";
    public static final String JMS_SERVER = "JMSServer";
    public static final String JMS_CONNECTION_FACTORY = "JMSConnectionFactory";
    public static final String SERVER = "Server";
    public static final String LISTEN_PORT = "ListenPort";
    public static final String STARTUP_CLASS = "StartupClass";
    public static final String STARTUP_METHOD = "ClassName";
    public static final String STARTUP_PARAMETER = "Arguments";
    public static final String SHUTDOWN_CLASS = "ShutdownClass";
    public static final String SHUTDOWN_METHOD = "ClassName";
    public static final String SHUTDOWN_PARAMETER = "Arguments";

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        XMLTree domainTree = xmlTree;
        if (!domainTree.getName().equals(DOMAIN)) {
            return null;
        }
        WLDomainConfigDescriptor desc = new WLDomainConfigDescriptor();
        String domainName = (String)domainTree.getAttribute(NAME);
        if (domainName == null) {
            // empty if block
        }
        desc.setDomainName(domainName);
        Vector<WLApplication> appList = new Vector<WLApplication>();
        Enumeration e = domainTree.elements(APPLICATION);
        while (e.hasMoreElements()) {
            XMLTree appTree = (XMLTree)e.nextElement();
            appList.addElement(new WLApplication(appTree));
        }
        desc.setAppList(appList);
        Hashtable<String, WLDBConnPoolDescriptor> poolTable = new Hashtable<String, WLDBConnPoolDescriptor>();
        e = domainTree.elements(WLDBConnPoolDescriptor.JDBC_CONNECTION_POOL);
        while (e.hasMoreElements()) {
            WLDBConnPoolDescriptor poolDesc;
            XMLTree poolTree = (XMLTree)e.nextElement();
            String targets = (String)poolTree.getAttribute(WLDBConnPoolDescriptor.TARGETS);
            if (targets == null || targets.trim().equals("") || (poolDesc = new WLDBConnPoolDescriptor(poolTree)).getName() == null) continue;
            poolTable.put(poolDesc.getName(), poolDesc);
        }
        desc.setConnPoolTable(poolTable);
        Vector<WLDataSourceDescriptor> DSList = new Vector<WLDataSourceDescriptor>();
        e = domainTree.elements(WLDataSourceDescriptor.DATA_SOURCE);
        while (e.hasMoreElements()) {
            XMLTree dsTree = (XMLTree)e.nextElement();
            String targets = (String)dsTree.getAttribute(WLDBConnPoolDescriptor.TARGETS);
            if (targets == null || targets.trim().equals("")) continue;
            DSList.addElement(new WLDataSourceDescriptor(dsTree));
        }
        desc.setTxDataSourceList(DSList);
        Vector<WLDataSourceDescriptor> txDSList = new Vector<WLDataSourceDescriptor>();
        e = domainTree.elements(WLDataSourceDescriptor.TX_DATA_SOURCE);
        while (e.hasMoreElements()) {
            XMLTree dsTree = (XMLTree)e.nextElement();
            String targets = (String)dsTree.getAttribute(WLDBConnPoolDescriptor.TARGETS);
            if (targets == null || targets.trim().equals("")) continue;
            txDSList.addElement(new WLDataSourceDescriptor(dsTree));
        }
        desc.setTxDataSourceList(txDSList);
        Vector<WLDataSourceDescriptor> jmsDSList = new Vector<WLDataSourceDescriptor>();
        e = domainTree.elements(WLDataSourceDescriptor.JMS_DB_STORE);
        while (e.hasMoreElements()) {
            XMLTree jmsStoreTree = (XMLTree)e.nextElement();
            jmsDSList.addElement(new WLDataSourceDescriptor(jmsStoreTree));
        }
        desc.setJmsJDBCStoreList(jmsDSList);
        Enumeration e1 = domainTree.elements(JMS_SERVER);
        while (e1.hasMoreElements()) {
            XMLTree jmsServerTree = (XMLTree)e1.nextElement();
            desc.setJMSServerDesc(new WLJMSServerDescriptor(jmsServerTree));
        }
        Enumeration enum1 = domainTree.elements(JMS_CONNECTION_FACTORY);
        WLJMSConnectionFactoryDescriptor cf = new WLJMSConnectionFactoryDescriptor();
        while (enum1.hasMoreElements()) {
            XMLTree cfTree = (XMLTree)enum1.nextElement();
            cf.addConnectionFactory(cfTree);
        }
        desc.setJMSConnectionFactories(cf.getConnectionFactory());
        Enumeration e2 = domainTree.elements(SERVER);
        while (e2.hasMoreElements()) {
            XMLTree serverTree = (XMLTree)e2.nextElement();
            String portValue = (String)serverTree.getAttribute(LISTEN_PORT);
            if (portValue == null) continue;
            WLServerConfigDescriptor serverDesc = new WLServerConfigDescriptor();
            serverDesc.setHTTPPort(portValue);
            desc.setServerDesc(serverDesc);
            break;
        }
        Enumeration enumSt = xmlTree.elements(STARTUP_CLASS);
        Vector<String> startupMethods = new Vector<String>();
        Vector<String> startupParameters = new Vector<String>();
        while (enumSt.hasMoreElements()) {
            XMLTree startupTree = (XMLTree)enumSt.nextElement();
            String startupMethod = (String)startupTree.getAttribute("ClassName");
            String startupParameter = (String)startupTree.getAttribute("Arguments");
            startupMethods.add(startupMethod);
            startupParameters.add(startupParameter);
        }
        desc.setStartupMethods(startupMethods);
        desc.setStartupParameters(startupParameters);
        Enumeration enumSh = xmlTree.elements(SHUTDOWN_CLASS);
        Vector<String> shutdownMethods = new Vector<String>();
        Vector<String> shutdownParameters = new Vector<String>();
        while (enumSh.hasMoreElements()) {
            XMLTree shutdownTree = (XMLTree)enumSh.nextElement();
            String shutdownMethod = (String)shutdownTree.getAttribute("ClassName");
            String shutdownParameter = (String)shutdownTree.getAttribute("Arguments");
            shutdownMethods.add(shutdownMethod);
            shutdownParameters.add(shutdownParameter);
        }
        desc.setShutdownMethods(shutdownMethods);
        desc.setShutdownParameters(shutdownParameters);
        return desc;
    }

    public String getSystemID() {
        return "system id";
    }

    public String getPublicID() {
        return "public id";
    }

    public int getType() {
        return -1;
    }

    public static int getStaticType() {
        return -1;
    }

    public static Object readConfigValue(String somePath) throws JeusException {
        WLDomainConfigConverter converter = new WLDomainConfigConverter();
        try {
            FileInputStream in = new FileInputStream(new File(somePath));
            XMLUtil xmlUtil = new XMLUtil();
            XMLTree xmlTree = xmlUtil.process((InputStream)in, false, WLDomainConfigConverter.getStaticType());
            return converter.getUserObject(xmlTree);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6106, (Object)somePath, (Throwable)e);
        }
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }
}

