/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.xmltowldesc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.weblogic.descriptor.ColumnMap;
import jeus.tool.converter.weblogic.descriptor.FieldMap;
import jeus.tool.converter.weblogic.descriptor.WLMethod;
import jeus.tool.converter.weblogic.descriptor.WLQuery;
import jeus.tool.converter.weblogic.descriptor.WLRelationDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLRelationRoleDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLResourceBeanDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLResourceDescriptor;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Converter;

public class WLResourceConverter
extends XMLConverter {
    public static final String RDBMS_JAR = "weblogic-rdbms-jar";
    public static final String RDBMS_BEAN = "weblogic-rdbms-bean";
    public static final String EJB_NAME = "ejb-name";
    public static final String DATASOURCE_NAME = "data-source-name";
    public static final String TABLE_MAP = "table-map";
    public static final String TABLE_NAME = "table-name";
    public static final String FIELD_MAP = "field-map";
    public static final String CMP_FIELD = "cmp-field";
    public static final String DBMS_COLUMN = "dbms-column";
    public static final String DBMS_COLUMN_TYPE = "dbms-column-type";
    public static final String QUERY = "weblogic-query";
    public static final String QUERY_METHOD = "query-method";
    public static final String METHOD_NAME = "method-name";
    public static final String METHOD_PARAMS = "method-params";
    public static final String METHOD_PARAM = "method-param";
    public static final String WLB_QL = "weblogic-ql";
    public static final String RELATION = "weblogic-rdbms-relation";
    public static final String RELATION_NAME = "relation-name";
    public static final String RELATION_ROLE = "weblogic-relationship-role";
    public static final String ROLE_NAME = "relationship-role-name";
    public static final String RELATIONSHIP_ROLE_MAP = "relationship-role-map";
    public static final String COLUMN_MAP = "column-map";
    public static final String FR_KEY_COLUMN = "foreign-key-column";
    public static final String KEY_COLUMN = "key-column";
    int currentVersion = 7;

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        XMLTree wlResourceTree = xmlTree;
        if (!wlResourceTree.getName().equals(RDBMS_JAR)) {
            return null;
        }
        WLResourceDescriptor desc = new WLResourceDescriptor();
        String publicId = xmlTree.getPublicID();
        if (publicId != null && publicId.indexOf("6.") >= 0) {
            desc.setVersionString("6");
            this.currentVersion = 6;
        }
        Vector<WLResourceBeanDescriptor> beanList = new Vector<WLResourceBeanDescriptor>();
        Enumeration e = wlResourceTree.elements(RDBMS_BEAN);
        while (e.hasMoreElements()) {
            XMLTree beanTree = (XMLTree)e.nextElement();
            beanList.addElement(this.getRscBeanDescriptor(beanTree));
        }
        desc.setRscBeans(beanList);
        Vector<WLRelationDescriptor> relationList = new Vector<WLRelationDescriptor>();
        Enumeration e2 = wlResourceTree.elements(RELATION);
        while (e2.hasMoreElements()) {
            XMLTree rTree = (XMLTree)e2.nextElement();
            relationList.addElement(this.getRelationDescriptor(rTree));
        }
        desc.setRelations(relationList);
        return desc;
    }

    public WLResourceBeanDescriptor getRscBeanDescriptor(XMLTree beanTree) {
        WLResourceBeanDescriptor desc = new WLResourceBeanDescriptor();
        desc.setEJBName(XMLUtil.getSubtreeValue(beanTree, EJB_NAME));
        desc.setDataSourceName(XMLUtil.getSubtreeValue(beanTree, DATASOURCE_NAME));
        if (this.currentVersion == 6) {
            desc.setTableName(XMLUtil.getSubtreeValue(beanTree, TABLE_NAME));
            Vector<FieldMap> fmapList = new Vector<FieldMap>();
            Enumeration e2 = beanTree.elements(FIELD_MAP);
            while (e2.hasMoreElements()) {
                XMLTree mapTree = (XMLTree)e2.nextElement();
                fmapList.addElement(this.getFieldMapDesc(mapTree));
            }
            desc.setFieldMaps(fmapList);
        } else {
            XMLTree tmTree = beanTree.getFirstElement(TABLE_MAP);
            if (tmTree != null) {
                desc.setTableName(XMLUtil.getSubtreeValue(tmTree, TABLE_NAME));
                Vector<FieldMap> fmapList = new Vector<FieldMap>();
                Enumeration e2 = tmTree.elements(FIELD_MAP);
                while (e2.hasMoreElements()) {
                    XMLTree mapTree = (XMLTree)e2.nextElement();
                    fmapList.addElement(this.getFieldMapDesc(mapTree));
                }
                desc.setFieldMaps(fmapList);
            }
        }
        Vector<WLQuery> qList = new Vector<WLQuery>();
        Enumeration e = beanTree.elements(QUERY);
        while (e.hasMoreElements()) {
            XMLTree qTree = (XMLTree)e.nextElement();
            qList.addElement(this.getQueryDesc(qTree));
        }
        desc.setQuerys(qList);
        return desc;
    }

    public WLQuery getQueryDesc(XMLTree qTree) {
        WLQuery qDesc = new WLQuery();
        XMLTree qMethodTree = qTree.getFirstElement(QUERY_METHOD);
        if (qMethodTree == null) {
            return null;
        }
        WLMethod qMethod = new WLMethod();
        qMethod.setMethodName(XMLUtil.getSubtreeValue(qMethodTree, METHOD_NAME));
        XMLTree paramsTree = qMethodTree.getFirstElement(METHOD_PARAMS);
        if (paramsTree != null) {
            Vector<String> params = new Vector<String>();
            Enumeration e = paramsTree.elements(METHOD_PARAM);
            while (e.hasMoreElements()) {
                XMLTree pTree = (XMLTree)e.nextElement();
                params.addElement(pTree.getValue());
            }
            qMethod.setMethodParams(params);
        }
        qDesc.setMethod(qMethod);
        qDesc.setQuery(XMLUtil.getSubtreeValue(qTree, WLB_QL));
        return qDesc;
    }

    public FieldMap getFieldMapDesc(XMLTree mapTree) {
        FieldMap mapDesc = new FieldMap();
        mapDesc.setCMPField(XMLUtil.getSubtreeValue(mapTree, CMP_FIELD));
        mapDesc.setDBMSColumn(XMLUtil.getSubtreeValue(mapTree, DBMS_COLUMN));
        mapDesc.setDBMSColumnType(XMLUtil.getSubtreeValue(mapTree, DBMS_COLUMN_TYPE));
        return mapDesc;
    }

    public WLRelationDescriptor getRelationDescriptor(XMLTree relationTree) {
        WLRelationDescriptor rdesc = new WLRelationDescriptor();
        rdesc.setRelationName(XMLUtil.getSubtreeValue(relationTree, RELATION_NAME));
        rdesc.setTableName(XMLUtil.getSubtreeValue(relationTree, TABLE_NAME));
        Vector<WLRelationRoleDescriptor> roles = new Vector<WLRelationRoleDescriptor>();
        Enumeration e = relationTree.elements(RELATION_ROLE);
        while (e.hasMoreElements()) {
            XMLTree rrTree = (XMLTree)e.nextElement();
            roles.addElement(this.getRelationRoleDesc(rrTree));
        }
        rdesc.setRelationRoles(roles);
        return rdesc;
    }

    public WLRelationRoleDescriptor getRelationRoleDesc(XMLTree rrTree) {
        WLRelationRoleDescriptor rrDesc = new WLRelationRoleDescriptor();
        rrDesc.setRoleName(XMLUtil.getSubtreeValue(rrTree, ROLE_NAME));
        Vector<ColumnMap> colMaps = new Vector<ColumnMap>();
        if (this.currentVersion == 6) {
            Enumeration e = rrTree.elements(COLUMN_MAP);
            while (e.hasMoreElements()) {
                XMLTree cmTree = (XMLTree)e.nextElement();
                ColumnMap cm = new ColumnMap();
                cm.setForeignKey(XMLUtil.getSubtreeValue(cmTree, FR_KEY_COLUMN));
                cm.setKey(XMLUtil.getSubtreeValue(cmTree, KEY_COLUMN));
                colMaps.add(cm);
            }
            rrDesc.setColMaps(colMaps);
        } else {
            XMLTree relationRoleMapTree = rrTree.getFirstElement(RELATIONSHIP_ROLE_MAP);
            if (relationRoleMapTree != null) {
                Enumeration e = relationRoleMapTree.elements(COLUMN_MAP);
                while (e.hasMoreElements()) {
                    XMLTree cmTree = (XMLTree)e.nextElement();
                    ColumnMap cm = new ColumnMap();
                    cm.setForeignKey(XMLUtil.getSubtreeValue(cmTree, FR_KEY_COLUMN));
                    cm.setKey(XMLUtil.getSubtreeValue(cmTree, KEY_COLUMN));
                    colMaps.add(cm);
                }
                rrDesc.setColMaps(colMaps);
            }
        }
        return rrDesc;
    }

    public String getSystemID() {
        return "system id";
    }

    public String getPublicID() {
        return "public id";
    }

    public int getType() {
        return -1;
    }

    public static int getStaticType() {
        return -1;
    }

    public static Object readToolOption(String somePath) throws JeusException {
        WLResourceConverter converter = new WLResourceConverter();
        try {
            FileInputStream in = new FileInputStream(new File(somePath));
            XMLUtil xmlUtil = new XMLUtil();
            XMLTree xmlTree = xmlUtil.process((InputStream)in, false, WLResourceConverter.getStaticType());
            return converter.getUserObject(xmlTree);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6106, (Object)somePath, (Throwable)e);
        }
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }
}

