/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.xmltowldesc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.deployment.descriptor.RoleMappingDescriptor;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.weblogic.descriptor.WLWEBDescriptor;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Converter;

public class WLWEBConverter
extends XMLConverter {
    public static final String WEB_APP = "weblogic-web-app";
    public static final String SECURITY_ASSIGNMENT = "security-role-assignment";
    public static final String ROLE_NAME = "role-name";
    public static final String PRINCIPAL_NAME = "principal-name";
    public static final String REFERENCE_DESCRIPTOR = "reference-descriptor";
    public static final String RESOURCE_DESCRIPTION = "resource-description";
    public static final String RESOURCE_ENV_DESCRIPTION = "resource-env-description";
    public static final String EJB_REFERENCE_DESCRIPTION = "ejb-reference-description";
    public static final String RES_REF_NAME = "res-ref-name";
    public static final String RES_ENV_REF_NAME = "res-env-ref-name";
    public static final String EJB_REF_NAME = "ejb-ref-name";
    public static final String JNDI_NAME = "jndi-name";

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        XMLTree wlwebTree = xmlTree;
        if (!wlwebTree.getName().equals(WEB_APP)) {
            return null;
        }
        WLWEBDescriptor desc = new WLWEBDescriptor();
        XMLTree refTree = wlwebTree.getFirstElement(REFERENCE_DESCRIPTOR);
        if (refTree != null) {
            String value;
            String name;
            XMLTree subTree;
            Hashtable<String, String> refTable = new Hashtable<String, String>();
            Enumeration enum1 = refTree.elements(RESOURCE_DESCRIPTION);
            while (enum1.hasMoreElements()) {
                subTree = (XMLTree)enum1.nextElement();
                name = XMLUtil.getSubtreeValue(subTree, RES_REF_NAME);
                value = XMLUtil.getSubtreeValue(subTree, JNDI_NAME);
                refTable.put(name, value);
            }
            desc.setResourceRefs(refTable);
            refTable = new Hashtable();
            enum1 = refTree.elements(RESOURCE_ENV_DESCRIPTION);
            while (enum1.hasMoreElements()) {
                subTree = (XMLTree)enum1.nextElement();
                name = XMLUtil.getSubtreeValue(subTree, RES_ENV_REF_NAME);
                value = XMLUtil.getSubtreeValue(subTree, JNDI_NAME);
                refTable.put(name, value);
            }
            desc.setResourceEnvRefs(refTable);
            enum1 = refTree.elements(EJB_REFERENCE_DESCRIPTION);
            while (enum1.hasMoreElements()) {
                subTree = (XMLTree)enum1.nextElement();
                name = XMLUtil.getSubtreeValue(subTree, EJB_REF_NAME);
                value = XMLUtil.getSubtreeValue(subTree, JNDI_NAME);
                refTable.put(name, value);
            }
            desc.setEJBRefs(refTable);
        }
        RoleMappingDescriptor rmd = new RoleMappingDescriptor();
        Enumeration secRoleEnum = wlwebTree.elements(SECURITY_ASSIGNMENT);
        while (secRoleEnum.hasMoreElements()) {
            XMLTree secRoleTree = (XMLTree)secRoleEnum.nextElement();
            String roleName = XMLUtil.getSubtreeValue(secRoleTree, ROLE_NAME);
            Vector<String> users = new Vector<String>();
            Enumeration prEnum = secRoleTree.elements(PRINCIPAL_NAME);
            while (prEnum.hasMoreElements()) {
                XMLTree prName = (XMLTree)prEnum.nextElement();
                if (prName == null || prName.getValue() == null) continue;
                users.add(prName.getValue());
            }
            rmd.addRoleMapping(roleName, users);
        }
        desc.setRoleMapping(rmd);
        return desc;
    }

    public static Object readConfigureValue(String somePath) throws JeusException {
        WLWEBConverter converter = new WLWEBConverter();
        try {
            FileInputStream in = new FileInputStream(new File(somePath));
            XMLUtil xmlUtil = new XMLUtil();
            XMLTree xmlTree = xmlUtil.process((InputStream)in, false, WLWEBConverter.getStaticType());
            return converter.getUserObject(xmlTree);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6106, (Object)somePath, (Throwable)e);
        }
    }

    public String getSystemID() {
        return "system id";
    }

    public String getPublicID() {
        return "public id";
    }

    public int getType() {
        return -1;
    }

    public static int getStaticType() {
        return -1;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }
}

