/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.deployment;

import java.io.File;
import jeus.descriptor.tool.Descriptor;
import jeus.tool.common.Parameters;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.deployment.ClientContainerDescManager;
import jeus.tool.deployment.DeployUnit;
import jeus.tool.manager.common.FileDirMapDescriptor;
import jeus.tool.util.JarManager;

public class ApplicationClientModule
extends DeployUnit {
    public static final String fs = System.getProperty("file.separator");
    public static final String DESCRIPTOR = "application-client.xml";
    public static final String TMP_DIR = Parameters.WORKING_DIR;
    public static final String JEUS_CLIENT_DD = "jeus-client-dd.xml";
    public static final String JNLP_NAME = "ClientApp.jnlp";
    public static final String JEUS_DESCRIPTOR_PREFIX = "jeus-client-dd";
    String moduleName = null;
    ClientContainerDescManager manager = new ClientContainerDescManager();

    public ApplicationClientModule(String source) {
        super(source);
        this.moduleName = this.getSourceName();
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            this.moduleName = this.getSourceName();
        }
        return this.moduleName;
    }

    public String getSourceFullName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        return name;
    }

    public String getSourceName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public String getDescriptorPath() {
        return this.root + fs + "META-INF" + fs + DESCRIPTOR;
    }

    public String getJeusDDToBePath() {
        return this.root + fs + "META-INF" + fs + JEUS_CLIENT_DD;
    }

    public String getJeusDescriptorPath() {
        String absPath = this.root + fs + "META-INF";
        String jeusDDName = null;
        File absFile = new File(absPath);
        File[] listFiles = absFile.listFiles();
        if (listFiles == null) {
            return null;
        }
        if (listFiles.length == 0) {
            return null;
        }
        for (int i = 0; i < listFiles.length; ++i) {
            File oneFile = listFiles[i];
            String fileName = oneFile.getName();
            if (!oneFile.isFile() || fileName == null || !fileName.startsWith(JEUS_DESCRIPTOR_PREFIX)) continue;
            jeusDDName = fileName;
        }
        if (jeusDDName == null) {
            return null;
        }
        return this.root + fs + "META-INF" + fs + jeusDDName;
    }

    public void addJeusDDtoPackage() throws Exception {
        this.makeFileContents();
        JarManager.jar(this.source, this.root);
        this.loadFileContents();
    }

    public ApplicationClientModule(String source, boolean isWIO) throws Exception {
        super(source, isWIO);
        this.moduleName = this.getSourceName();
        this.descriptor = (Descriptor)this.converter.getUserObject(this.getDescriptorTree());
    }

    public ApplicationClientModule(String source, FileDirMapDescriptor fileDesc, XMLTree xmldescriptor) throws Exception {
        super(source, fileDesc, xmldescriptor);
        this.moduleName = this.getSourceName();
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1102);
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1102);
    }

    public int getUnitType() {
        return 1102;
    }

    public int getJeusDDType() {
        return 1001;
    }
}

