/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.deployment;

import java.io.File;
import java.util.Hashtable;
import jeus.descriptor.tool.EJBReference;
import jeus.descriptor.tool.ResourceEnvironReference;
import jeus.descriptor.tool.ResourceReference;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.deployment.DeployUnit;
import jeus.tool.manager.common.FileDirMapDescriptor;
import jeus.util.ErrorMsgManager;

public class WEBModule
extends DeployUnit {
    public static final String WEB_INF = "WEB-INF";
    public static final String DESCRIPTOR = "web.xml";
    public static final String DD_DESCRIPTOR = "jeus-web-dd.xml";
    public static final String SERVLET_HOME = "webhome/servlet_home";
    public static final String SERVLET_HOME_AUTO = "servlet:";
    public static final String WEB_CONF = "web.conf";
    public static final String JEUS_DESCRIPTOR_PREFIX = "jeus-web-dd";
    private String moduleName = null;

    public WEBModule(String source) {
        super(source);
    }

    public String getDescriptorPath() {
        return this.root + fs + WEB_INF + fs + DESCRIPTOR;
    }

    public String getJeusDDToBePath() {
        String mayExistPath = this.getJeusDescriptorPath();
        if (mayExistPath != null) {
            return mayExistPath;
        }
        return this.root + fs + WEB_INF + fs + DD_DESCRIPTOR;
    }

    public String getJeusDescriptorPath() {
        String absPath = this.root + fs + WEB_INF;
        String jeusDDName = null;
        File absFile = new File(absPath);
        File[] listFiles = absFile.listFiles();
        if (listFiles == null) {
            return null;
        }
        if (listFiles.length == 0) {
            return null;
        }
        for (int i = 0; i < listFiles.length; ++i) {
            File oneFile = listFiles[i];
            String fileName = oneFile.getName();
            if (!oneFile.isFile() || fileName == null || !fileName.startsWith(JEUS_DESCRIPTOR_PREFIX)) continue;
            jeusDDName = fileName;
        }
        if (jeusDDName == null) {
            return null;
        }
        return this.root + fs + WEB_INF + fs + jeusDDName;
    }

    public ContextDescriptor getJeusDescriptor() {
        String jeusDDPath = this.getJeusDescriptorPath();
        if (jeusDDPath == null) {
            return null;
        }
        ContextDescriptor context = null;
        return context;
    }

    public String getSourceFullName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        return name;
    }

    public String getSourceName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public WEBModule(String source, boolean isWIO) throws Exception {
        super(source, isWIO);
        this.moduleName = this.getSourceName();
    }

    public WEBModule(String source, FileDirMapDescriptor fileDesc, XMLTree xmldescriptor) throws Exception {
        super(source, fileDesc, xmldescriptor);
        this.moduleName = this.getSourceName();
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            this.moduleName = this.getSourceName();
        }
        return this.moduleName;
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1101);
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1101);
    }

    public int getUnitType() {
        return 1101;
    }

    public int getJeusDDType() {
        return 1002;
    }

    public ContextDescriptor getContextDescriptor() throws Exception {
        WebAppDescriptor moduleDescriptor = (WebAppDescriptor)this.descriptor;
        ContextDescriptor ctxDescriptor = new ContextDescriptor();
        try {
            ResourceEnvironReference[] resEnvRefs;
            ResourceReference[] resRefs;
            ctxDescriptor.setContextName(this.getModuleName());
            ctxDescriptor.setContextPath("/" + this.getModuleName());
            ctxDescriptor.setDocBase(this.getModuleName());
            EJBReference[] ejbRefs = moduleDescriptor.getEJBRefs();
            if (ejbRefs != null) {
                Hashtable<String, String> newEnv = new Hashtable<String, String>();
                for (int i = 0; i < ejbRefs.length; ++i) {
                    String target = ejbRefs[i].getName();
                    String value = "";
                    String ejbLink = ejbRefs[i].getEJBLink();
                    if (ejbLink != null && !ejbLink.equals("")) {
                        value = ejbLink = "link : " + ejbLink;
                    }
                    newEnv.put(target, value);
                }
                ctxDescriptor.setEJBRefs(newEnv);
            }
            if ((resRefs = moduleDescriptor.getResourceRefs()) != null) {
                Hashtable<String, String> newRefs = new Hashtable<String, String>();
                for (int i = 0; i < resRefs.length; ++i) {
                    String target = resRefs[i].getName();
                    String value = "";
                    newRefs.put(target, value);
                }
                ctxDescriptor.setResourceRefs(newRefs);
            }
            if ((resEnvRefs = moduleDescriptor.getResourceEnvRefs()) != null) {
                Hashtable<String, String> newRefs = new Hashtable<String, String>();
                for (int i = 0; i < resEnvRefs.length; ++i) {
                    String target = resEnvRefs[i].getName();
                    String value = "";
                    newRefs.put(target, value);
                }
                ctxDescriptor.setResourceEnvRefs(newRefs);
            }
            return ctxDescriptor;
        }
        catch (DescriptorException de) {
            String msg = ErrorMsgManager.getLocalizedString((Throwable)((Object)de));
            throw new Exception(msg);
        }
    }
}

