/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.manager;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jeus.security.util.Base64Coder;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.manager.WIOConfigManager;
import jeus.tool.manager.WIOToolException;
import jeus.tool.manager.common.DistributeHandler;
import jeus.tool.manager.common.ElementMapTable;
import jeus.util.JeusException;

public class WIOAdminDB
implements Serializable {
    static boolean instance_flag = false;
    static ElementMapTable mapping = new ElementMapTable();
    WIOConfigManager confManager = new WIOConfigManager();

    public void refreshSystemConfig() throws WIOToolException, JeusException {
        XMLTree systemTree = this.createConfig(null, 1, "JEUS System");
    }

    public InfoEntry getEntry(int type, String name) {
        InfoEntry myEntry = null;
        if (mapping.containsKey(type, name)) {
            myEntry = (InfoEntry)mapping.get(type, name);
        } else {
            myEntry = new InfoEntry(type, name);
            mapping.put(type, name, myEntry);
        }
        return myEntry;
    }

    public void insertConfig(int type, String name, XMLTree newTree) throws WIOToolException, JeusException {
        InfoEntry myEntry = this.getEntry(type, name);
        myEntry.setConfig(newTree);
    }

    public XMLTree getConfig(int type, String name) throws WIOToolException, JeusException {
        return this.createConfig(null, type, name);
    }

    public XMLTree getConfig(String node, int type, String name) throws WIOToolException, JeusException {
        return this.createConfig(node, type, name);
    }

    public XMLTree createRemoteConfig(String machineName, int type, String name) throws WIOToolException, JeusException {
        XMLTree remoteTree = this.confManager.loadEngineConfig(machineName, type, name);
        XMLTree newTree = this.processEncryptionToCleanTree(type, remoteTree);
        return newTree;
    }

    public void saveRemoteConfig(String machineName, int type, String name, XMLTree configTree) throws WIOToolException, JeusException {
        XMLTree newTree = this.processEncryptionToEncryptedTree(type, configTree);
        this.confManager.saveConfig(machineName, type, name, newTree);
    }

    public XMLTree createConfig(String machineName, int type, String name) throws WIOToolException, JeusException {
        if (machineName != null && !machineName.equals(WIOParameters.HOST_NAME)) {
            return this.createRemoteConfig(machineName, type, name);
        }
        XMLTree myTree = this.confManager.getConfig(type, name);
        XMLTree newTree = this.processEncryptionToCleanTree(type, myTree);
        this.insertConfig(type, name, newTree);
        return newTree;
    }

    public XMLTree processEncryptionToCleanTree(int type, XMLTree oneTree) throws WIOToolException, JeusException {
        if (oneTree == null) {
            return oneTree;
        }
        if (type == 1) {
            XMLTree newTree = (XMLTree)oneTree.clone();
            XMLTree rscTree = newTree.getFirstElement("resource");
            if (rscTree == null) {
                return newTree;
            }
            XMLTree dsTree = rscTree.getFirstElement("data-source");
            if (dsTree == null) {
                return newTree;
            }
            Enumeration enum1 = dsTree.elements("database");
            while (enum1.hasMoreElements()) {
                XMLTree subTree;
                XMLTree dbTree = (XMLTree)enum1.nextElement();
                String isEncrypt = XMLUtil.getSubtreeValue(dbTree, "encryption");
                if (isEncrypt == null || !isEncrypt.equalsIgnoreCase("true") || (subTree = dbTree.getFirstElement("password")) == null || subTree.getValue() == null) continue;
                String oldValue = subTree.getValue();
                subTree.setValue(Base64Coder.decode(oldValue));
            }
            return newTree;
        }
        if (type == 4) {
            XMLTree newTree = (XMLTree)oneTree.clone();
            Enumeration enum1 = newTree.elements("db-connection-pool");
            while (enum1.hasMoreElements()) {
                XMLTree conargTree;
                XMLTree subTree;
                XMLTree dbcTree = (XMLTree)enum1.nextElement();
                String isEncrypt = XMLUtil.getSubtreeValue(dbcTree, "encryption");
                if (isEncrypt == null || !isEncrypt.equalsIgnoreCase("true") || (subTree = dbcTree.getFirstElement("connection-argument")) == null || subTree.getValue() == null) continue;
                String args = subTree.getValue();
                subTree.setValue(this.getPlainPassword(args));
                XMLTree dbaTree = dbcTree.getFirstElement("dba-connection");
                if (dbaTree == null || dbaTree == null || (conargTree = dbaTree.getFirstElement("connection-argument")) == null) continue;
                String conarg = conargTree.getValue();
                conargTree.setValue(this.getPlainPassword(conarg));
            }
            return newTree;
        }
        return oneTree;
    }

    public void distributeConfig(int type, String name, XMLTree configTree, Hashtable nodeEngineList) throws WIOToolException, JeusException {
        XMLTree newTree = this.processEncryptionToEncryptedTree(type, configTree);
        try {
            DistributeHandler.distribute(nodeEngineList, newTree, type);
        }
        catch (Exception e) {
            throw new WIOToolException("Config Distribute Error ", e);
        }
    }

    public void saveConfig(String machineName, int type, String name, XMLTree configTree) throws WIOToolException, JeusException {
        if (machineName != null && !machineName.equals(WIOParameters.HOST_NAME)) {
            this.saveRemoteConfig(machineName, type, name, configTree);
        } else {
            this.insertConfig(type, name, configTree);
            XMLTree newTree = this.processEncryptionToEncryptedTree(type, configTree);
            this.confManager.saveConfig(type, name, newTree);
        }
    }

    public XMLTree processEncryptionToEncryptedTree(int type, XMLTree oneTree) throws WIOToolException, JeusException {
        if (oneTree == null) {
            return oneTree;
        }
        if (type == 1) {
            XMLTree newTree = (XMLTree)oneTree.clone();
            XMLTree rscTree = newTree.getFirstElement("resource");
            if (rscTree == null) {
                return newTree;
            }
            XMLTree dsTree = rscTree.getFirstElement("data-source");
            if (dsTree == null) {
                return newTree;
            }
            Enumeration enum1 = dsTree.elements("database");
            while (enum1.hasMoreElements()) {
                XMLTree subTree;
                XMLTree dbTree = (XMLTree)enum1.nextElement();
                String isEncrypt = XMLUtil.getSubtreeValue(dbTree, "encryption");
                if (isEncrypt == null || !isEncrypt.equalsIgnoreCase("true") || (subTree = dbTree.getFirstElement("password")) == null) continue;
                String oldValue = subTree.getValue();
                subTree.setValue(Base64Coder.encode(oldValue));
            }
            return newTree;
        }
        if (type == 4) {
            XMLTree newTree = (XMLTree)oneTree.clone();
            Enumeration enum1 = newTree.elements("db-connection-pool");
            while (enum1.hasMoreElements()) {
                XMLTree conargTree;
                XMLTree subTree;
                XMLTree dbcTree = (XMLTree)enum1.nextElement();
                String isEncrypt = XMLUtil.getSubtreeValue(dbcTree, "encryption");
                if (isEncrypt == null || !isEncrypt.equalsIgnoreCase("true") || (subTree = dbcTree.getFirstElement("connection-argument")) == null) continue;
                String args = subTree.getValue();
                subTree.setValue(this.getEncryptedPassword(args));
                XMLTree dbaTree = dbcTree.getFirstElement("dba-connection");
                if (dbaTree == null || dbaTree == null || (conargTree = dbaTree.getFirstElement("connection-argument")) == null) continue;
                String conarg = conargTree.getValue();
                conargTree.setValue(this.getEncryptedPassword(conarg));
            }
            return newTree;
        }
        return oneTree;
    }

    public String getPlainPassword(String encryptedPassword) throws WIOToolException {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(encryptedPassword, ";");
        while (parser.hasMoreTokens()) {
            String arg = parser.nextToken();
            int pos = arg.indexOf("=");
            if (pos > 0) {
                String name = arg.substring(0, pos);
                String value = arg.substring(pos + 1);
                if (name.equalsIgnoreCase("password")) {
                    try {
                        String devalue;
                        value = devalue = Base64Coder.decode(value);
                    }
                    catch (Exception ae) {
                        // empty catch block
                    }
                }
                buffer.append(name + "=" + value + ";");
                continue;
            }
            throw new WIOToolException(2167, new String[]{arg});
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public String getEncryptedPassword(String plainPassword) throws WIOToolException {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(plainPassword, ";");
        while (parser.hasMoreTokens()) {
            String arg = parser.nextToken();
            int pos = arg.indexOf("=");
            if (pos > 0) {
                String name = arg.substring(0, pos);
                String value = arg.substring(pos + 1);
                if (name.equalsIgnoreCase("password")) {
                    try {
                        String devalue;
                        value = devalue = Base64Coder.encode(value);
                    }
                    catch (Exception ae) {
                        // empty catch block
                    }
                }
                buffer.append(name + "=" + value + ";");
                continue;
            }
            throw new WIOToolException(2167, new String[]{arg});
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    class InfoEntry
    implements Serializable {
        int type;
        String name;
        XMLTree configTree;
        Object monitorObject;

        public InfoEntry(int typeVal, String nameVal) {
            this.type = typeVal;
            this.name = nameVal;
        }

        public void setConfig(XMLTree val) {
            this.configTree = val;
        }

        public XMLTree getConfig() {
            return this.configTree;
        }

        public void setMonitor(Object mObject) {
            this.monitorObject = mObject;
        }

        public Object getMonitor() {
            return this.monitorObject;
        }
    }
}

