/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLDocTypeHolder;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.manager.WIOToolException;
import jeus.tool.manager.common.DistributeHandler;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;
import jeus.util.properties.JeusNetPropertyValues;

public class WIOConfigManager {
    String systemConfigPath = WIOParameters.CONFIG_DIR;
    String FS = WIOParameters.FS;

    public void setSystemPath() throws WIOToolException {
        if (WIOParameters.HOST_NAME == null || WIOParameters.HOST_NAME.equalsIgnoreCase("localhost")) {
            try {
                WIOParameters.HOST_NAME = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
                int index = WIOParameters.HOST_NAME.indexOf(46);
                if (index > 0) {
                    WIOParameters.HOST_NAME = WIOParameters.HOST_NAME.substring(0, index);
                }
            }
            catch (Exception ex) {
                throw new WIOToolException("can't find Host Name of the local machine");
            }
            WIOParameters.IS_LOCAL = true;
        }
        this.systemConfigPath = !WIOParameters.IS_LOCAL ? WIOParameters.WORKING_DIR + this.FS + WIOParameters.HOST_NAME + this.FS + "JEUSMain.xml" : WIOParameters.CONFIG_DIR + this.FS + WIOParameters.HOST_NAME + this.FS + "JEUSMain.xml";
    }

    public void saveSystemConfig(XMLTree configTree) throws WIOToolException, JeusException {
        this.setSystemPath();
        if (WIOParameters.IS_LOCAL) {
            try {
                File configFile = new File(this.systemConfigPath);
                XMLUtil xmlUtil = new XMLUtil();
                xmlUtil.saveWIO(configTree, 1, configFile);
            }
            catch (JeusException je) {
                throw je;
            }
            catch (FileNotFoundException ef) {
                throw new WIOToolException("Save Error : File Not Found Error", ef);
            }
            catch (IOException ie2) {
                throw new WIOToolException("Save Error : IO Exception" + ie2);
            }
            catch (Exception ee) {
                throw new WIOToolException("Save Error ", ee);
            }
        }
        try {
            Hashtable<String, String> distNodeList = new Hashtable<String, String>();
            distNodeList.put(WIOParameters.HOST_NAME, WIOParameters.HOST_NAME);
            DistributeHandler.distribute(distNodeList, configTree, 1);
        }
        catch (JeusException je) {
            throw je;
        }
        catch (Exception e) {
            throw new WIOToolException("Config Distribute Error ", e);
        }
    }

    public XMLTree loadSystemConfig() throws WIOToolException, JeusException {
        XMLTree systemConfigTree = null;
        this.setSystemPath();
        FileInputStream in = null;
        XMLUtil xmlUtil = new XMLUtil();
        if (WIOParameters.IS_LOCAL) {
            File configFile = new File(this.systemConfigPath);
            try {
                in = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e) {
                throw new WIOToolException("JEUSMain.xml is not reachable, can not load SystemConfig");
            }
            try {
                systemConfigTree = xmlUtil.process((InputStream)in, WIOParameters.XML_VALIDATION, 1);
                XMLDocTypeHolder.putPublicID(configFile.getPath(), systemConfigTree.getPublicID());
                XMLDocTypeHolder.putSystemID(configFile.getPath(), systemConfigTree.getSystemID());
            }
            catch (JeusException je) {
                throw je;
            }
            catch (Exception e) {
                throw new WIOToolException("XML Loading error for JEUSMain.xml :" + ErrorMsgManager.getLocalizedString((Throwable)e));
            }
        }
        try {
            Hashtable<String, String> nodeList = new Hashtable<String, String>();
            nodeList.put(WIOParameters.HOST_NAME, WIOParameters.HOST_NAME);
            String readingPath = DistributeHandler.retrieve(nodeList, 1);
            File configFile = new File(readingPath);
            in = new FileInputStream(configFile);
            systemConfigTree = xmlUtil.process((InputStream)in, WIOParameters.XML_VALIDATION, 1);
        }
        catch (JeusException je) {
            throw je;
        }
        catch (Exception e2) {
            throw new WIOToolException("XML Loading error for " + WIOParameters.HOST_NAME + ":JEUSMain.xml");
        }
        return systemConfigTree;
    }

    public void saveConfig(String machineName, int type, String name, XMLTree configTree) throws WIOToolException, JeusException {
        if (type == 1) {
            return;
        }
        try {
            Hashtable distNodeList = new Hashtable();
            Vector<String> engineTmpVector = new Vector<String>();
            engineTmpVector.add(name);
            distNodeList.put(machineName, engineTmpVector);
            DistributeHandler.distribute(distNodeList, configTree, type);
        }
        catch (JeusException je) {
            throw je;
        }
        catch (Exception e) {
            throw new WIOToolException("Config Distribute Error", e);
        }
    }

    public XMLTree loadEngineConfig(String machineName, int type, String name) throws WIOToolException, JeusException {
        FileInputStream in = null;
        XMLUtil xmlUtil = new XMLUtil();
        XMLTree engineTree = null;
        try {
            Hashtable<String, String> nodeList = new Hashtable<String, String>();
            nodeList.put(machineName, name);
            String readingPath = DistributeHandler.retrieve(nodeList, type);
            File configFile = new File(readingPath);
            in = new FileInputStream(configFile);
            engineTree = xmlUtil.process((InputStream)in, WIOParameters.XML_VALIDATION, type);
        }
        catch (JeusException je) {
            throw je;
        }
        catch (Exception e2) {
            throw new WIOToolException("XML Loading error for " + WIOParameters.HOST_NAME + " : " + WIOParameters.getMainFileName(type));
        }
        return engineTree;
    }

    public XMLTree loadEngineConfig(int type, String name) throws WIOToolException, JeusException {
        this.setSystemPath();
        XMLTree engineTree = null;
        FileInputStream in = null;
        XMLUtil xmlUtil = new XMLUtil();
        if (WIOParameters.IS_LOCAL) {
            String engineConfigPath = null;
            String engineConfigName = WIOParameters.getMainFileName(type);
            if (type == 1 || type == 7 || type == 100 || type == 1200) {
                engineConfigPath = WIOParameters.CONFIG_DIR + this.FS + WIOParameters.HOST_NAME + this.FS + engineConfigName;
            } else if (type == 601) {
                engineConfigPath = WIOParameters.CONFIG_DIR + this.FS + WIOParameters.HOST_NAME + this.FS + "JNLPServer" + this.FS + engineConfigName;
            } else {
                String GROUP_NAME = DistributeHandler.getGroupName(name);
                engineConfigPath = WIOParameters.CONFIG_DIR + this.FS + GROUP_NAME + this.FS + name + this.FS + engineConfigName;
            }
            File configFile = new File(engineConfigPath);
            try {
                in = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e) {
                throw new WIOToolException("Engine Config XML not reachable (" + name + "):" + engineConfigPath);
            }
            try {
                engineTree = xmlUtil.process((InputStream)in, WIOParameters.XML_VALIDATION, type);
            }
            catch (JeusException je) {
                throw je;
            }
            catch (Exception e) {
                throw new WIOToolException("Configuration XML Loading error for " + name);
            }
        }
        try {
            Hashtable<String, String> nodeList = new Hashtable<String, String>();
            nodeList.put(WIOParameters.HOST_NAME, name);
            String readingPath = DistributeHandler.retrieve(nodeList, type);
            File configFile = new File(readingPath);
            in = new FileInputStream(configFile);
            engineTree = xmlUtil.process((InputStream)in, WIOParameters.XML_VALIDATION, type);
        }
        catch (JeusException je) {
            throw je;
        }
        catch (Exception e2) {
            throw new WIOToolException("XML Loading error for " + WIOParameters.HOST_NAME + " : " + WIOParameters.getMainFileName(type));
        }
        return engineTree;
    }

    public XMLTree getConfig(int type, String name) throws WIOToolException, JeusException {
        if (type == 1) {
            return this.loadSystemConfig();
        }
        return this.loadEngineConfig(type, name);
    }

    public void saveConfig(int type, String name, XMLTree configTree) throws WIOToolException, JeusException {
        if (type == 1) {
            this.saveSystemConfig(configTree);
        } else {
            this.saveEngineConfig(type, name, configTree);
        }
    }

    public void saveEngineConfig(int type, String name, XMLTree configTree) throws WIOToolException, JeusException {
        this.setSystemPath();
        XMLUtil xmlUtil = new XMLUtil();
        if (WIOParameters.IS_LOCAL) {
            String engineConfigName = WIOParameters.getMainFileName(type);
            String engineConfigPath = null;
            if (type == 1 || type == 7 || type == 100 || type == 1200) {
                engineConfigPath = WIOParameters.CONFIG_DIR + this.FS + WIOParameters.HOST_NAME + this.FS + engineConfigName;
            } else if (type == 601) {
                engineConfigPath = WIOParameters.CONFIG_DIR + this.FS + WIOParameters.HOST_NAME + this.FS + "JNLPServer" + this.FS + engineConfigName;
            } else {
                String GROUP_NAME = DistributeHandler.getGroupName(name);
                engineConfigPath = WIOParameters.CONFIG_DIR + this.FS + GROUP_NAME + this.FS + name + this.FS + engineConfigName;
            }
            File configFile = new File(engineConfigPath);
            try {
                xmlUtil.saveWIO(configTree, type, configFile);
            }
            catch (JeusException je) {
                throw je;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new WIOToolException("Config Save Error", e);
            }
        }
        try {
            Hashtable distNodeList = new Hashtable();
            Vector<String> engineTmpVector = new Vector<String>();
            engineTmpVector.add(name);
            distNodeList.put(WIOParameters.HOST_NAME, engineTmpVector);
            DistributeHandler.distribute(distNodeList, configTree, type);
        }
        catch (JeusException je) {
            throw je;
        }
        catch (Exception e) {
            throw new WIOToolException("Config Distribute Error", e);
        }
    }
}

