/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.monitorapi.monitorinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import jeus.descriptor.jms.ClientDescriptor;
import jeus.descriptor.jms.DurableSubscriberDescriptor;
import jeus.descriptor.jms.ServerDescriptor;
import jeus.tool.monitorapi.monitorinfo.MonitorInfo;

public class JMSEngineMonitorInfo
implements MonitorInfo,
Serializable {
    ArrayList connList = new ArrayList();
    ArrayList destList = new ArrayList();
    ArrayList durableList = new ArrayList();
    ArrayList clientList = new ArrayList();
    int connCount = 0;
    int destCount = 0;
    int durableCount = 0;
    int clientCount = 0;
    private ServerDescriptor serverD = null;
    private String ENGINE_NAME;

    public void setJMSName(String engineName) {
        this.ENGINE_NAME = engineName;
    }

    public String getJMSEngineName() {
        return this.ENGINE_NAME;
    }

    public void setConnectionFactory(ServerDescriptor descriptor) {
        this.connCount = descriptor.getConnectionFactoryNameSize();
        for (int i = 0; i < this.connCount; ++i) {
            String conn = descriptor.getConnectionFactoryName(i);
            this.connList.add(conn);
        }
    }

    public void setDestination(ServerDescriptor descriptor) {
        this.destCount = descriptor.getDestinationNameSize();
        for (int i = 0; i < this.destCount; ++i) {
            String dest = descriptor.getDestinationName(i);
            this.destList.add(dest);
        }
    }

    public void setDurableSubscriber(ServerDescriptor descriptor) {
        this.durableCount = descriptor.getDurableSubscriberDescriptorSize();
        for (int i = 0; i < this.durableCount; ++i) {
            DurableSubscriberDescriptor subscriber = descriptor.getDurableSubscriberDescriptor(i);
            this.durableList.add(subscriber.getClientID() + ":" + subscriber.getName());
        }
    }

    public void setServerDescriptor(ServerDescriptor descriptor) {
        this.serverD = descriptor;
        this.setConnectionFactory(this.serverD);
        this.setDestination(this.serverD);
        this.setDurableSubscriber(this.serverD);
        this.setClientAddress(this.serverD);
    }

    public void setClientAddress(ServerDescriptor descriptor) {
        this.clientCount = descriptor.getClientAddressSize();
        for (int i = 0; i < this.clientCount; ++i) {
            ClientDescriptor clientD = descriptor.getClientAddress(i);
            String client = clientD.getHostAddress() + ":" + clientD.getPort();
            this.clientList.add(client);
        }
    }

    public Iterator getConnectionFactory() {
        return this.connList.iterator();
    }

    public Iterator getDestination() {
        return this.destList.iterator();
    }

    public Iterator getDurableSubscriber() {
        return this.durableList.iterator();
    }

    public Iterator getClientAddress() {
        return this.clientList.iterator();
    }

    public int getConnectionFactorySize() {
        return this.connCount;
    }

    public int getDesinationNameSize() {
        return this.destCount;
    }

    public int getDurableSubscriberSize() {
        return this.durableCount;
    }

    public int getClientAddressSize() {
        return this.clientCount;
    }
}

