/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.monitorapi.monitorinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jeus.servlet.common.ThreadStateInfo;
import jeus.tool.monitorapi.monitorinfo.MonitorInfo;

public class ServletEngineMonitorInfo
implements MonitorInfo,
Serializable {
    int activeCountPerEngine = 0;
    int idleCountPerEngine = 0;
    Hashtable threadInfos = new Hashtable();
    ArrayList threadPoolIds = new ArrayList();
    ArrayList threadIds = new ArrayList();
    public static final int THREAD_STATE_UNKNOWN = -1;
    public static final int THREAD_STATE_ACTIVE = 1;
    public static final int THREAD_STATE_WAITING = 3;
    public static final int THREAD_STATE_BLOCKED = 2;
    public static final int THREAD_STATE_RECONNECTING = 4;
    private String ENGINE_NAME;

    public void setServletName(String engineName) {
        this.ENGINE_NAME = engineName;
    }

    public void setThreadInfo(Hashtable info) {
        this.threadInfos = info;
        this.threadPoolIds.clear();
        this.threadIds.clear();
        Enumeration enum1 = this.threadInfos.keys();
        long longElpCountPerEngine = 0L;
        while (enum1.hasMoreElements()) {
            String port = (String)enum1.nextElement();
            this.threadPoolIds.add(port);
            Vector infos = (Vector)this.threadInfos.get(port);
            int activeCount = 0;
            int idleCount = 0;
            int size = infos.size();
            int elpCount = 0;
            long elpTime = 0L;
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo tinfo = (ThreadStateInfo)infos.elementAt(i);
                this.threadIds.add(tinfo.threadId);
                if (tinfo.active) {
                    ++activeCount;
                    elpTime = tinfo.elapsedTime;
                    if (elpTime < 30000L) continue;
                    ++elpCount;
                    continue;
                }
                ++idleCount;
            }
            this.activeCountPerEngine += activeCount;
            this.idleCountPerEngine += idleCount;
            longElpCountPerEngine += (long)elpCount;
        }
    }

    public long getThreadRuntime(String threadID) {
        Enumeration enum1 = this.threadInfos.keys();
        long elapsedTime = -1L;
        while (enum1.hasMoreElements()) {
            String port = (String)enum1.nextElement();
            Vector infos = (Vector)this.threadInfos.get(port);
            int size = infos.size();
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo tinfo = (ThreadStateInfo)infos.elementAt(i);
                if (!tinfo.threadId.equals(threadID)) continue;
                elapsedTime = tinfo.elapsedTime;
                return elapsedTime;
            }
        }
        return elapsedTime;
    }

    public String getServletEngineName() {
        return this.ENGINE_NAME;
    }

    public int getThreadStatus(String threadID) {
        Enumeration enum1 = this.threadInfos.keys();
        while (enum1.hasMoreElements()) {
            String port = (String)enum1.nextElement();
            Vector infos = (Vector)this.threadInfos.get(port);
            int size = infos.size();
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo tinfo = (ThreadStateInfo)infos.elementAt(i);
                if (!tinfo.threadId.equals(threadID)) continue;
                if (tinfo.blocked) {
                    return 2;
                }
                if (tinfo.reconnecting) {
                    return 4;
                }
                if (tinfo.active) {
                    return 1;
                }
                return 3;
            }
        }
        return -1;
    }

    public int getIdleThreadCount() {
        return this.idleCountPerEngine;
    }

    public int getIdleThreadCount(String poolID) {
        Enumeration enum1 = this.threadInfos.keys();
        while (enum1.hasMoreElements()) {
            String port = (String)enum1.nextElement();
            if (!port.equals(poolID)) continue;
            Vector infos = (Vector)this.threadInfos.get(port);
            int size = infos.size();
            int idleCount = 0;
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo tinfo = (ThreadStateInfo)infos.elementAt(i);
                if (tinfo.active) continue;
                ++idleCount;
            }
            return idleCount;
        }
        return -1;
    }

    public Iterator getThreadPoolList() {
        return this.threadPoolIds.iterator();
    }

    public Iterator getThreadList() {
        return this.threadIds.iterator();
    }
}

