/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.resource;

import java.util.Locale;
import java.util.ResourceBundle;

public final class ResourceManager {
    public static final String LANG_ENGLISH = "english";
    public static final String LANG_KOREAN = "korean";
    public static String m_language = "english";
    public static String[][] menuStringTable;
    public static String[] tooltipStringTable;
    public static String[][] mainframeStringTable;
    public static String[][] dialogStringTable;
    public static String[] messageStringTable;
    public static String[] statusStringTable;
    public static Locale m_locale;
    public static ResourceBundle resource;

    public static void initResourceManager() {
        ResourceManager.initResourceManager(m_language);
    }

    public static void initResourceManager(String language) {
        try {
            if (language == null || language.equalsIgnoreCase("")) {
                language = LANG_ENGLISH;
            }
            m_locale = new Locale(language);
            resource = ResourceBundle.getBundle("jeus.tool.resource.MessageResource", m_locale);
            menuStringTable = (String[][])resource.getObject("MENU_STRING_TABLE");
            tooltipStringTable = (String[])resource.getObject("TOOLTIP_STRING_TABLE");
            mainframeStringTable = (String[][])resource.getObject("MAINFRAME_STRING_TABLE");
            dialogStringTable = (String[][])resource.getObject("DIALOG_STRING_TABLE");
            messageStringTable = (String[])resource.getObject("MESSAGE_STRING_TABLE");
            statusStringTable = (String[])resource.getObject("STATUS_STRING_TABLE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLanguage(String language) {
        m_language = language == null || language.equalsIgnoreCase("") ? LANG_ENGLISH : language;
    }

    public static String getLanguage() {
        return m_language;
    }

    public static String getMenuString(int id, int index) {
        if (menuStringTable == null || id >= menuStringTable.length || index >= menuStringTable[id].length) {
            return "";
        }
        return menuStringTable[id][index];
    }

    public static String getTooltipString(int index) {
        if (tooltipStringTable == null || index >= tooltipStringTable.length) {
            return "";
        }
        return tooltipStringTable[index];
    }

    public static String getMainframeString(int id, int index) {
        if (mainframeStringTable == null || id >= mainframeStringTable.length || index >= mainframeStringTable[id].length) {
            return "";
        }
        return mainframeStringTable[id][index];
    }

    public static String getDialogString(int id, int index) {
        if (dialogStringTable == null || id >= dialogStringTable.length || index >= dialogStringTable[id].length) {
            return "";
        }
        return dialogStringTable[id][index];
    }

    public static String getMessageString(int index) {
        if (messageStringTable == null || index >= messageStringTable.length) {
            return "";
        }
        return messageStringTable[index];
    }

    public static String getStatusString(int index) {
        if (statusStringTable == null || index >= statusStringTable.length) {
            return "";
        }
        return statusStringTable[index];
    }
}

