/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.resource.xsd;

import java.util.Locale;
import jeus.tool.resource.xsd.ElementDocument;
import jeus.tool.resource.xsd.XMLSchemaResource;
import jeus.tool.resource.xsd.XMLSchemaResourceSource;
import jeus.xml.binding.util.JeusBinding;
import jeus.xml.binding.util.JeusBindingInterface;

public class ElementDocumentUtil {
    public static ElementDocument getElementDocument(XMLSchemaResourceSource xsrSource, Object parentElement, String elementName, Locale locale) {
        if (parentElement instanceof JeusBindingInterface) {
            return ElementDocumentUtil.getElementDocument(xsrSource, (JeusBindingInterface)parentElement, elementName, locale);
        }
        if (parentElement instanceof JeusBinding) {
            return ElementDocumentUtil.getElementDocument(xsrSource, (JeusBinding)parentElement, elementName, locale);
        }
        return ElementDocument.SHARED_NULL;
    }

    public static ElementDocument getElementDocument(XMLSchemaResourceSource xsrSource, JeusBindingInterface parentElement, String elementName, Locale locale) {
        try {
            String rootName = parentElement.getRootName(null);
            String id = parentElement.getElementId(elementName);
            XMLSchemaResource xsr = xsrSource.getXMLSchemaResource(rootName, locale);
            if (xsr != null) {
                return xsr.getElementDocument(id);
            }
            return ElementDocument.SHARED_NULL;
        }
        catch (Exception e) {
            return ElementDocument.SHARED_NULL;
        }
    }

    public static ElementDocument getElementDocument(XMLSchemaResourceSource xsrSource, JeusBinding parentElement, String elementName, Locale locale) {
        try {
            String rootName = parentElement.getRootName(null);
            String id = parentElement.getElementId(elementName);
            XMLSchemaResource xsr = xsrSource.getXMLSchemaResource(rootName, locale);
            if (xsr != null) {
                return xsr.getElementDocument(id);
            }
            return ElementDocument.SHARED_NULL;
        }
        catch (Exception e) {
            return ElementDocument.SHARED_NULL;
        }
    }

    public static String getLabel(XMLSchemaResourceSource xsrSource, Object parentElement, String elementName, Locale locale) {
        return ElementDocumentUtil.getElementDocument(xsrSource, parentElement, elementName, locale).getLabel();
    }

    public static String getDescription(XMLSchemaResourceSource xsrSource, Object parentElement, String elementName, Locale locale) {
        return ElementDocumentUtil.getElementDocument(xsrSource, parentElement, elementName, locale).getDescription();
    }

    public static ElementDocument getElementDocument(String baseLocation, XMLSchemaResourceSource xsrSource, Object parentElement, String elementName, Locale locale) {
        if (parentElement instanceof JeusBindingInterface) {
            return ElementDocumentUtil.getElementDocument(baseLocation, xsrSource, (JeusBindingInterface)parentElement, elementName, locale);
        }
        if (parentElement instanceof JeusBinding) {
            return ElementDocumentUtil.getElementDocument(baseLocation, xsrSource, (JeusBinding)parentElement, elementName, locale);
        }
        return ElementDocument.SHARED_NULL;
    }

    public static ElementDocument getElementDocument(String baseLocation, XMLSchemaResourceSource xsrSource, JeusBindingInterface parentElement, String elementName, Locale locale) {
        try {
            String rootName = parentElement.getRootName(null);
            String id = parentElement.getElementId(elementName);
            XMLSchemaResource xsr = xsrSource.getXMLSchemaResource(baseLocation, rootName, locale);
            if (xsr != null) {
                return xsr.getElementDocument(id);
            }
            return ElementDocument.SHARED_NULL;
        }
        catch (Exception e) {
            return ElementDocument.SHARED_NULL;
        }
    }

    public static ElementDocument getElementDocument(String baseLocation, XMLSchemaResourceSource xsrSource, JeusBinding parentElement, String elementName, Locale locale) {
        try {
            String rootName = parentElement.getRootName(null);
            String id = parentElement.getElementId(elementName);
            XMLSchemaResource xsr = xsrSource.getXMLSchemaResource(baseLocation, rootName, locale);
            if (xsr != null) {
                return xsr.getElementDocument(id);
            }
            return ElementDocument.SHARED_NULL;
        }
        catch (Exception e) {
            return ElementDocument.SHARED_NULL;
        }
    }

    public static String getLabel(String baseLocation, XMLSchemaResourceSource xsrSource, Object parentElement, String elementName, Locale locale) {
        return ElementDocumentUtil.getElementDocument(baseLocation, xsrSource, parentElement, elementName, locale).getLabel();
    }

    public static String getDescription(String baseLocation, XMLSchemaResourceSource xsrSource, Object parentElement, String elementName, Locale locale) {
        return ElementDocumentUtil.getElementDocument(baseLocation, xsrSource, parentElement, elementName, locale).getDescription();
    }
}

