/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.resource.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Locale;
import jeus.tool.resource.xsd.ElementDocument;
import jeus.tool.resource.xsd.MultiKey;
import jeus.tool.resource.xsd.XMLSchemaResource;

public class XMLSchemaResourceSource {
    private HashMap _cache = new HashMap();
    public static final String XMLSCHEMA_RESOURCE_EXTENSION = ".xsr";
    public static final String XMLSCHEMA_BASELOCATION = "jeus/tool/resource/xsd/";

    protected MultiKey buildKey(String location, Locale locale) {
        return new MultiKey(new Object[]{location, locale.toString()}, false);
    }

    public XMLSchemaResource getXMLSchemaResource(String baseLocation, String schemaName, Locale locale) {
        XMLSchemaResource resource;
        String location;
        MultiKey key = this.buildKey(schemaName, locale);
        XMLSchemaResource result = (XMLSchemaResource)this._cache.get(key);
        if (result != null) {
            return result;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (baseLocation != null && baseLocation.trim().length() != 0 && !baseLocation.endsWith("/")) {
            baseLocation = baseLocation + "/";
        }
        try {
            location = baseLocation + schemaName + XMLSCHEMA_RESOURCE_EXTENSION;
            result = this.readXMLSchemaResource(location);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (language != null) {
            try {
                location = baseLocation + schemaName + "_" + language + XMLSCHEMA_RESOURCE_EXTENSION;
                resource = this.readXMLSchemaResource(location);
                if (resource != null) {
                    result = resource;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (language != null && country != null) {
            try {
                location = baseLocation + schemaName + "_" + language + "_" + country + XMLSCHEMA_RESOURCE_EXTENSION;
                resource = this.readXMLSchemaResource(location);
                if (resource != null) {
                    result = resource;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (language != null && country != null && variant != null) {
            try {
                location = baseLocation + schemaName + "_" + language + "_" + country + "_" + variant + XMLSCHEMA_RESOURCE_EXTENSION;
                resource = this.readXMLSchemaResource(location);
                if (resource != null) {
                    result = resource;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (result != null) {
            this._cache.put(key, result);
        }
        return result;
    }

    public void reset() {
        this._cache.clear();
    }

    public XMLSchemaResource getXMLSchemaResource(String schemaName, Locale locale) {
        return this.getXMLSchemaResource(XMLSCHEMA_BASELOCATION, schemaName, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLSchemaResource readXMLSchemaResource(String location) throws IOException, ClassNotFoundException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (is == null) {
            return null;
        }
        ObjectInputStream input = new ObjectInputStream(is);
        try {
            XMLSchemaResource xMLSchemaResource = (XMLSchemaResource)input.readObject();
            return xMLSchemaResource;
        }
        finally {
            input.close();
        }
    }

    public static void main(String[] args) {
        XMLSchemaResourceSource src = new XMLSchemaResourceSource();
        XMLSchemaResource resource = src.getXMLSchemaResource("", "jeus-system", Locale.getDefault());
        XMLSchemaResourceSource.printLabel(resource, resource.getRoot());
    }

    public static void printLabel(XMLSchemaResource resource, ElementDocument elemDoc) {
        System.err.println(elemDoc.getLabel() + ":" + elemDoc.getDescription());
        for (int i = 0; i < elemDoc.getChildren().size(); ++i) {
            XMLSchemaResourceSource.printLabel(resource, resource.getElementDocument(elemDoc.getChildren().get(i).toString()));
        }
    }
}

