/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FileUtil {
    private static final int cBlock = 4096;

    public static void copy(String src, String dest) throws IOException, SecurityException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        FileUtil.copy(srcFile, destFile);
    }

    public static void copy(File src, File dest) throws IOException, SecurityException {
        File parent = dest.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dest);
        FileUtil.copy(is, os);
        os.close();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        is.close();
    }

    public static void rmdir(String dir) {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        FileUtil.rmdir(dirFile);
    }

    public static void rmdir(File dir) {
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            return;
        }
        for (int i = 0; i < filesInDir.length; ++i) {
            File file = filesInDir[i];
            if (file.isDirectory()) {
                FileUtil.rmdir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public static File[] listAllFiles(String dir) {
        File dirFile = new File(dir);
        return FileUtil.listAllFiles(dirFile);
    }

    public static File[] listAllFiles(File dir) {
        Vector allFiles = FileUtil.getAllFiles(dir);
        allFiles.remove(dir);
        File[] files = new File[allFiles.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)allFiles.get(i);
        }
        return files;
    }

    public static Vector getAllFiles(File dir) {
        Vector<File> allFiles = new Vector<File>();
        allFiles.add(dir);
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            return allFiles;
        }
        for (int i = 0; i < filesInDir.length; ++i) {
            File file = filesInDir[i];
            if (file.isDirectory()) {
                Enumeration e = FileUtil.getAllFiles(file).elements();
                while (e.hasMoreElements()) {
                    allFiles.add((File)e.nextElement());
                }
                continue;
            }
            allFiles.add(file);
        }
        return allFiles;
    }

    public static boolean isEARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isWARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("WEB-INF/web.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isEJBJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ejb-jar.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isRARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ra.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isAppClientJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application-client.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void copyDirectory(String srcDir, String destDir) throws IOException {
        File srcDirFile = new File(srcDir);
        File[] srcDirFiles = srcDirFile.listFiles();
        FileUtil.makeDirectory(destDir);
        for (int i = 0; i < srcDirFiles.length; ++i) {
            File srcFile = srcDirFiles[i];
            if (srcFile.isFile()) {
                File targetFile = new File(destDir + File.separator + srcDirFiles[i].getName());
                FileUtil.copy(srcDirFiles[i], targetFile);
                continue;
            }
            FileUtil.copyDirectory(srcFile.getAbsolutePath(), destDir + File.separator + srcFile.getName());
        }
    }

    public static void makeDirectory(String directory) {
        FileUtil.makeDirectory(new File(directory));
    }

    public static void makeDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

