/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.xmlui.TabXMLUIPanel;
import jeus.tool.xmlui.XMLUIComponentList;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.XMLUIPanelFactory;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.schema.XMLUIElement;
import jeus.tool.xmlui.util.MessageUtil;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class ChoiceXMLUIPanel
extends XMLUIPanel
implements ActionListener {
    private String title = "List Display Pane";
    public XMLUIContainer configContainer;
    Element myTree;
    public Vector excludeList = new Vector();
    public Vector displayList = new Vector();
    public Hashtable panelList = new Hashtable();
    public Hashtable buttonTable = new Hashtable();
    public ButtonGroup buttonGroup = new ButtonGroup();
    public JPanel cardPane = new JPanel();
    protected String externalID = "";

    public ChoiceXMLUIPanel(XMLUISession session, Object descriptor) {
        super(session, descriptor);
        XMLUIContainer anyConfig = (XMLUIContainer)descriptor;
        this.title = anyConfig.getDisplayName();
        this.configContainer = anyConfig;
        if (anyConfig.getGlobalID() != null) {
            this.externalID = anyConfig.getGlobalID();
        }
        try {
            this.setInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String val) {
        this.externalID = val;
    }

    public String getSelectedName() {
        int index = 0;
        Enumeration<AbstractButton> enum1 = this.buttonGroup.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton myButton = (JRadioButton)enum1.nextElement();
            if (myButton.isSelected()) {
                return (String)this.excludeList.get(index);
            }
            ++index;
        }
        return null;
    }

    public boolean contains(String name) {
        return this.excludeList.contains(name);
    }

    private void setInit() throws Exception {
        String dispName;
        String name;
        this.setLayout(new BorderLayout());
        JPanel radioPane = new JPanel();
        radioPane.setLayout(new FlowLayout());
        this.cardPane.setLayout(new CardLayout());
        XMLUIElement[] subItems = this.configContainer.getConfigItem();
        XMLUIContainer[] subContainers = this.configContainer.getConfigContainer();
        for (int i = 0; i < subItems.length; ++i) {
            name = subItems[i].getName();
            dispName = MessageUtil.getMessage(this.getEngine(), subItems[i].getDisplayName());
            this.excludeList.add(name);
            this.displayList.add(dispName);
            this.cardPane.add((Component)this.getItemPanel(subItems[i]), name);
            JRadioButton radio = new JRadioButton(dispName);
            radioPane.add((Component)radio, null);
            this.buttonTable.put(name, radio);
            this.buttonGroup.add(radio);
            radio.addActionListener(this);
            if (i != 0) continue;
            radio.setSelected(true);
        }
        for (int j = 0; j < subContainers.length; ++j) {
            name = subContainers[j].getName();
            dispName = MessageUtil.getMessage(this.getEngine(), subContainers[j].getDisplayName());
            this.excludeList.add(name);
            this.displayList.add(dispName);
            XMLUIPanel cpane = XMLUIPanelFactory.createXMLUIPanel(subContainers[j], false, this.getSession());
            this.panelList.put(name, cpane);
            this.cardPane.add((Component)cpane, name);
            JRadioButton radio = new JRadioButton(dispName);
            radioPane.add((Component)radio, null);
            this.buttonTable.put(name, radio);
            radio.addActionListener(this);
            this.buttonGroup.add(radio);
            if (j != 0 || subItems.length != 0) continue;
            radio.setSelected(true);
        }
        this.add((Component)radioPane, "North");
        this.add((Component)this.cardPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        int index = 0;
        Enumeration<AbstractButton> enum1 = this.buttonGroup.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton myButton = (JRadioButton)enum1.nextElement();
            if (myButton.isSelected()) {
                CardLayout cl = (CardLayout)this.cardPane.getLayout();
                cl.show(this.cardPane, (String)this.excludeList.get(index));
            }
            ++index;
        }
    }

    public JPanel getItemPanel(XMLUIElement subItem) {
        JPanel backPanel = new JPanel();
        backPanel.setLayout(new GridBagLayout());
        XMLUIPanel confPanel = TabXMLUIPanel.attatchConfigItem(this.getSession(), backPanel, subItem, 1, 0);
        this.panelList.put(subItem.getName(), confPanel);
        backPanel.add(Box.createVerticalGlue(), new GridBagConstraints(1, 1, 0, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        return backPanel;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration<AbstractButton> enum1 = this.buttonGroup.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton radio = (JRadioButton)enum1.nextElement();
            radio.setEnabled(enabled);
        }
        Enumeration keys = this.panelList.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            XMLUIPanel panel = (XMLUIPanel)this.panelList.get(key);
            panel.setEnabled(enabled);
        }
    }

    public void setChanged(XMLUIPanel panel) {
        if (panel.isChanged() && !this.isChanged()) {
            this.setChanged(true);
        }
    }

    public Object getConfigurationValue() throws XMLConverterException {
        this.clearMessage();
        if (!this.isEnabled()) {
            return null;
        }
        String selectedName = null;
        int index = 0;
        Enumeration<AbstractButton> enum1 = this.buttonGroup.getElements();
        while (enum1.hasMoreElements()) {
            JRadioButton myButton = (JRadioButton)enum1.nextElement();
            if (myButton.isSelected()) {
                selectedName = (String)this.excludeList.get(index);
                break;
            }
            ++index;
        }
        if (selectedName == null) {
            return null;
        }
        XMLUIPanel myPane = (XMLUIPanel)this.panelList.get(selectedName);
        Object value = myPane.getValue();
        if (myPane instanceof XMLUIComponentList) {
            XMLUIComponentList multiItemTable = (XMLUIComponentList)myPane;
            Vector<Element> itemValues = new Vector<Element>();
            String[] valueList = (String[])multiItemTable.getValue();
            if (valueList != null && valueList.length > 0) {
                for (int k = 0; k < valueList.length; ++k) {
                    if (valueList[k] == null || valueList[k].trim().equals("")) continue;
                    Element elementTree = XMLUtil.createElement(this.getSession().getDocument(), selectedName, valueList[k]);
                    itemValues.addElement(elementTree);
                }
            }
            return itemValues;
        }
        this.myTree = (Element)value;
        this.setChanged(myPane);
        this.addMessage(myPane.getMessage());
        XMLUIPanel panel = (XMLUIPanel)this.panelList.get(selectedName);
        if (panel instanceof TabXMLUIPanel) {
            XMLUIContainer config = ((TabXMLUIPanel)panel).getConfigContainer();
            boolean isRequired = Boolean.valueOf(config.getRequired());
            if (this.myTree != null && this.myTree.getChildNodes().getLength() == 0 && !"empty".equals(config.getType()) && !isRequired) {
                return null;
            }
        } else {
            XMLUIComponent configItem = (XMLUIComponent)panel;
            if (this.myTree == null && configItem.isRequired()) {
                this.addMessage(this.buildRequiredElementMessage(configItem.getName()));
            }
        }
        return this.myTree;
    }

    protected String buildRequiredElementMessage(String name) {
        return "You must enter @XPATH@ element.";
    }

    public Object getValue() {
        Object val = null;
        try {
            val = this.getConfigurationValue();
        }
        catch (XMLConverterException e) {
            e.printStackTrace();
        }
        return val;
    }

    public void setValue(Object val) {
        if (val instanceof Element) {
            Element valTree = (Element)val;
            this.setConfigurationValue(valTree);
        }
        if (val instanceof Vector) {
            Vector vals = (Vector)val;
            this.setConfigurationValue(vals);
        }
    }

    public void setConfigurationValue(Vector vals) {
        if (vals == null || vals.size() == 0) {
            return;
        }
        Element oneTree = (Element)vals.get(0);
        String configName = XMLUtil.getName(oneTree);
        JRadioButton selectedBT = (JRadioButton)this.buttonTable.get(configName);
        selectedBT.setSelected(true);
        CardLayout cl = (CardLayout)this.cardPane.getLayout();
        cl.show(this.cardPane, configName);
        XMLUIPanel myPane = (XMLUIPanel)this.panelList.get(configName);
        if (myPane instanceof XMLUIComponentList) {
            XMLUIComponentList myTable = (XMLUIComponentList)myPane;
            String[] tmpList = new String[vals.size()];
            for (int x = 0; x < tmpList.length; ++x) {
                Element tmpTree = (Element)vals.get(x);
                tmpList[x] = XMLUtil.getValue(tmpTree);
            }
            myTable.setValue(tmpList);
        } else {
            this.setConfigurationValue(oneTree);
        }
    }

    public void setConfigurationValue(Element valTree) {
        String name = XMLUtil.getName(valTree);
        this.myTree = valTree;
        JRadioButton selectedBT = (JRadioButton)this.buttonTable.get(name);
        selectedBT.setSelected(true);
        CardLayout cl = (CardLayout)this.cardPane.getLayout();
        cl.show(this.cardPane, name);
        XMLUIPanel myPane = (XMLUIPanel)this.panelList.get(name);
        myPane.setValue(valTree);
    }

    public void resetValue() {
        String name = (String)this.excludeList.get(0);
        JRadioButton selectedBT = (JRadioButton)this.buttonTable.get(name);
        selectedBT.setSelected(true);
        CardLayout cl = (CardLayout)this.cardPane.getLayout();
        cl.first(this.cardPane);
        Enumeration elementEnum = this.panelList.keys();
        while (elementEnum.hasMoreElements()) {
            String itemName = (String)elementEnum.nextElement();
            XMLUIPanel confElementPane = (XMLUIPanel)this.panelList.get(itemName);
            confElementPane.resetValue();
        }
    }
}

