/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jeus.tool.xmlui.TabXMLUIPanel;
import jeus.tool.xmlui.XMLUIDialog;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.util.MessageUtil;

public class ListXMLUIPanel
extends TabXMLUIPanel
implements ListSelectionListener,
ChangeListener {
    private JPanel wrapper;
    private JTabbedPane listTab;
    private JList tabList;
    private JList expertList;
    private DefaultListModel model;
    private DefaultListModel expertModel;
    private boolean expertMode = false;
    private int selectedIndex = 0;

    public ListXMLUIPanel(XMLUIEngine engine, Object descriptor) {
        super(engine, descriptor);
    }

    public ListXMLUIPanel(XMLUISession session, Object descriptor) {
        super(session, descriptor);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.listTab.getSelectedIndex() == 1) {
            this.expertMode = true;
            Item item = (Item)this.tabList.getSelectedValue();
            if (item != null) {
                String name = item.displayName;
                for (int i = 0; i < this.expertModel.getSize(); ++i) {
                    if (!((Item)this.expertModel.getElementAt((int)i)).displayName.equals(name)) continue;
                    this.selectedIndex = i;
                    this.expertList.setSelectedIndex(i);
                    break;
                }
            }
            if (this.expertList.getSelectedIndex() < 0) {
                this.selectedIndex = 0;
                this.expertList.setSelectedIndex(0);
            }
        } else {
            this.expertMode = false;
            boolean found = false;
            Item item = (Item)this.expertList.getSelectedValue();
            if (item != null) {
                String name = item.displayName;
                for (int i = 0; i < this.model.getSize(); ++i) {
                    if (!((Item)this.model.getElementAt((int)i)).displayName.equals(name)) continue;
                    this.selectedIndex = i;
                    this.tabList.setSelectedIndex(i);
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (item != null) {
                    item.panel.createConfig();
                    Vector msg = item.panel.getMessage();
                    if (msg != null && msg.size() > 0) {
                        XMLUIDialog dlg = XMLUIDialog.getDlg(msg);
                        dlg.removeCancel();
                        if (dlg != null) {
                            dlg.showDialog();
                            this.listTab.setSelectedIndex(1);
                            return;
                        }
                    }
                }
                this.selectedIndex = 0;
                this.tabList.setSelectedIndex(0);
                this.replaceConfigPane((Item)this.tabList.getSelectedValue());
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        JList list = null;
        list = this.expertMode ? this.expertList : this.tabList;
        if (this.eating) {
            this.selectedIndex = list.getSelectedIndex();
            return;
        }
        if (this.selectedIndex != list.getSelectedIndex()) {
            Item item = (Item)list.getModel().getElementAt(this.selectedIndex);
            if (item != null) {
                item.panel.createConfig();
                Vector msg = item.panel.getMessage();
                if (msg != null && msg.size() > 0) {
                    XMLUIDialog dlg = XMLUIDialog.getDlg(msg);
                    dlg.removeCancel();
                    if (dlg != null) {
                        dlg.showDialog();
                        list.setSelectedIndex(this.selectedIndex);
                        return;
                    }
                }
            }
            this.selectedIndex = list.getSelectedIndex();
            item = (Item)list.getSelectedValue();
            if (item != null) {
                this.replaceConfigPane(item);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    protected void beginInitSubContainers(XMLUIContainer[] subContainers) {
        this.wrapper = new JPanel();
        this.tabList = new JList();
        this.expertList = new JList();
        this.model = new DefaultListModel();
        this.expertModel = new DefaultListModel();
        this.wrapper.setLayout(new GridBagLayout());
        this.tabList.setSelectionMode(0);
        this.tabList.setModel(this.model);
        this.tabList.setCellRenderer(new ItemCellRender());
        this.tabList.setSelectionBackground(Color.decode("#597FBF"));
        this.tabList.setSelectionForeground(Color.WHITE);
        this.expertList.setSelectionMode(0);
        this.expertList.setModel(this.expertModel);
        this.expertList.setCellRenderer(new ItemCellRender());
        this.expertList.setSelectionBackground(Color.decode("#597FBF"));
        this.expertList.setSelectionForeground(Color.WHITE);
        JScrollPane tabListScroll = new JScrollPane(this.tabList);
        tabListScroll.setMinimumSize(new Dimension(150, 1));
        tabListScroll.setMaximumSize(new Dimension(150, 1));
        tabListScroll.setPreferredSize(new Dimension(150, 1));
        JScrollPane expertListScroll = new JScrollPane(this.expertList);
        expertListScroll.setMinimumSize(new Dimension(150, 1));
        expertListScroll.setMaximumSize(new Dimension(150, 1));
        expertListScroll.setPreferredSize(new Dimension(150, 1));
        this.listTab = new JTabbedPane();
        this.listTab.addTab(MessageUtil.getMessage(this.getEngine(), "message:xmlui.basic", "Basic"), tabListScroll);
        this.listTab.addTab(MessageUtil.getMessage(this.getEngine(), "message:xmlui.expert", "Expert"), expertListScroll);
        this.listTab.addChangeListener(this);
        this.listTab.setTabPlacement(3);
        this.basicPane.setLayout(new GridBagLayout());
        this.basicPane.add((Component)this.wrapper, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addConfigPane(XMLUIContainer subContainer, XMLUIPanel newPanel, int colspan, int rowspan, int x, int y) {
        if (!this._OnlyOneSubContainer) {
            super.addConfigPane(subContainer, newPanel, colspan, rowspan, x, y);
            Item item = this.createItem(subContainer, newPanel);
            if (!Boolean.valueOf(subContainer.getExpert()).booleanValue()) {
                this.model.addElement(item);
            }
            this.expertModel.addElement(item);
        } else {
            this.basicPane.add((Component)newPanel, new GridBagConstraints(x, y, colspan, rowspan, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    protected void endInitSubContainers(XMLUIContainer[] subContainers, int x, int y, int colspan, int rowspan) {
        if (!this._OnlyOneSubContainer && this.model.getSize() > 0) {
            Item firstItem = (Item)this.model.get(0);
            this.tabList.setSelectedIndex(0);
            this.replaceConfigPane(firstItem);
        }
        this.tabList.addListSelectionListener(this);
        this.expertList.addListSelectionListener(this);
        Component list = null;
        list = this.expertModel.getSize() == this.model.getSize() ? this.listTab.getComponent(0) : this.listTab;
        this.basicPane.add(list, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void replaceConfigPane(Item item) {
        this.wrapper.removeAll();
        this.wrapper.add((Component)new JScrollPane(item.panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.wrapper.updateUI();
    }

    public int getItemCount() {
        if (this.model != null) {
            return this.model.getSize();
        }
        return 0;
    }

    protected Item createItem(XMLUIContainer subContainer, XMLUIPanel panel) {
        Item item = new Item();
        item.panel = panel;
        item.displayName = panel.getTitle();
        item.smallIcon = panel.getSmallIcon();
        return item;
    }

    public void resetValue() {
        super.resetValue();
        if (this.tabList.getSelectedIndex() >= 0) {
            this.tabList.setSelectedIndex(this.tabList.getSelectedIndex());
        } else {
            this.tabList.setSelectedIndex(0);
        }
        this.expertList.setSelectedIndex(0);
    }

    private static class ItemCellRender
    extends DefaultListCellRenderer {
        private Border focusBorder = BorderFactory.createLineBorder(Color.BLACK, 1);

        private ItemCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Item) {
                Item item = (Item)value;
                this.setText(" " + item.displayName + " ");
                if (item.smallIcon != null) {
                    this.setIcon(item.smallIcon);
                } else {
                    this.setIcon(null);
                }
            } else if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? this.focusBorder : noFocusBorder);
            return this;
        }
    }

    private static class Item {
        public XMLUIPanel panel;
        public String displayName;
        public Icon smallIcon;

        private Item() {
        }
    }
}

