/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.text.MessageFormat;
import jeus.tool.xmlui.component.IValidator;
import jeus.tool.xmlui.component.ValidationException;

public abstract class BaseValidator
extends IValidator {
    private boolean _required;
    private String _requiredMessage;

    public BaseValidator() {
    }

    protected BaseValidator(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    protected String formatString(String pattern, Object[] args) {
        return MessageFormat.format(pattern, args);
    }

    protected String formatString(String pattern, Object arg) {
        return this.formatString(pattern, new Object[]{arg});
    }

    protected String formatString(String pattern, Object arg1, Object arg2) {
        return this.formatString(pattern, new Object[]{arg1, arg2});
    }

    protected boolean checkRequired(String name, String value) throws ValidationException {
        boolean isEmpty = this.isBlank(value);
        if (this._required && isEmpty) {
            throw new ValidationException(this.buildRequiredMessage(name));
        }
        return isEmpty;
    }

    protected boolean isBlank(String input) {
        if (input == null || input.length() == 0) {
            return true;
        }
        return input.trim().length() == 0;
    }

    public String getRequiredMessage() {
        return this._requiredMessage;
    }

    public void setRequiredMessage(String string) {
        this._requiredMessage = string;
    }

    protected String buildRequiredMessage(String name) {
        return "You must enter a value for @XPATH@.";
    }
}

