/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import jeus.tool.xmlui.component.ScrollableTextArea;
import jeus.tool.xmlui.component.ValidationException;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Node;

public class XMLUITextArea
extends XMLUIComponent
implements FocusListener {
    private ScrollableTextArea textArea = new ScrollableTextArea(3, 1);
    private String value;
    private boolean changed;

    public XMLUITextArea() {
        this.textArea.addFocusListener(this);
        this.textArea.setSize(1, 35);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textArea, "Center");
    }

    public JComponent getItemComp() {
        return this.textArea;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setEnabled(boolean val) {
        this.textArea.setEnabled(val);
    }

    public void resetValue() {
        String item = this.getDefaultValue() != null ? this.getDefaultValue() : "";
        this.textArea.setText(item);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        String currentValue = this.textArea.getText();
        if (!(currentValue != null && currentValue.equals(this.value) || currentValue != null && currentValue.length() == 0 && this.value == null || this.value != null && this.value.length() == 0 && currentValue == null || this.value == currentValue)) {
            this.setChanged(true);
        }
    }

    public void setValue(Object value) {
        this.value = value instanceof Node ? XMLUtil.getValue((Node)value) : value.toString();
        this.textArea.setText(this.value == null ? "" : this.value);
    }

    public Object getValue() {
        this.clearMessage();
        String currentValue = this.textArea.getText();
        if (this.getValidator() != null) {
            try {
                this.getValidator().validate(this.getName(), currentValue);
            }
            catch (ValidationException e) {
                this.addMessage(e.getMessage());
                return null;
            }
        }
        if (this.getDefaultValue() != null) {
            if (this.getSession().isWriteDefault()) {
                if (currentValue == null || currentValue.trim().length() == 0) {
                    currentValue = this.getDefaultValue();
                }
            } else if (this.getDefaultValue().equals(currentValue)) {
                return null;
            }
        }
        if (currentValue != null && currentValue.trim().length() > 0) {
            return XMLUtil.createElement(this.getSession().getDocument(), this.getName(), currentValue);
        }
        return null;
    }

    public void replaceValueWithCurrentValue() {
        this.value = this.textArea.getText();
    }
}

