/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.engine;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import jeus.tool.xmlui.util.XMLUtil;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChangeHistory {
    public static final String HISTORY = "jeus.tool.xmlui.history";
    private List history = new ArrayList();

    public void execute(Document document) {
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        Element root = document.getDocumentElement();
        for (int i = 0; i < this.history.size(); ++i) {
            Change change = (Change)this.history.get(i);
            String prefix = root.getPrefix();
            String xpath = change.getXpath().replaceAll("'" + root.getNamespaceURI() + "'", prefix == null ? "" : prefix);
            try {
                NodeList nodeList = xpathAPI.selectNodeList(document, xpath);
                System.err.println(xpath + ":" + nodeList.getLength());
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node = nodeList.item(j);
                    XMLUtil.setValue(node, change.getValue().toString());
                }
                continue;
            }
            catch (TransformerException e) {
                // empty catch block
            }
        }
        this.clear();
    }

    public void addChange(String xpath, Object value) {
        this.history.add(new Change(value, xpath));
    }

    public void clear() {
        this.history.clear();
    }

    private static class Change {
        private String _xpath;
        private Object _value;

        public Change(Object _value, String _xpath) {
            this._value = _value;
            this._xpath = _xpath;
        }

        public Object getValue() {
            return this._value;
        }

        public String getXpath() {
            return this._xpath;
        }
    }
}

