/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.schema;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jeus.tool.xmlui.schema.XMLUIBase;
import jeus.tool.xmlui.schema.XMLUIElement;

public class XMLUIContainer
implements Serializable,
XMLUIBase,
Cloneable {
    public static final String LAYOUT_TAB = "tab";
    public static final String LAYOUT_LIST = "list";
    public static final String LAYOUT_FLAT = "flat";
    public static final String FILL_HORIZONTAL = "horizontal";
    public static final String FILL_VERTICAL = "vertical";
    public static final String FILL_BOTH = "both";
    public static final String GENERAL_NAME = "$general$";
    public static final String GENERAL_KEY = "message:general";
    public static final String DIRECTION_VERTICAL = "vertical";
    public static final String DIRECTION_HORIZONTAL = "horizontal";
    private String _name;
    private String _displayName;
    private String _multi = "false";
    private String _complex = "false";
    private String _multiDisplayName;
    private String _multiColumnParser;
    private Vector _configItemList;
    private Vector _configContainerList;
    private String _required = "false";
    private String _containerUIClass;
    private String _subContainerUIClass;
    private String _tabListenerClass;
    private String _blind = "false";
    private String _expert = "false";
    private String _type;
    private String _globalID;
    private String _description;
    private String _layOut;
    private String _subLayOut;
    private String _generalLayOut;
    private String _parentLayOut;
    private String _smallIcon;
    private String _bigIcon;
    private String _generalSmallIcon;
    private String _generalBigIcon;
    private String _selectable;
    private String _fill;
    private String[] _columnNames;
    private String[] _columnExprs;
    private String _direction;
    private String _namespaceURI;
    private String _readonly;
    private String _listmode;
    private int minOccurs = 0;
    private int maxOccurs = 1;

    public XMLUIContainer() {
        this.setMulti("false");
        this.setComplex("false");
        this._configItemList = new Vector();
        this._configContainerList = new Vector();
        this._globalID = String.valueOf(System.currentTimeMillis());
    }

    public String getSelectable() {
        return this._selectable;
    }

    public void setSelectable(String _selectable) {
        this._selectable = _selectable;
    }

    public String getParentLayOut() {
        return this._parentLayOut;
    }

    public void setParentLayOut(String parentLayOut) {
        this._parentLayOut = parentLayOut;
    }

    public String getBigIcon() {
        return this._bigIcon;
    }

    public void setBigIcon(String _bigIcon) {
        this._bigIcon = _bigIcon;
    }

    public String getSmallIcon() {
        return this._smallIcon;
    }

    public void setSmallIcon(String _smallIcon) {
        this._smallIcon = _smallIcon;
    }

    public String getGeneralBigIcon() {
        return this._generalBigIcon;
    }

    public void setGeneralBigIcon(String _bigIcon) {
        this._generalBigIcon = _bigIcon;
    }

    public String getGeneralSmallIcon() {
        return this._generalSmallIcon;
    }

    public void setGeneralSmallIcon(String _smallIcon) {
        this._generalSmallIcon = _smallIcon;
    }

    public void addConfigContainer(XMLUIContainer vConfigContainer) throws IndexOutOfBoundsException {
        this._configContainerList.addElement(vConfigContainer);
        vConfigContainer.setParentLayOut(this.getLayOut());
    }

    public void addConfigContainer(int index, XMLUIContainer vConfigContainer) throws IndexOutOfBoundsException {
        this._configContainerList.insertElementAt(vConfigContainer, index);
    }

    public void addConfigItem(XMLUIElement vConfigItem) throws IndexOutOfBoundsException {
        this._configItemList.addElement(vConfigItem);
    }

    public void addConfigItem(int index, XMLUIElement vConfigItem) throws IndexOutOfBoundsException {
        this._configItemList.insertElementAt(vConfigItem, index);
    }

    public Enumeration enumerateConfigContainer() {
        return this._configContainerList.elements();
    }

    public Enumeration enumerateConfigItem() {
        return this._configItemList.elements();
    }

    public String getComplex() {
        return this._complex;
    }

    public String getRequired() {
        if (this.minOccurs == 1) {
            return "true";
        }
        return "false";
    }

    public String getBlind() {
        return this._blind;
    }

    public void setExpert(String expert) {
        this._expert = expert == null || Boolean.valueOf(expert) == false ? "false" : "true";
    }

    public String getExpert() {
        return this._expert;
    }

    public String getType() {
        return this._type;
    }

    public String getGlobalID() {
        return this._globalID;
    }

    public XMLUIContainer getConfigContainer(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configContainerList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (XMLUIContainer)this._configContainerList.elementAt(index);
    }

    public XMLUIContainer[] getConfigContainer() {
        int size = this._configContainerList.size();
        XMLUIContainer[] mArray = new XMLUIContainer[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (XMLUIContainer)this._configContainerList.elementAt(index);
        }
        return mArray;
    }

    public int getConfigContainerCount() {
        return this._configContainerList.size();
    }

    public XMLUIElement getConfigItem(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (XMLUIElement)this._configItemList.elementAt(index);
    }

    public XMLUIElement[] getConfigItem() {
        int size = this._configItemList.size();
        XMLUIElement[] mArray = new XMLUIElement[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (XMLUIElement)this._configItemList.elementAt(index);
        }
        return mArray;
    }

    public int getConfigItemCount() {
        return this._configItemList.size();
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            this._displayName = this.createDisplayName();
        }
        return this._displayName;
    }

    private String createDisplayName() {
        if (this._name.equals(GENERAL_NAME)) {
            return GENERAL_KEY;
        }
        StringBuffer buf = new StringBuffer();
        char[] arr = this._name.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '$') continue;
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public String getMulti() {
        if (this.maxOccurs > 1) {
            return "true";
        }
        return "false";
    }

    public String getMultiDisplayName() {
        return this._multiDisplayName;
    }

    public String getMultiColumnParser() {
        return this._multiColumnParser;
    }

    public String getName() {
        return this._name;
    }

    public String getContainerUIClass() {
        return this._containerUIClass;
    }

    public String getSubContainerUIClass() {
        return this._subContainerUIClass;
    }

    public String getTabListenerClass() {
        return this._tabListenerClass;
    }

    public void removeAllConfigContainer() {
        this._configContainerList.removeAllElements();
    }

    public void removeAllConfigItem() {
        this._configItemList.removeAllElements();
    }

    public XMLUIContainer removeConfigContainer(int index) {
        Object obj = this._configContainerList.elementAt(index);
        this._configContainerList.removeElementAt(index);
        return (XMLUIContainer)obj;
    }

    public XMLUIElement removeConfigItem(int index) {
        Object obj = this._configItemList.elementAt(index);
        this._configItemList.removeElementAt(index);
        return (XMLUIElement)obj;
    }

    public void setComplex(String complex) {
        this._complex = complex;
    }

    public void setConfigContainer(int index, XMLUIContainer vConfigContainer) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configContainerList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._configContainerList.setElementAt(vConfigContainer, index);
    }

    public void setConfigContainer(XMLUIContainer[] configContainerArray) {
        this._configContainerList.removeAllElements();
        for (int i = 0; i < configContainerArray.length; ++i) {
            this._configContainerList.addElement(configContainerArray[i]);
        }
    }

    public void setConfigItem(int index, XMLUIElement vConfigItem) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._configItemList.setElementAt(vConfigItem, index);
    }

    public void setConfigItem(XMLUIElement[] configItemArray) {
        this._configItemList.removeAllElements();
        for (int i = 0; i < configItemArray.length; ++i) {
            this._configItemList.addElement(configItemArray[i]);
        }
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public void setMultiDisplayName(String multiDisplayName) {
        this._multiDisplayName = multiDisplayName;
    }

    public void setMultiColumnParser(String multiColumnParser) {
        this._multiColumnParser = multiColumnParser;
    }

    public void setMulti(String multi) {
        this._multi = multi;
    }

    public void setRequired(String required) {
        this._required = required;
    }

    public void setBlind(String val) {
        this._blind = val;
    }

    public void setType(String val) {
        this._type = val;
    }

    public String getLayOut() {
        if (this._layOut == null || this._layOut.trim().length() == 0) {
            return LAYOUT_TAB;
        }
        return this._layOut;
    }

    public void setLayOut(String _layOut) {
        this._layOut = _layOut;
    }

    public String getSubLayOut() {
        if (this._subLayOut == null || this._subLayOut.trim().length() == 0) {
            return LAYOUT_TAB;
        }
        return this._subLayOut;
    }

    public void setSubLayOut(String subLayOut) {
        this._subLayOut = subLayOut;
    }

    public void setGlobalID(String val) {
        Enumeration enum1;
        this._globalID = val;
        if (this._configContainerList != null) {
            enum1 = this._configContainerList.elements();
            while (enum1.hasMoreElements()) {
                XMLUIContainer childContainer = (XMLUIContainer)enum1.nextElement();
                childContainer.setGlobalID(this._globalID);
            }
        }
        if (this._configItemList != null) {
            enum1 = this._configItemList.elements();
            while (enum1.hasMoreElements()) {
                XMLUIElement childItem = (XMLUIElement)enum1.nextElement();
                childItem.setGlobalID(this._globalID);
            }
        }
    }

    public void setContainerUIClass(String name) {
        this._containerUIClass = name;
    }

    public void setSubContainerUIClass(String name) {
        this._subContainerUIClass = name;
    }

    public void setTabListenerClass(String name) {
        this._tabListenerClass = name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public XMLUIContainer cloneMe() {
        return (XMLUIContainer)this.clone();
    }

    public Object clone() {
        try {
            int i;
            XMLUIContainer cc2 = (XMLUIContainer)super.clone();
            if (this._configContainerList != null) {
                for (i = 0; i < this.getConfigContainerCount(); ++i) {
                    cc2.setConfigContainer(i, this.getConfigContainer(i).cloneMe());
                }
            }
            if (this._configItemList != null) {
                for (i = 0; i < this.getConfigItemCount(); ++i) {
                    cc2.setConfigItem(i, (XMLUIElement)this.getConfigItem(i).clone());
                }
            }
            return cc2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAnySubName() {
        if (this.getConfigItemCount() > 0) {
            return this.getConfigItem(0).getName();
        }
        if (this.getConfigContainerCount() > 0) {
            return this.getConfigContainer(0).getName();
        }
        return null;
    }

    public String getFill() {
        return this._fill;
    }

    public void setFill(String _fill) {
        this._fill = _fill;
    }

    public String[] getColumnNames() {
        if (this._columnNames == null) {
            return new String[0];
        }
        return this._columnNames;
    }

    public void setColumnNames(String[] _columnNames) {
        this._columnNames = _columnNames;
    }

    public String[] getColumnExprs() {
        if (this._columnExprs == null) {
            return new String[0];
        }
        return this._columnExprs;
    }

    public void setColumnExprs(String[] _columnExprs) {
        this._columnExprs = _columnExprs;
    }

    public String getDirection() {
        if (this._direction == null || this._direction.trim().length() == 0) {
            return "vertical";
        }
        return this._direction;
    }

    public void setDirection(String _direction) {
        this._direction = _direction;
    }

    public String getGeneralLayOut() {
        if (this._generalLayOut == null) {
            return LAYOUT_FLAT;
        }
        return this._generalLayOut;
    }

    public void setGeneralLayOut(String _generalLayOut) {
        this._generalLayOut = _generalLayOut;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public void setNamespaceURI(String _namespaceURI) {
        this._namespaceURI = _namespaceURI;
    }

    public String getReadonly() {
        return this._readonly;
    }

    public void setReadonly(String readonly) {
        this._readonly = readonly;
    }

    public void setListmode(String listmode) {
        this._listmode = listmode;
    }

    public String getListmode() {
        return this._listmode;
    }
}

