/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.schema;

import com.sun.org.apache.xerces.internal.parsers.XMLGrammarPreparser;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XSGrammar;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSComplexTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSModelGroup;
import com.sun.org.apache.xerces.internal.xs.XSNamespaceItem;
import com.sun.org.apache.xerces.internal.xs.XSNamespaceItemList;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSParticle;
import com.sun.org.apache.xerces.internal.xs.XSSimpleTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSTerm;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;

public class XMLUIGenerator {
    public static final int BIG_PRIME = 2039;
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    public static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final short CARDINALITY_ZERO_OR_ONE = 0;
    public static final short CARDINALITY_ONE = 1;
    public static final short CARDINALITY_ZERO_OR_MORE = 2;
    public static final short CARDINALITY_ONE_OR_MORE = 3;
    public static final int EXIT_SUCCESS = 1;
    public static final int EXIT_FAIL = 0;
    public static boolean DEBUG = false;
    public static Set primTypes = new HashSet();

    public void generate(String src, String formout, String root, String namespace) throws Exception {
        XSElementDeclaration rootTerm;
        XSModel model = this.getModel(src);
        XSNamespaceItemList nsList = model.getNamespaceItems();
        XSNamespaceItem nsItem = null;
        for (int i = 0; i < nsList.getLength(); ++i) {
            XSNamespaceItem item = nsList.item(i);
            String ns = item.getSchemaNamespace();
            if (ns == null && namespace == null) {
                nsItem = item;
            } else if (ns != null && ns.equals(namespace)) {
                nsItem = item;
            }
            if (nsItem != null) break;
        }
        if (nsItem == null) {
            this.log("Can't find " + namespace + " name space.");
            System.exit(0);
        }
        if ((rootTerm = nsItem.getElementDeclaration(root)) == null) {
            this.log("Can't find " + namespace + " root element.");
            System.exit(0);
        }
        XMLTree rootTree = new XMLTree("xmlui");
        rootTree.addAttribute("target-namespace", namespace);
        this.processTerm(rootTerm, rootTree, 1, 1, rootTerm);
        XMLUtil util = new XMLUtil();
        util.generate(rootTree);
        util.save(new File(formout));
    }

    private void processTerm(XSTerm term, XMLTree parent, int minOccurs, int maxOccurs, XSElementDeclaration ed) {
        switch (term.getType()) {
            case 7: {
                this.processModelGroup((XSModelGroup)term, parent, minOccurs, maxOccurs, ed);
                break;
            }
            case 2: {
                this.processElementDeclaration((XSElementDeclaration)term, parent, minOccurs, maxOccurs);
                break;
            }
            default: {
                this.log("JXForm doesn't supprt WILDCARD.");
            }
        }
    }

    private void processElementDeclaration(XSElementDeclaration ed, XMLTree parent, int minOccurs, int maxOccurs) {
        XSTypeDefinition typeDef = ed.getTypeDefinition();
        switch (typeDef.getTypeCategory()) {
            case 13: {
                this.processComplexType((XSComplexTypeDefinition)typeDef, parent, minOccurs, maxOccurs, ed);
                break;
            }
            case 14: {
                this.processSimpleType((XSSimpleTypeDefinition)typeDef, parent, minOccurs, maxOccurs, ed);
                break;
            }
        }
    }

    private void processComplexType(XSComplexTypeDefinition typeDef, XMLTree parent, int minOccurs, int maxOccurs, XSElementDeclaration ed) {
        switch (typeDef.getContentType()) {
            case 2: {
                this.processTerm(typeDef.getParticle().getTerm(), parent, minOccurs, maxOccurs, ed);
                break;
            }
            case 1: {
                this.processSimpleType(typeDef.getSimpleType(), parent, minOccurs, maxOccurs, ed);
                break;
            }
            case 0: {
                XMLTree ctree = new XMLTree("element");
                ctree.addAttribute("name", ed.getName());
                ctree.addAttribute("type", "empty");
                parent.addElement(ctree);
                break;
            }
            default: {
                this.log("MIXED Not supported");
            }
        }
    }

    private void processSimpleType(XSSimpleTypeDefinition typeDef, XMLTree parent, int minOccurs, int maxOccurs, XSElementDeclaration ed) {
        if (typeDef.getVariety() != 1) {
            this.log("JXForm supports only ATOMIC varierty.");
            return;
        }
        XMLTree ctree = null;
        if ((typeDef.getDefinedFacets() & 0x800) == 2048) {
            ctree = new XMLTree("element");
            ctree.addAttribute("name", ed.getName());
            ctree.addAttribute("type", "choice");
            StringList enum1 = typeDef.getLexicalEnumeration();
            for (int i = 0; i < enum1.getLength(); ++i) {
                XMLTree etree = new XMLTree("item", enum1.item(i));
                ctree.addElement(etree);
            }
        } else {
            String type = null;
            for (XSTypeDefinition baseType = typeDef; baseType != null && !primTypes.contains(type = baseType.getName()); baseType = baseType.getBaseType()) {
            }
            if (type == null) {
                type = "string";
            }
            if (type != null) {
                ctree = new XMLTree("element");
            }
            ctree.addAttribute("name", ed.getName());
            ctree.addAttribute("type", type);
            if ((typeDef.getDefinedFacets() & 4) == 4) {
                this.addMinMax(ctree, "max-length", typeDef.getLexicalFacetValue((short)4), type);
            }
            if ((typeDef.getDefinedFacets() & 2) == 2) {
                this.addMinMax(ctree, "min-length", typeDef.getLexicalFacetValue((short)2), type);
            }
            if ((typeDef.getDefinedFacets() & 1) == 1) {
                this.addMinMax(ctree, "length", typeDef.getLexicalFacetValue((short)1), type);
            }
            if ((typeDef.getDefinedFacets() & 0x20) == 32) {
                this.addMinMax(ctree, "max-inclusive", typeDef.getLexicalFacetValue((short)32), type);
            }
            if ((typeDef.getDefinedFacets() & 0x100) == 256) {
                this.addMinMax(ctree, "min-inclusive", typeDef.getLexicalFacetValue((short)256), type);
            }
            if ((typeDef.getDefinedFacets() & 0x40) == 64) {
                this.addMinMax(ctree, "max-exclusive", typeDef.getLexicalFacetValue((short)64), type);
            }
            if ((typeDef.getDefinedFacets() & 0x80) == 128) {
                this.addMinMax(ctree, "min-exclusive", typeDef.getLexicalFacetValue((short)128), type);
            }
            if ((typeDef.getDefinedFacets() & 8) == 8) {
                this.addMinMax(ctree, "pattern", typeDef.getLexicalFacetValue((short)8), type);
            }
        }
        if (minOccurs > 0) {
            ctree.addAttribute("min-occurs", String.valueOf(minOccurs));
        }
        if (maxOccurs > 1) {
            if (maxOccurs < Integer.MAX_VALUE) {
                ctree.addAttribute("max-occurs", String.valueOf(maxOccurs));
            } else {
                ctree.addAttribute("max-occurs", "unbounded");
            }
        }
        if (ctree != null && ed.getConstraintType() == 1 || ed.getConstraintType() == 2) {
            ctree.addAttribute("default", ed.getConstraintValue());
        }
        parent.addElement(ctree);
    }

    private void addMinMax(XMLTree tree, String name, String value, String type) {
        if (value == null) {
            return;
        }
        if ((type.equals("int") || type.equals("string")) && (value.equals(String.valueOf(Integer.MAX_VALUE)) || value.equals(String.valueOf(Integer.MIN_VALUE)))) {
            return;
        }
        if (type.equals("long") && (value.equals(String.valueOf(Long.MAX_VALUE)) || value.equals(String.valueOf(Long.MIN_VALUE)))) {
            return;
        }
        if (type.equals("float") && (value.equals(String.valueOf(Float.MAX_VALUE)) || value.equals(String.valueOf(Float.MIN_VALUE)))) {
            return;
        }
        if (type.equals("double") && (value.equals(String.valueOf(Double.MAX_VALUE)) || value.equals(String.valueOf(Double.MIN_VALUE)))) {
            return;
        }
        tree.addAttribute(name, value);
    }

    private void processModelGroup(XSModelGroup mg, XMLTree parent, int minOccurs, int maxOccurs, XSElementDeclaration ed) {
        switch (mg.getCompositor()) {
            case 1: {
                this.processCompositor(mg, parent, (short)1, minOccurs, maxOccurs, ed);
                break;
            }
            case 2: {
                this.processCompositor(mg, parent, (short)2, minOccurs, maxOccurs, ed);
                break;
            }
            default: {
                this.log("JXForm doesn't supprt ALL compositor.");
            }
        }
    }

    private void processCompositor(XSModelGroup mg, XMLTree parent, short compositor, int minOccurs, int maxOccurs, XSElementDeclaration ed) {
        XSParticle particle;
        int i;
        XSObjectList particles = mg.getParticles();
        String name = ed.getName();
        XMLTree container = null;
        if (name.equals(parent.getAttribute("name"))) {
            container = parent;
        } else {
            container = new XMLTree("container");
            container.addAttribute("name", name);
            parent.addElement(container);
            parent = container;
        }
        if (compositor == 1) {
            if (minOccurs > 0) {
                container.addAttribute("min-occurs", String.valueOf(minOccurs));
            }
            if (maxOccurs > 1) {
                if (maxOccurs < Integer.MAX_VALUE) {
                    container.addAttribute("max-occurs", String.valueOf(maxOccurs));
                } else {
                    container.addAttribute("max-occurs", "unbounded");
                }
            }
            if (minOccurs == 0 && maxOccurs == 1) {
                for (i = 0; i < particles.getLength(); ++i) {
                    particle = (XSParticle)particles.item(i);
                    if (particle.getMinOccurs() != 1) continue;
                    container.addAttribute("selectable", "true");
                    break;
                }
            }
        } else {
            XMLTree choice = new XMLTree("choice");
            choice.addAttribute("name", "$" + name + "$");
            if (minOccurs > 0) {
                container.addAttribute("min-occurs", String.valueOf(minOccurs));
            }
            if (maxOccurs > 1) {
                if (maxOccurs < Integer.MAX_VALUE) {
                    container.addAttribute("max-occurs", String.valueOf(maxOccurs));
                } else {
                    container.addAttribute("max-occurs", "unbounded");
                }
            }
            container.addElement(choice);
            parent = choice;
        }
        for (i = 0; i < particles.getLength(); ++i) {
            particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (particle.getMaxOccursUnbounded()) {
                this.processTerm(term, parent, particle.getMinOccurs(), Integer.MAX_VALUE, ed);
                continue;
            }
            this.processTerm(term, parent, particle.getMinOccurs(), particle.getMaxOccurs(), ed);
        }
    }

    private boolean isSimpleType(XSTerm term) {
        if (term.getType() != 2) {
            return false;
        }
        XSElementDeclaration ed = (XSElementDeclaration)term;
        XSTypeDefinition typeDef = ed.getTypeDefinition();
        if (typeDef.getTypeCategory() == 14) {
            return true;
        }
        XSComplexTypeDefinition complexTypeDef = (XSComplexTypeDefinition)typeDef;
        return complexTypeDef.getContentType() == 1;
    }

    private void log(String msg) {
        System.err.println(msg);
    }

    private XSModel getModel(String src) throws IOException {
        SymbolTable symTable = new SymbolTable(2039);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(symTable);
        preparser.registerPreparser(SCHEMA_NAMESPACE, null);
        preparser.setFeature(NAMESPACES_FEATURE_ID, true);
        preparser.setFeature(VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        Grammar g = preparser.preparseGrammar(SCHEMA_NAMESPACE, new XMLInputSource(null, src, null));
        XSGrammar xsg = (XSGrammar)g;
        return xsg.toXSModel();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            return;
        }
        String namespace = null;
        if (args.length == 4) {
            namespace = args[3];
        }
        XMLUIGenerator generator = new XMLUIGenerator();
        DEBUG = true;
        generator.generate(args[0], args[1], args[2], namespace);
    }

    static {
        primTypes.add("int");
        primTypes.add("long");
        primTypes.add("float");
        primTypes.add("double");
        primTypes.add("string");
        primTypes.add("boolean");
        primTypes.add("date");
        primTypes.add("dateTime");
    }
}

