/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import javax.transaction.xa.Xid;
import jeus.transaction.TMInfo;
import jeus.transaction.ThreadContexts;
import jeus.transaction.XidImpl;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.util.XidToString;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM2;

public class GTID
implements Serializable {
    static final long serialVersionUID = -5666009527101199151L;
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private TMInfo tmInfo;
    protected long ltid;
    private byte[] id;
    private int hashCode = -1;
    private String str;
    private boolean local;
    protected boolean invalid;
    protected transient Xid externalXid;
    private static final int SIZE_GTID_EXCEPT_TMINFO = 8;
    private static final byte[] DUMMY_BYTES = new byte[0];
    private transient XidImpl xidFormat;
    public static final int MAX_GTID_SIZE = 24;

    public GTID(Xid xid) {
        if (logger.isLoggable(JeusMessage_TM2._4301_LEVEL)) {
            logger.logp(JeusMessage_TM2._4301_LEVEL, "GTID", "<init>", JeusMessage_TM2._4301);
        }
        this.externalXid = xid;
    }

    public GTID(TMInfo tmServer, long ltid) {
        this(tmServer, ltid, null);
    }

    public GTID(TMInfo tmServer, long ltid, Xid xid) {
        this.tmInfo = tmServer;
        this.ltid = ltid;
        this.externalXid = xid;
        if (logger.isLoggable(JeusMessage_TM2._4303_LEVEL)) {
            logger.logp(JeusMessage_TM2._4303_LEVEL, "GTID", "<init>", JeusMessage_TM2._4303, (Object)this);
        }
    }

    public GTID(TMInfo tmServer, long ltid, Xid xid, int serverStartTime) {
        this.tmInfo = new TMInfo(tmServer.getIPAddress(), tmServer.getPort(), serverStartTime, tmServer.getVirtualPort());
        this.ltid = ltid;
        this.externalXid = xid;
        if (logger.isLoggable(JeusMessage_TM2._4303_LEVEL)) {
            logger.logp(JeusMessage_TM2._4303_LEVEL, "GTID", "<init>", JeusMessage_TM2._4303, (Object)this);
        }
    }

    public GTID(byte[] id) {
        this(id, 0);
    }

    public GTID(byte[] id, int offset) {
        this.setGTID(id, offset);
        if (logger.isLoggable(JeusMessage_TM2._4304_LEVEL)) {
            logger.logp(JeusMessage_TM2._4304_LEVEL, "GTID", "<init>", JeusMessage_TM2._4304, (Object)this);
        }
    }

    public void setGTID(byte[] id) {
        this.setGTID(id, 0);
    }

    protected void setGTID(byte[] id, int offset) {
        this.tmInfo = new TMInfo(id, offset);
        int tmInfoLength = this.tmInfo.getByteLength();
        this.ltid = ByteUtil.convertToLong((byte[])id, (int)(tmInfoLength + offset));
        int gtidByteLength = tmInfoLength + 8;
        if (offset == 0 && id.length == gtidByteLength) {
            this.id = id;
        } else {
            byte[] tid = new byte[gtidByteLength];
            System.arraycopy(id, offset, tid, 0, gtidByteLength);
            this.id = tid;
        }
        if (logger.isLoggable(JeusMessage_TM2._4305_LEVEL)) {
            logger.logp(JeusMessage_TM2._4305_LEVEL, "GTID", "setGTID", JeusMessage_TM2._4305, (Object)Utility.getDump((byte[])this.id, (int)offset, (int)gtidByteLength));
        }
        this.str = null;
    }

    public TMInfo getTMInfo() {
        if (logger.isLoggable(JeusMessage_TM2._4306_LEVEL)) {
            logger.logp(JeusMessage_TM2._4306_LEVEL, "GTID", "getTMInfo", JeusMessage_TM2._4306, (Object)this.tmInfo);
        }
        return this.tmInfo;
    }

    public final void setLocal() {
        if (logger.isLoggable(JeusMessage_TM2._4308_LEVEL)) {
            logger.logp(JeusMessage_TM2._4308_LEVEL, "GTID", "setLocal", JeusMessage_TM2._4308, (Object)this);
        }
        this.local = true;
    }

    public final boolean isLocal() {
        return this.local;
    }

    public final byte[] getIPAddress() {
        return this.tmInfo.getIPAddress();
    }

    public final int getPort() {
        return this.tmInfo.getPort();
    }

    public long getLTID() {
        return this.ltid;
    }

    public final void setExternalXid(Xid xid) {
        this.externalXid = xid;
        ThreadContexts.getCoordinator(this).setExternalXid(xid);
        this.str = null;
    }

    public final int getTime() {
        return this.tmInfo.getTime();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GTID) {
            GTID target = (GTID)obj;
            return this.tmInfo.equals(target.tmInfo) && target.ltid == this.ltid;
        }
        return false;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.tmInfo.hashCode() + (int)(this.ltid & Integer.MAX_VALUE);
        }
        return this.hashCode;
    }

    public final byte[] toBytes() {
        if (this.id == null) {
            this.id = this.toBytes(0);
        }
        if (logger.isLoggable(JeusMessage_TM2._4315_LEVEL)) {
            logger.logp(JeusMessage_TM2._4315_LEVEL, "GTID", "toBytes", JeusMessage_TM2._4315, (Object)Utility.getDump((byte[])this.id));
        }
        return this.id;
    }

    public final byte[] toBytes(int offset) {
        byte[] result = new byte[8 + this.tmInfo.getByteLength() + offset];
        this.toBytes(result, offset);
        return result;
    }

    public int getByteLength() {
        return 8 + this.tmInfo.getByteLength();
    }

    public int toBytes(byte[] result, int offset) {
        offset = this.tmInfo.toBytes(result, offset);
        ByteUtil.putLong((byte[])result, (int)offset, (long)this.ltid);
        return offset += 8;
    }

    public String toString() {
        if (this.str == null) {
            this.str = this.externalXid == null ? this.tmInfo.getGTID(this.ltid) : this.tmInfo.getGTID(this.ltid) + " - " + XidToString.getXidString(this.externalXid);
        }
        return this.str;
    }

    public final boolean isServer() {
        return this.tmInfo.isServer();
    }

    public final int getVPort() {
        return this.tmInfo.getVirtualPort();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "invalidate GTID : " + this);
        }
        this.invalid = true;
        this.externalXid = null;
        this.str = null;
    }

    public final Xid getExternalXid() {
        return this.externalXid;
    }

    public final boolean isSameGTID(TMInfo tmServer, IncompletedTx recoverTx) {
        return tmServer.isGeneratedAtThisTM(this) && recoverTx.isSameLTID(this);
    }

    public final Xid getXidFormat() {
        if (this.xidFormat == null) {
            this.xidFormat = new XidImpl(this.toBytes(), DUMMY_BYTES, 9736);
        }
        return this.xidFormat;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.externalXid == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.externalXid.getGlobalTransactionId().length);
            s.write(this.externalXid.getGlobalTransactionId());
            s.writeInt(this.externalXid.getBranchQualifier().length);
            s.write(this.externalXid.getBranchQualifier());
            s.writeInt(this.externalXid.getFormatId());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int gtidLength = s.readInt();
        if (gtidLength != 0) {
            byte[] gtidBytes = new byte[gtidLength];
            int result = s.read(gtidBytes);
            if (result != gtidLength) {
                throw new IOException("error while reading gtid");
            }
            int bqLength = s.readInt();
            byte[] bqBytes = new byte[bqLength];
            result = s.read(bqBytes);
            if (result != bqLength) {
                throw new IOException("error while reading bq");
            }
            int format = s.readInt();
            this.externalXid = new XidImpl(gtidBytes, bqBytes, format);
        }
    }
}

