/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.descriptor.jeusserver.TransactionManagerDescriptor;
import jeus.management.j2ee.transaction.ReferenceInfo;
import jeus.net.ConnectorException;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.PropagationContext;
import jeus.transaction.ServerContextSenderReceiver;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMNotAvailableException;
import jeus.transaction.ThreadContexts;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.comm.TMLink;
import jeus.transaction.comm.TMLinkManager;
import jeus.transaction.logging.HowlLogManager;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.LogManager;
import jeus.transaction.logging.NullLogManager;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.resources.JeusXAResource;
import jeus.transaction.resources.LocalResource;
import jeus.transaction.root.RootCoordinator;
import jeus.transaction.sub.RootCoordinatorDelegate;
import jeus.transaction.sub.SubCoordinator;
import jeus.util.ByteUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.properties.JeusTMProperties;
import jeus.util.properties.JeusTMPropertyValues;
import org.objectweb.howl.log.xa.XACommittingTx;

public final class TMServer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private static int port;
    private static int conId;
    private static TMInfo tmServer;
    public static byte[] bqbase;
    private static final AtomicLong localHandlerIDs;
    private static final byte[] BQ_MAGIC;
    private static final int BQ_SEQ_SIZE = 1;
    public static final int BQ_SEQ_INDEX = 0;
    private static int BQ_PRE_GTID_LENGTH;
    private static final long LOCAL_RESOURCE_RETRIAL_INTERVAL = 120000L;
    private static final long LOCAL_RESOURCE_RETRIAL_COUNT = 30L;
    public static final long SHUTDOWN_LOCK_TIMEOUT = 30000L;
    private static final ReentrantReadWriteLock rRWlock;
    private static final Lock readLock;
    private static final Lock writeLock;
    private static AtomicBoolean running;
    private static LogManager logManager;
    private static TMLinkManager linkManager;
    private static final ConcurrentHashMap failedLocalResources;
    private static AtomicBoolean retrialThreadRunning;

    public static void init(TransactionManagerDescriptor desc, boolean isServerVM) throws TMException {
        boolean success = false;
        if (!running.compareAndSet(false, true)) {
            return;
        }
        writeLock.lock();
        try {
            if (logger.isLoggable(JeusMessage_TM3._5401_LEVEL)) {
                logger.logp(JeusMessage_TM3._5401_LEVEL, "TMServer", "init", JeusMessage_TM3._5401);
            }
            TMConfig.configure(desc);
            JeusTMPropertyValues.isClientTM = false;
            byte[] ipaddr = JeusNetPropertyValues.getLocalInetAddress().getAddress();
            if (logger.isLoggable(JeusMessage_TM3._5415_LEVEL)) {
                logger.logp(JeusMessage_TM3._5415_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5415, (Object)Utility.getDump((byte[])ipaddr));
            }
            if (JeusPropertyValues.JEUS_CATEGORY == 0) {
                String s = System.getProperty("jeus.tm.port");
                if (s != null) {
                    port = Integer.valueOf(s);
                    if (logger.isLoggable(JeusMessage_TM3._5416_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5416_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5416, (Object)String.valueOf(port));
                    }
                }
            } else {
                port = JeusManagerPropertyValues.getBasePort();
                conId = JeusManagerPropertyValues.getContainerID();
                if (logger.isLoggable(JeusMessage_TM3._5557_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5557_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5557, (Object)String.valueOf(port));
                }
            }
            linkManager = new TMLinkManager(TMConfig.nonBlocking, isServerVM);
            long originalStartTime = System.currentTimeMillis();
            int starttime = (int)(originalStartTime % Integer.MAX_VALUE);
            int tmMin = desc != null ? desc.getTMMin() : JeusTMProperties.tmMin;
            int tmMax = desc != null ? desc.getTMMax() : JeusTMProperties.tmMax;
            long tmResizingPeriod = desc != null ? desc.getTMResizingPeriod() : JeusTMProperties.tmResizingPeriod;
            int tmCapacity = desc != null ? desc.getTMCapacity() : JeusTMProperties.tmCapacity;
            ThreadContexts.initContexts(tmCapacity);
            if (logger.isLoggable(JeusMessage_TM3._5404_LEVEL)) {
                logger.logp(JeusMessage_TM3._5404_LEVEL, "TMServer", "init", JeusMessage_TM3._5404);
            }
            port = linkManager.init(ipaddr, port, starttime, conId, tmMin, tmMax, tmResizingPeriod);
            tmServer = linkManager.getMyInfo();
            IncompletedTx.setTMInfo(tmServer);
            if (logger.isLoggable(JeusMessage_TM3._5405_LEVEL)) {
                logger.logp(JeusMessage_TM3._5405_LEVEL, "TMServer", "init", JeusMessage_TM3._5405);
            }
            logManager = JeusTMProperties.NO_LOGGING ? new NullLogManager() : new HowlLogManager(desc != null ? desc.getRecoveryLogDesc() : null);
            bqbase = new byte[4 + tmServer.getByteLength()];
            System.arraycopy(BQ_MAGIC, 0, bqbase, 0, BQ_MAGIC.length);
            tmServer.toBytes(bqbase, BQ_MAGIC.length);
            BQ_PRE_GTID_LENGTH = 1 + bqbase.length;
            if (logger.isLoggable(JeusMessage_TM3._5408_LEVEL)) {
                logger.logp(JeusMessage_TM3._5408_LEVEL, "TMServer", "init", JeusMessage_TM3._5408);
            }
            logManager.start(tmServer, originalStartTime);
            ContextSenderReceiver.setContextSenderReceiver(new ServerContextSenderReceiver());
            if (logger.isLoggable(JeusMessage_TM3._5409_LEVEL)) {
                logger.logp(JeusMessage_TM3._5409_LEVEL, "TMServer", "init", JeusMessage_TM3._5409);
            }
            RecoveryThread t = new RecoveryThread();
            t.start();
            if (logger.isLoggable(JeusMessage_TM3._5412_LEVEL)) {
                logger.logp(JeusMessage_TM3._5412_LEVEL, "TMServer", "init", JeusMessage_TM3._5412, (Object)tmServer);
            }
            success = true;
        }
        catch (Throwable ex) {
            throw new TMException(JeusMessage_TM3._5411, ex);
        }
        finally {
            writeLock.unlock();
            if (!success) {
                TMServer.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        readLock.lock();
        try {
            boolean bl = running.get();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        block7: {
            if (!running.compareAndSet(true, false)) {
                return;
            }
            try {
                if (writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) {
                    try {
                        TMServer.internalDestroy();
                        break block7;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                TMServer.internalDestroy();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                TMServer.internalDestroy();
            }
        }
    }

    private static void internalDestroy() {
        block8: {
            if (logger.isLoggable(JeusMessage_TM3._5445_LEVEL)) {
                logger.logp(JeusMessage_TM3._5445_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5445);
            }
            if (logger.isLoggable(JeusMessage_TM3._5447_LEVEL)) {
                logger.logp(JeusMessage_TM3._5447_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5447);
            }
            try {
                if (logManager != null) {
                    logManager.close();
                }
            }
            catch (TMException ex) {
                if (!logger.isLoggable(JeusMessage_TM3._5449_LEVEL)) break block8;
                logger.logp(JeusMessage_TM3._5449_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5449, (Throwable)((Object)ex));
            }
        }
        if (logger.isLoggable(JeusMessage_TM3._5446_LEVEL)) {
            logger.logp(JeusMessage_TM3._5446_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5446);
        }
        if (linkManager != null) {
            linkManager.unexport();
        }
        retrialThreadRunning.set(false);
        failedLocalResources.clear();
        if (logger.isLoggable(JeusMessage_TM3._5450_LEVEL)) {
            logger.logp(JeusMessage_TM3._5450_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5450);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doRecovery(Map dslist) {
        readLock.lock();
        try {
            if (!running.get()) {
                boolean bl = true;
                return bl;
            }
            if (logManager.inRecovery()) {
                boolean bl = false;
                return bl;
            }
            logManager.resyncXAResources(dslist);
            boolean bl = true;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    static void unspecifiedContextPropagated(byte[] ctx) throws TMNotAvailableException {
        block5: {
            if (logger.isLoggable(Level.FINE)) {
                if (logger.isLoggable(JeusMessage_TM3._5506_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5506_LEVEL, "TMServer", "unspecifiedContextPropagated", JeusMessage_TM3._5506);
                }
                if (logger.isLoggable(JeusMessage_TM3._5556_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5556_LEVEL, "TMServer", "unspecifiedContextPropagated", JeusMessage_TM3._5556, (Object)Thread.currentThread());
                }
            }
            ThreadContexts.dissociateTransactionID();
            int time = ByteUtil.convertToInt((byte[])ctx, (int)1);
            try {
                TMServer.create(time);
            }
            catch (NotSupportedException e) {
                if (!logger.isLoggable(JeusMessage_TM3._5507_LEVEL)) break block5;
                logger.logp(JeusMessage_TM3._5507_LEVEL, "TMServer", "unspecifiedContextPropagated", JeusMessage_TM3._5507, (Throwable)e);
            }
        }
    }

    static Coordinator create(long timeout) throws NotSupportedException, TMNotAvailableException {
        return TMServer.create(null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Coordinator create(Xid xid, long timeout) throws NotSupportedException, TMNotAvailableException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            if (logger.isLoggable(JeusMessage_TM3._5508_LEVEL)) {
                logger.logp(JeusMessage_TM3._5508_LEVEL, "TMServer", "create", JeusMessage_TM3._5508, (Object)String.valueOf(timeout));
            }
            logManager.waitForRecovery();
            if (ThreadContexts.getOnGoingLocalTxNum() != 0) {
                if (logger.isLoggable(JeusMessage_TM3._5510_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5510_LEVEL, "TMServer", "create", JeusMessage_TM3._5510);
                }
                throw new NotSupportedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM3._5510));
            }
            GTID gtid = ThreadContexts.getAssociatedTransactionID();
            if (gtid != null && !gtid.isInvalid()) {
                if (logger.isLoggable(JeusMessage_TM3._5511_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5511_LEVEL, "TMServer", "create", JeusMessage_TM3._5511);
                }
                throw new NotSupportedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM3._5511));
            }
            long ltid = localHandlerIDs.getAndIncrement();
            gtid = new GTID(tmServer, ltid, xid);
            gtid.setLocal();
            RootCoordinator coord = new RootCoordinator(gtid, logManager, timeout);
            ThreadContexts.putCoordinator(ltid, (Coordinator)coord);
            if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "create", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
            }
            ThreadContexts.associateTransactionID(gtid);
            if (logger.isLoggable(JeusMessage_TM3._5512_LEVEL)) {
                logger.logp(JeusMessage_TM3._5512_LEVEL, "TMServer", "create", JeusMessage_TM3._5512);
            }
            JTAStatisticsProvider.incrementActiveCount();
            RootCoordinator rootCoordinator = coord;
            return rootCoordinator;
        }
        finally {
            readLock.unlock();
        }
    }

    static boolean contextPropagated(PropagationContext ctx) throws TMNotAvailableException {
        long timeout = ctx.getTimeout();
        GTID gtid = ctx.getGTID();
        return TMServer.processPropagation(gtid, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processPropagation(GTID gtid, long timeout) throws TMNotAvailableException {
        readLock.lock();
        try {
            boolean result;
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            if (logger.isLoggable(JeusMessage_TM3._5513_LEVEL)) {
                logger.logp(JeusMessage_TM3._5513_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5513, new Object[]{gtid, new Long(timeout)});
            }
            logManager.waitForRecovery();
            if (gtid.getTMInfo().equals(tmServer)) {
                if (logger.isLoggable(JeusMessage_TM3._5515_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5515_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5515, (Object)gtid);
                }
                gtid.setLocal();
                if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
                }
                ThreadContexts.associateTransactionID(gtid);
                result = false;
            } else {
                SubCoordinator coord = (SubCoordinator)ThreadContexts.getCoordinator(gtid);
                if (coord == null) {
                    if (logger.isLoggable(JeusMessage_TM3._5516_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5516_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5516, (Object)gtid);
                    }
                    RootCoordinatorDelegate root = new RootCoordinatorDelegate(gtid.getTMInfo(), gtid.getLTID(), linkManager);
                    coord = new SubCoordinator(root, gtid, timeout);
                    ThreadContexts.putCoordinator(gtid, (Coordinator)coord);
                    if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
                    }
                    ThreadContexts.associateTransactionID(gtid);
                    if (JeusTMProperties.forcedRegister) {
                        if (logger.isLoggable(JeusMessage_TM3._5517_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5517_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5517, (Object)gtid);
                        }
                        coord.registerToRootCoordinator();
                    }
                } else {
                    if (logger.isLoggable(JeusMessage_TM3._5518_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5518_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5518, (Object)gtid);
                    }
                    if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
                    }
                    ThreadContexts.associateTransactionID(gtid);
                }
                result = coord.isRegCheckRequired();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void disconnectContext() {
        if (logger.isLoggable(JeusMessage_TM3._5519_LEVEL)) {
            logger.logp(JeusMessage_TM3._5519_LEVEL, "TMServer", "disconnectContext", JeusMessage_TM3._5519);
        }
        ThreadContexts.dissociateTransactionID();
    }

    public static SubCoordinator getSubCoordinator(GTID gtid) {
        return (SubCoordinator)ThreadContexts.getCoordinator(gtid);
    }

    public static RootCoordinator getRootCoordinator(long ltid) {
        return ThreadContexts.getCoordinator(ltid);
    }

    static void associateThread(GTID gtid) {
        ThreadContexts.associateTransactionID(gtid);
    }

    public static Coordinator getCoordinator() throws InvalidTransactionException {
        return ThreadContexts.getCurrentCoordinator();
    }

    static Coordinator dissociateThread() {
        return ThreadContexts.dissociateFromThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerXAResourceReference(XAResourceFactory factory, String exportName) {
        readLock.lock();
        try {
            if (!running.get()) {
                return;
            }
            if (logManager != null) {
                if (logger.isLoggable(JeusMessage_TM3._5537_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5537_LEVEL, "TMServer", "registerDataSource", JeusMessage_TM3._5537, new Object[]{factory, exportName});
                }
                try {
                    logManager.logXAResourceReference(exportName, factory);
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_TM3._5817_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5817_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5817, (Object)factory, (Throwable)e);
                    }
                }
            } else if (logger.isLoggable(JeusMessage_TM3._5538_LEVEL)) {
                logger.logp(JeusMessage_TM3._5538_LEVEL, "TMServer", "registerDataSource", JeusMessage_TM3._5538);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFailedLocalResource(LocalResource localRsc, byte phase) {
        readLock.lock();
        try {
            if (!running.get()) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TM3._5818_LEVEL)) {
                logger.logp(JeusMessage_TM3._5818_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5818, (Object)localRsc);
            }
            if (failedLocalResources.putIfAbsent(localRsc, new Byte(phase)) != null) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TM3._5820_LEVEL)) {
                logger.logp(JeusMessage_TM3._5820_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5820, (Object)new Integer(failedLocalResources.size()));
            }
            if (!retrialThreadRunning.compareAndSet(false, true)) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TM3._5819_LEVEL)) {
                logger.logp(JeusMessage_TM3._5819_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5819);
            }
            Thread retrialThread = new Thread((Runnable)new LocalResourceRetrialThread(), "LocalResource Rertrial");
            retrialThread.setDaemon(true);
            retrialThread.start();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte getDecisionForUncompletedTx(long ltid, int time) {
        readLock.lock();
        try {
            if (!running.get()) {
                byte by = -1;
                return by;
            }
            byte by = logManager.getDecisionForIncompletedTx(ltid, time);
            return by;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalDecisionForUncompletedExternalTransaction(Xid xid, boolean isCommit) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.setGlobalDecisionForIncompletedTransaction(xid, isCommit);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid[] getIncompleteExternalXids() {
        readLock.lock();
        try {
            if (!running.get()) {
                Xid[] xidArray = new Xid[]{};
                return xidArray;
            }
            Xid[] xidArray = logManager.getIncompleteExternalXids();
            return xidArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetIncompleteTx(Xid xid) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.forgetIncompleteTx(xid);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetIncompleteTxForSubXids(Xid xid) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.forgetIncompleteTxForSubXids(xid);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncompletedTx[] getAllincompletedTx() {
        readLock.lock();
        try {
            if (!running.get()) {
                IncompletedTx[] incompletedTxArray = new IncompletedTx[]{};
                return incompletedTxArray;
            }
            IncompletedTx[] incompletedTxArray = logManager.getAllIncompletedTx();
            return incompletedTxArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid[] getSubXids(TMInfo socketID) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            Xid[] xidArray = logManager.getSubXids(socketID);
            return xidArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkExternalXidIncompleted(Xid xid) {
        readLock.lock();
        try {
            if (!running.get()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = logManager.getIncompletedExternalTx(xid) != null;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceImpl[] getIncompletedOtsResources() {
        readLock.lock();
        try {
            if (!running.get()) {
                ResourceImpl[] resourceImplArray = new ResourceImpl[]{};
                return resourceImplArray;
            }
            ResourceImpl[] resourceImplArray = logManager.getIncompletedOtsResources();
            return resourceImplArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceInfo[] getRecoveredXAResourceInfo() {
        readLock.lock();
        try {
            if (!running.get()) {
                ReferenceInfo[] referenceInfoArray = new ReferenceInfo[]{};
                return referenceInfoArray;
            }
            ReferenceInfo[] referenceInfoArray = logManager.getRecoveredXAResourceInfo();
            return referenceInfoArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceInfo[] getCurrentXAResourceInfo() {
        readLock.lock();
        try {
            if (!running.get()) {
                ReferenceInfo[] referenceInfoArray = new ReferenceInfo[]{};
                return referenceInfoArray;
            }
            ReferenceInfo[] referenceInfoArray = logManager.getCurrentXAResourceInfo();
            return referenceInfoArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeXAResourceInfo(ReferenceInfo ref) {
        readLock.lock();
        try {
            if (!running.get()) {
                return;
            }
            logManager.removeRecoveredReferenceInfo(ref);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIncompleteSubTx(SubCoordinator coord) {
        readLock.lock();
        try {
            if (!running.get()) {
                return;
            }
            logManager.addIncompletedSubTX(coord);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalDecisionForSubXids(Xid xid, boolean commit) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.setGlobalDecisionForSubXids(xid, commit);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIncompleteSubTx(SubCoordinator coord) {
        readLock.lock();
        try {
            if (!running.get()) {
                return;
            }
            logManager.removeIncompleteSubTx(coord);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean completeRecoveredSubCoordinator(GTID gtid, boolean isCommit) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            boolean bl = logManager.completeRecoveredSubCoordinator(gtid, isCommit);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TMLink getLink(TMInfo tmServer) throws ConnectorException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new ConnectorException("TMServer is not initialized or already destroyed");
            }
            TMLink tMLink = linkManager.getLink(tmServer);
            return tMLink;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void waitForRecovery() {
        if (!running.get()) {
            return;
        }
        if (logManager != null) {
            logManager.waitForRecovery();
        }
    }

    public static TMInfo getTMInfo() {
        return tmServer;
    }

    static byte[] makeBQ(GTID gtid, byte seq) {
        byte[] bq = new byte[BQ_PRE_GTID_LENGTH + gtid.getByteLength()];
        bq[0] = seq;
        System.arraycopy(bqbase, 0, bq, 1, bqbase.length);
        gtid.toBytes(bq, BQ_PRE_GTID_LENGTH);
        return bq;
    }

    public static ConcurrentHashMap getFailedLocalResources() {
        return failedLocalResources;
    }

    static {
        conId = -1;
        localHandlerIDs = new AtomicLong(0L);
        BQ_MAGIC = ByteUtil.convertToByte((int)-1416153395);
        rRWlock = new ReentrantReadWriteLock(true);
        readLock = rRWlock.readLock();
        writeLock = rRWlock.writeLock();
        running = new AtomicBoolean(false);
        failedLocalResources = new ConcurrentHashMap();
        retrialThreadRunning = new AtomicBoolean(false);
        TMConfig.initialize();
    }

    private static final class LocalResourceRetrialThread
    implements Runnable {
        private LocalResourceRetrialThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            do {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!retrialThreadRunning.get()) {
                    return;
                }
                Iterator iter = failedLocalResources.keySet().iterator();
                while (iter.hasNext()) {
                    LocalResource localRsc = (LocalResource)iter.next();
                    byte phase = (Byte)failedLocalResources.get(localRsc);
                    int decision = 4;
                    XAResourceFactory xaResourceFactory = null;
                    XAResource newXAResource = null;
                    try {
                        JeusXAResource jeusXAResource;
                        XAResource xaResource = localRsc.getXAResource();
                        if (xaResource instanceof JeusXAResource && (xaResourceFactory = (jeusXAResource = (JeusXAResource)xaResource).getXAResourceFactory()) != null) {
                            try {
                                newXAResource = xaResourceFactory.getXAResource();
                            }
                            catch (Exception e) {
                                localRsc.increaseFailCount();
                                if ((long)localRsc.getFailCount() > 30L) {
                                    iter.remove();
                                }
                                if (logger.isLoggable(JeusMessage_TM3._5823_LEVEL)) {
                                    logger.logp(JeusMessage_TM3._5823_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5823, (Object)localRsc, (Throwable)e);
                                }
                                if (xaResourceFactory == null || newXAResource == null) continue;
                                xaResourceFactory.close(newXAResource);
                                continue;
                            }
                            if (newXAResource != null) {
                                jeusXAResource.replaceXAResource(newXAResource);
                            }
                        }
                        switch (phase) {
                            case 1: {
                                if (logger.isLoggable(JeusMessage_TM3._5822_LEVEL)) {
                                    logger.logp(JeusMessage_TM3._5822_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5822, new Object[]{"commit", localRsc});
                                }
                                decision = localRsc.commit();
                                break;
                            }
                            case 0: 
                            case 2: 
                            case 3: {
                                if (logger.isLoggable(JeusMessage_TM3._5822_LEVEL)) {
                                    logger.logp(JeusMessage_TM3._5822_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5822, new Object[]{"rollback", localRsc});
                                }
                                decision = localRsc.rollback((byte)1);
                                break;
                            }
                        }
                        if (decision != 4) {
                            iter.remove();
                            this.completeTx(localRsc);
                        } else {
                            if ((long)localRsc.getFailCount() > 30L) {
                                iter.remove();
                            }
                            if (logger.isLoggable(JeusMessage_TM3._5823_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5823_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5823, (Object)localRsc);
                            }
                        }
                        if (xaResourceFactory == null || newXAResource == null) continue;
                        xaResourceFactory.close(newXAResource);
                    }
                    catch (Throwable throwable) {
                        if (xaResourceFactory == null) throw throwable;
                        if (newXAResource == null) throw throwable;
                        xaResourceFactory.close(newXAResource);
                        throw throwable;
                    }
                }
                if (!logger.isLoggable(JeusMessage_TM3._5824_LEVEL)) continue;
                logger.logp(JeusMessage_TM3._5824_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5824, (Object)new Integer(failedLocalResources.size()));
            } while (!failedLocalResources.isEmpty());
            retrialThreadRunning.set(false);
        }

        private void completeTx(LocalResource localResource) {
            if (localResource == null) {
                return;
            }
            Xid xid = localResource.getXid();
            if (xid == null) {
                return;
            }
            byte[] gtidBytes = xid.getGlobalTransactionId();
            if (gtidBytes == null) {
                return;
            }
            try {
                GTID jeusGtid = new GTID(gtidBytes);
                IncompletedTx tx = logManager.getIncompletedTx(jeusGtid);
                if (tx == null) {
                    return;
                }
                logManager.logXaDone((XACommittingTx)tx.getHandback());
                logManager.removeIncompletedTx(tx);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static final class RecoveryThread
    extends Thread {
        public RecoveryThread() {
            super("jeus.transaction.TMServer$RecoveryThread");
        }

        public final void run() {
            try {
                logManager.doRecover();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

