/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.naming.Reference;
import jeus.connector.ManagedConnectionHandler;
import jeus.descriptor.jeusserver.TransactionManagerDescriptor;
import jeus.management.j2ee.J2EEServer;
import jeus.management.j2ee.JTAResource;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.server.enginecontainer.EngineContainer;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.TMCommonService;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.logging.ConnectorXAResourceFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusManagerPropertyValues;

public final class TMService
extends TMCommonService {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    public static final TransactionImpl nullTransaction = new TransactionImpl(null, null);

    public static void init(TransactionManagerDescriptor desc) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5701_LEVEL)) {
            logger.logp(JeusMessage_TM3._5701_LEVEL, "TMService", "init", JeusMessage_TM3._5701);
        }
        TMServer.init(desc, true);
        J2EEServer parent = EngineContainer.serverMBean;
        if (parent != null) {
            try {
                JTAResource resource = JTAResource.createMBean(JeusManagerPropertyValues.containerName, parent.getObjectName());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getActiveCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getCommittedCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getRolledbackCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getIncompleteCommitCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getTimeoutRolledbackCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getTimeoutCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getActiveTimeoutCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getPrepareTimeoutCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getPreparedTimeoutCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getCommitTimeoutCount());
                resource.setStatistic((StatisticImpl)JTAStatisticsProvider.getExcutionTime());
            }
            catch (InstanceAlreadyExistsException e) {
                throw new TMException(e);
            }
        }
        if (logger.isLoggable(JeusMessage_TM3._5702_LEVEL)) {
            logger.logp(JeusMessage_TM3._5702_LEVEL, "TMService", "init", JeusMessage_TM3._5702);
        }
    }

    public static void shutdown() {
        if (logger.isLoggable(JeusMessage_TM3._5703_LEVEL)) {
            logger.logp(JeusMessage_TM3._5703_LEVEL, "TMService", "shutdown", JeusMessage_TM3._5703);
        }
        TMServer.shutdown();
        if (logger.isLoggable(JeusMessage_TM3._5704_LEVEL)) {
            logger.logp(JeusMessage_TM3._5704_LEVEL, "TMService", "shutdown", JeusMessage_TM3._5704, (Object)JeusMessage_TM3._5704_LEVEL);
        }
    }

    public static void delistLocalTransaction(ManagedConnectionHandler mch) {
        if (logger.isLoggable(JeusMessage_TM3._5712_LEVEL)) {
            logger.logp(JeusMessage_TM3._5712_LEVEL, "TMService", "delistLocalTransaction", JeusMessage_TM3._5712);
        }
        ThreadContexts.dissociateLocalTransaction(mch);
    }

    public static void enlistLocalTransaction(ManagedConnectionHandler mch) {
        if (logger.isLoggable(JeusMessage_TM3._5713_LEVEL)) {
            logger.logp(JeusMessage_TM3._5713_LEVEL, "TMService", "enlistLocalTransaction", JeusMessage_TM3._5713);
        }
        ThreadContexts.associateLocalTransaction(mch);
    }

    public static void clearLocalTx(int recordedStackHeight) throws TMException {
        List list;
        if (logger.isLoggable(JeusMessage_TM3._5715_LEVEL)) {
            logger.logp(JeusMessage_TM3._5715_LEVEL, "TMService", "clearLocalTx", JeusMessage_TM3._5715);
        }
        if (logger.isLoggable(JeusMessage_TM3._5541_LEVEL)) {
            logger.logp(JeusMessage_TM3._5541_LEVEL, "TMServer", "clearLocalTx", JeusMessage_TM3._5541, (Object)Thread.currentThread());
        }
        if ((list = ThreadContexts.getAssociatedLocalTransactions()) == null) {
            return;
        }
        int currentHeight = list.size();
        if (currentHeight > recordedStackHeight) {
            if (logger.isLoggable(JeusMessage_TM3._5542_LEVEL)) {
                logger.logp(JeusMessage_TM3._5542_LEVEL, "TMServer", "clearLocalTx", JeusMessage_TM3._5542, new Object[]{String.valueOf(currentHeight - recordedStackHeight), Thread.currentThread()});
            }
            for (int i = currentHeight - 1; i >= recordedStackHeight; --i) {
                ManagedConnectionHandler localTx = (ManagedConnectionHandler)list.remove(i);
                localTx.rollbackLocalTx();
            }
            throw new TMException(JeusMessage_TM3._5543);
        }
        if (logger.isLoggable(JeusMessage_TM3._5716_LEVEL)) {
            logger.logp(JeusMessage_TM3._5716_LEVEL, "TMService", "clearLocalTx", JeusMessage_TM3._5716);
        }
    }

    public static void registerConnector(Reference ref, String exportName) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5705_LEVEL)) {
            logger.logp(JeusMessage_TM3._5705_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5705, (Object)exportName);
        }
        ConnectorXAResourceFactory factory = new ConnectorXAResourceFactory(ref);
        TMServer.registerXAResourceReference(factory, exportName);
        if (logger.isLoggable(JeusMessage_TM3._5706_LEVEL)) {
            logger.logp(JeusMessage_TM3._5706_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5706);
        }
    }
}

