/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.resource.spi.XATerminator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.Terminator;
import jeus.transaction.ThreadContexts;
import jeus.transaction.XidImpl;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.root.RootCoordinator;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM2;

public final class TMXAResource
implements XAResource,
XATerminator {
    public static final int STATUS_UNKNOWN = -1;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private static final TMXAResource tmxaResource = new TMXAResource();
    private static final ConcurrentHashMap XID_MAPPER = new ConcurrentHashMap();
    private static final ConcurrentHashMap PREPARED_XIDS = new ConcurrentHashMap();
    private long timeout = TMConfig.activeTO;

    public final int getTransactionTimeout() throws XAException {
        long seconds = this.timeout / 1000L;
        if (seconds > Integer.MAX_VALUE) {
            seconds = Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    public final boolean setTransactionTimeout(int seconds) {
        if (seconds < 0) {
            return false;
        }
        this.timeout = seconds * 1000;
        return true;
    }

    public final boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource instanceof TMXAResource;
    }

    public final Xid[] recover(int flag) throws XAException {
        Xid[] xids = TMServer.getIncompleteExternalXids();
        if (PREPARED_XIDS.size() > 0) {
            ArrayList<Object> incompleteXids = new ArrayList<Object>();
            incompleteXids.addAll(PREPARED_XIDS.values());
            for (int i = 0; i < xids.length; ++i) {
                incompleteXids.add(xids[i]);
            }
            return incompleteXids.toArray(new Xid[incompleteXids.size()]);
        }
        return xids;
    }

    public final int prepare(Xid xid) throws XAException {
        return this.prepare(xid, null);
    }

    public final int prepare(Xid xid, ResourceImpl rsc) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "prepare called for the xid : " + xid);
        }
        String xidString = XidToString.getGtidStringFromXid(xid);
        GTID gtid = (GTID)XID_MAPPER.get(xidString);
        if (PREPARED_XIDS.containsKey(xidString) || gtid == null) {
            return 3;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "xid " + xid + " mapped to the gtid " + gtid);
        }
        try {
            int response;
            RootCoordinator coord = this.checkGTID(gtid, xid, false);
            if (coord == null) {
                response = 106;
            } else {
                coord.setOTSResource(rsc);
                response = Terminator.prepareForXA(coord);
            }
            switch (response) {
                case 0: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "return XA_OK for this xid : " + xid);
                    }
                    PREPARED_XIDS.put(xidString, xid);
                    return 0;
                }
                case 3: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "return XA_RONLY for this xid : " + xid);
                    }
                    XID_MAPPER.remove(xidString);
                    gtid.invalidate();
                    return 3;
                }
            }
            throw new XAException(response);
        }
        catch (XAException ex) {
            XID_MAPPER.remove(xidString);
            gtid.invalidate();
            throw ex;
        }
        catch (Throwable t) {
            XID_MAPPER.remove(xidString);
            gtid.invalidate();
            throw new XAException(-3);
        }
    }

    public final void forget(Xid xid) throws XAException {
        Xid preparedXid = (Xid)PREPARED_XIDS.get(XidToString.getGtidStringFromXid(xid));
        if (preparedXid != null) {
            throw new XAException("cannot forget a prepared transaction");
        }
        try {
            TMServer.forgetIncompleteTx(xid);
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
    }

    public final void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "rollback called for the xid : " + xid);
        }
        String xidString = XidToString.getGtidStringFromXid(xid);
        if (TMServer.checkExternalXidIncompleted(xid)) {
            try {
                TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, false);
            }
            catch (TMException e) {
                if (logger.isLoggable(JeusMessage_TM2._4905_LEVEL)) {
                    logger.log(JeusMessage_TM2._4905_LEVEL, JeusMessage_TM2._4905, (Object)xid, (Throwable)((Object)e));
                }
                throw new XAException(e.getMessage());
            }
            finally {
                XID_MAPPER.remove(xidString);
                PREPARED_XIDS.remove(xidString);
            }
            return;
        }
        GTID gtid = (GTID)XID_MAPPER.get(xidString);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "xid " + xid + " mapped to the gtid " + gtid);
        }
        this.rollback(gtid, xid);
    }

    public final boolean isKnownXid(Xid xid) {
        boolean isKnownXid;
        boolean bl = isKnownXid = TMServer.checkExternalXidIncompleted(xid) || XID_MAPPER.get(XidToString.getGtidStringFromXid(xid)) != null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "check if the xid is started or recovered for JEUS : " + xid + ", isKnown : " + isKnownXid);
        }
        return isKnownXid;
    }

    private void rollback(GTID gtid, Xid xid) throws XAException {
        try {
            RootCoordinator coord = this.checkGTID(gtid, xid, true);
            if (coord != null && Terminator.rollback(coord) == 4) {
                throw new XAException(-7);
            }
        }
        catch (XAException xe) {
            throw xe;
        }
        catch (Throwable t) {
            throw new XAException(-3);
        }
        finally {
            String xidString = XidToString.getGtidStringFromXid(xid);
            XID_MAPPER.remove(xidString);
            PREPARED_XIDS.remove(xidString);
        }
    }

    public final void end(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "end called for the xid : " + xid + ", and flag " + flags);
        }
        if (flags == 0x20000000) {
            GTID gtid = (GTID)XID_MAPPER.get(XidToString.getGtidStringFromXid(xid));
            if (gtid != null) {
                this.rollback(gtid, xid);
            }
        } else {
            ThreadContexts.dissociateTransactionID();
        }
    }

    public final boolean begin(Xid xid) throws TMException {
        boolean setTx;
        String xidString;
        GTID gtid;
        if (logger.isLoggable(JeusMessage_TM2._4203_LEVEL)) {
            logger.logp(JeusMessage_TM2._4203_LEVEL, "ExternalTransactionManager", "begin", JeusMessage_TM2._4203, new Object[]{xid, new Long(this.timeout)});
        }
        if ((gtid = (GTID)XID_MAPPER.get(xidString = XidToString.getGtidStringFromXid(xid))) == null) {
            Coordinator coord;
            if (logger.isLoggable(JeusMessage_TM2._4204_LEVEL)) {
                logger.logp(JeusMessage_TM2._4204_LEVEL, "ExternalTransactionManager", "begin", JeusMessage_TM2._4204);
            }
            try {
                coord = ThreadContexts.getCurrentCoordinator();
            }
            catch (InvalidTransactionException ex) {
                ex.printStackTrace();
                coord = null;
            }
            if (coord != null) {
                gtid = coord.getGTID();
                Xid externalXidOfGTID = gtid.getExternalXid();
                if (externalXidOfGTID != null && XidImpl.equalsXid(xid, externalXidOfGTID)) {
                    setTx = false;
                } else {
                    ThreadContexts.dissociateTransactionID();
                    gtid = this.createTxForForeignTx(xid);
                    setTx = true;
                }
            } else {
                gtid = this.createTxForForeignTx(xid);
                setTx = true;
            }
            XID_MAPPER.put(xidString, gtid);
        } else {
            Coordinator coord;
            Coordinator prevCoordinator;
            if (logger.isLoggable(JeusMessage_TM2._4205_LEVEL)) {
                logger.logp(JeusMessage_TM2._4205_LEVEL, "ExternalTransactionManager", "begin", JeusMessage_TM2._4205, (Object)xid);
            }
            if ((prevCoordinator = ThreadContexts.getCoordinator(gtid)) == null) {
                throw new TMException("the gtid " + gtid + " is invalid, no coordinator");
            }
            try {
                coord = ThreadContexts.getCurrentCoordinator();
            }
            catch (InvalidTransactionException ex) {
                ex.printStackTrace();
                coord = null;
            }
            if (coord == null || !gtid.equals(coord.getGTID())) {
                TMServer.associateThread(gtid);
                setTx = true;
            } else {
                setTx = false;
            }
        }
        return setTx;
    }

    private GTID createTxForForeignTx(Xid xid) throws TMException {
        try {
            TMServer.create(xid, this.timeout);
        }
        catch (NotSupportedException e) {
            ThreadContexts.dissociateTransactionID();
            try {
                TMServer.create(xid, this.timeout);
            }
            catch (NotSupportedException ne) {
                throw new TMException(ne);
            }
        }
        Coordinator coordinator = null;
        try {
            coordinator = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            throw new TMException(JeusMessage_TM2._4206, (Throwable)e);
        }
        if (coordinator == null) {
            throw new TMException("failed to get a coordinator. current thread has not transaction");
        }
        return coordinator.getGTID();
    }

    public final void start(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "start called for the xid : " + xid + ", and flag " + flags);
        }
        try {
            this.begin(xid);
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(e.toString());
        }
    }

    public final void commit(Xid xid) throws TMException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        if (TMServer.checkExternalXidIncompleted(xid)) {
            try {
                TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, true);
            }
            catch (TMException e) {
                if (logger.isLoggable(JeusMessage_TM2._4906_LEVEL)) {
                    logger.log(JeusMessage_TM2._4906_LEVEL, JeusMessage_TM2._4906, (Object)xid, (Throwable)((Object)e));
                }
                throw e;
            }
            finally {
                XID_MAPPER.remove(xidString);
                PREPARED_XIDS.remove(xidString);
            }
            return;
        }
        try {
            this.commit(xid, !PREPARED_XIDS.containsKey(xidString));
        }
        catch (XAException e) {
            throw new TMException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public final void commit(Xid xid, boolean onePhase) throws XAException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RootCoordinator checkGTID(GTID gtid, Xid xid, boolean invalidateGTID) throws XAException {
        RootCoordinator coord;
        if (gtid == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "start is not called for this xid : " + xid);
            }
            throw new XAException(-4);
        }
        if (invalidateGTID) {
            gtid.invalidate();
        }
        if ((coord = TMServer.getRootCoordinator(gtid.getLTID())) != null && !coord.disableActiveTO()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Client transaction timeout for this xid : " + xid);
            }
            throw new XAException(106);
        }
        return coord;
    }

    public static void disconnectThreadContext() {
        TMServer.disconnectContext();
    }

    public static boolean contains(Xid xid) {
        return XID_MAPPER.containsKey(XidToString.getGtidStringFromXid(xid));
    }

    public static int getTxStatus(Xid xid) {
        GTID gtid = (GTID)XID_MAPPER.get(XidToString.getGtidStringFromXid(xid));
        if (gtid == null || gtid.isInvalid()) {
            return -1;
        }
        RootCoordinator coord = (RootCoordinator)ThreadContexts.getCoordinator(gtid);
        if (coord == null) {
            return -1;
        }
        if (coord.isPreparedReadOnly()) {
            return -1;
        }
        return coord.getStatus();
    }

    public static TMXAResource getTMXAResource() {
        return tmxaResource;
    }
}

