/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.logging.Level;
import javax.transaction.InvalidTransactionException;
import jeus.transaction.Coordinator;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.root.RootCoordinator;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;

public final class Terminator {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte commit(RootCoordinator coord) throws IllegalStateException {
        try {
            int response = 0;
            if (coord == null) {
                if (logger.isLoggable(JeusMessage_TM3._5101_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5101_LEVEL, "Terminator", "commit", JeusMessage_TM3._5101);
                }
                try {
                    coord = (RootCoordinator)TMServer.getCoordinator();
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    if (logger.isLoggable(JeusMessage_TM3._5102_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5102_LEVEL, "Terminator", "commit", JeusMessage_TM3._5102);
                    }
                    throw new IllegalStateException("this transaction is already timeout");
                }
            } else if (logger.isLoggable(JeusMessage_TM3._5103_LEVEL)) {
                logger.logp(JeusMessage_TM3._5103_LEVEL, "Terminator", "commit", JeusMessage_TM3._5103, (Object)coord);
            }
            if (coord == null) {
                if (logger.isLoggable(JeusMessage_TM3._5104_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5104_LEVEL, "Terminator", "commit", JeusMessage_TM3._5104);
                }
                throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM3._5104));
            }
            if (logger.isLoggable(JeusMessage_TM3._5105_LEVEL)) {
                logger.logp(JeusMessage_TM3._5105_LEVEL, "Terminator", "commit", JeusMessage_TM3._5105, (Object)coord.getGTID());
            }
            if (!coord.disableActiveTO()) {
                if (logger.isLoggable(JeusMessage_TM3._5106_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5106_LEVEL, "Terminator", "commit", JeusMessage_TM3._5106, (Object)coord.getGTID());
                }
                TMServer.disconnectContext();
                byte by = 1;
                return by;
            }
            coord.beforeCompletion();
            if (coord.isRollbackOnly()) {
                if (logger.isLoggable(JeusMessage_TM3._5107_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5107_LEVEL, "Terminator", "commit", JeusMessage_TM3._5107, (Object)coord.getGTID());
                }
                coord.rollback();
                coord.destroy();
                byte by = 1;
                return by;
            }
            block4 : switch (coord.getNumResources()) {
                case 0: {
                    if (logger.isLoggable(JeusMessage_TM3._5108_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5108_LEVEL, "Terminator", "commit", JeusMessage_TM3._5108, (Object)coord.getGTID());
                    }
                    coord.afterCompletion(3);
                    break;
                }
                case 1: {
                    if (logger.isLoggable(JeusMessage_TM3._5109_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5109_LEVEL, "Terminator", "commit", JeusMessage_TM3._5109, (Object)coord.getGTID());
                    }
                    response = coord.onePhaseCommit();
                    break;
                }
                default: {
                    if (logger.isLoggable(JeusMessage_TM3._5110_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5110_LEVEL, "Terminator", "commit", JeusMessage_TM3._5110, (Object)coord.getGTID());
                    }
                    if (logger.isLoggable(JeusMessage_TM3._5111_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5111_LEVEL, "Terminator", "commit", JeusMessage_TM3._5111, (Object)coord.getGTID());
                    }
                    byte by = coord.prepare();
                    if (logger.isLoggable(JeusMessage_TM3._5112_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5112_LEVEL, "Terminator", "commit", JeusMessage_TM3._5112, new Object[]{coord.getGTID(), TxStatus.getState(by)});
                    }
                    switch (by) {
                        case 0: {
                            if (logger.isLoggable(JeusMessage_TM3._5113_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5113_LEVEL, "Terminator", "commit", JeusMessage_TM3._5113, (Object)coord.getGTID());
                            }
                            if (coord.commit() != 4) break block4;
                            response = 4;
                            JTAStatisticsProvider.incrementIncompleteCommitCount();
                            break block4;
                        }
                        case 1: {
                            if (logger.isLoggable(JeusMessage_TM3._5114_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5114_LEVEL, "Terminator", "commit", JeusMessage_TM3._5114, (Object)coord.getGTID());
                            }
                            coord.rollback();
                            response = 1;
                            break block4;
                        }
                        case 2: {
                            if (logger.isLoggable(JeusMessage_TM3._5115_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5115_LEVEL, "Terminator", "commit", JeusMessage_TM3._5115, (Object)coord.getGTID());
                            }
                            coord.afterCompletion(3);
                            break block4;
                        }
                    }
                }
            }
            if (logger.isLoggable(JeusMessage_TM3._5116_LEVEL)) {
                logger.logp(JeusMessage_TM3._5116_LEVEL, "Terminator", "commit", JeusMessage_TM3._5116, new Object[]{coord.getGTID(), TxStatus.getState((byte)response)});
            }
            coord.destroy();
            byte by = response;
            return by;
        }
        finally {
            ThreadContexts.dissociateTransactionID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte rollback(Coordinator coord) throws IllegalStateException {
        try {
            if (coord == null) {
                if (logger.isLoggable(JeusMessage_TM3._5117_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5117_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5117);
                }
                try {
                    coord = TMServer.getCoordinator();
                }
                catch (InvalidTransactionException e) {
                    if (logger.isLoggable(JeusMessage_TM3._5118_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5118_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5118);
                    }
                    throw new IllegalStateException("this transaction is already timeout");
                }
            } else if (logger.isLoggable(JeusMessage_TM3._5119_LEVEL)) {
                logger.logp(JeusMessage_TM3._5119_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5119, (Object)coord);
            }
            if (coord == null) {
                if (logger.isLoggable(JeusMessage_TM3._5120_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5120_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5120);
                }
                throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM3._5120));
            }
            if (!coord.disableActiveTO()) {
                if (logger.isLoggable(JeusMessage_TM3._5121_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5121_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5121, (Object)coord.getGTID());
                }
                byte e = 1;
                return e;
            }
            if (logger.isLoggable(JeusMessage_TM3._5122_LEVEL)) {
                logger.logp(JeusMessage_TM3._5122_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5122, (Object)coord.getGTID());
            }
            byte result = coord.rollback();
            coord.destroy();
            byte by = result;
            return by;
        }
        finally {
            ThreadContexts.dissociateTransactionID();
        }
    }

    public static byte prepareForXA(RootCoordinator coord) {
        if (coord == null) {
            return -4;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "prepareForXA called for the GTID " + coord.getGTID());
        }
        if (!coord.disableActiveTO()) {
            TMServer.disconnectContext();
            return 106;
        }
        coord.beforeCompletion();
        if (coord.isRollbackOnly()) {
            coord.rollback();
            coord.destroy();
            return 100;
        }
        switch (coord.getNumResources()) {
            case 0: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "No resource for this tx, prepareForXA result is READ_ONLY for the GTID " + coord.getGTID());
                }
                coord.afterCompletion(3);
                coord.destroy();
                return 3;
            }
        }
        byte result = coord.prepare();
        if (logger.isLoggable(JeusMessage_TM3._5124_LEVEL)) {
            logger.logp(JeusMessage_TM3._5124_LEVEL, "Terminator", "prepareForXA", JeusMessage_TM3._5124);
        }
        switch (result) {
            case 0: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "prepareForXA result is XA_OK for the GTID " + coord.getGTID());
                }
                return 0;
            }
            case 1: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "prepareForXA result is ROLLBACK for the GTID " + coord.getGTID());
                }
                coord.rollback();
                coord.destroy();
                return 100;
            }
            case 2: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "prepareForXA result is READ_ONLY for the GTID " + coord.getGTID());
                }
                coord.afterCompletion(3);
                coord.destroy();
                return 3;
            }
        }
        return -3;
    }

    public static byte commitForXA(RootCoordinator coord) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "commitForXA called for the GTID " + coord.getGTID());
        }
        byte response = 0;
        if (coord == null) {
            return 4;
        }
        switch (coord.getNumResources()) {
            case 0: {
                coord.afterCompletion(3);
                break;
            }
            default: {
                if (coord.commit() != 4) break;
                response = 4;
                JTAStatisticsProvider.incrementIncompleteCommitCount();
            }
        }
        coord.destroy();
        return response;
    }
}

