/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Map;
import javax.transaction.InvalidTransactionException;
import jeus.transaction.Coordinator;
import jeus.transaction.TMServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLocal<T> {
    protected T initialValue() {
        return null;
    }

    private Map getTxLocalMap() throws IllegalStateException {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                return coord.getTransaction().getLocalMap();
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        throw new IllegalStateException("There is no active transaction");
    }

    public T get() throws IllegalStateException {
        Map txLocalMap = this.getTxLocalMap();
        if (txLocalMap.containsKey(this)) {
            return (T)txLocalMap.get(this);
        }
        T value = this.initialValue();
        txLocalMap.put(this, value);
        return value;
    }

    public void set(T value) throws IllegalStateException {
        this.getTxLocalMap().put(this, value);
    }

    public void remove() throws IllegalStateException {
        this.getTxLocalMap().remove(this);
    }
}

