/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import jeus.transaction.Coordinator;
import jeus.transaction.TMServer;
import jeus.transaction.TransactionImpl;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    protected static final TransactionSynchronizationRegistryImpl instance = new TransactionSynchronizationRegistryImpl();

    public Object getTransactionKey() {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                return coord.getTransaction();
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        return null;
    }

    public void putResource(Object key, Object value) throws IllegalStateException {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                TransactionImpl tx = coord.getTransaction();
                tx.getLocalMap().put(key, value);
                return;
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        throw new IllegalStateException("There is no active transaction");
    }

    public Object getResource(Object key) throws IllegalStateException {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                TransactionImpl tx = coord.getTransaction();
                return tx.getLocalMap().get(key);
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        throw new IllegalStateException("There is no active transaction");
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                coord.registerInterposedSynchronization(sync);
                return;
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        throw new IllegalStateException("There is no active transaction");
    }

    public int getTransactionStatus() {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                return coord.getStatus();
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        return 6;
    }

    public void setRollbackOnly() throws IllegalStateException {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                coord.setRollbackOnly();
                return;
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        throw new IllegalStateException("There is no active transaction");
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        try {
            Coordinator coord = TMServer.getCoordinator();
            if (coord != null) {
                return coord.isRollbackOnly();
            }
        }
        catch (InvalidTransactionException invalidTransactionException) {
            // empty catch block
        }
        throw new IllegalStateException("There is no active transaction");
    }
}

