/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Hashtable;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import jeus.transaction.Coordinator;
import jeus.transaction.TMServer;
import jeus.transaction.TMXAResource;
import jeus.transaction.TransactionManager;
import jeus.transaction.TransactionManagerImpl;
import jeus.transaction.TransactionSynchronizationRegistryImpl;
import jeus.transaction.UserTransactionImpl;
import jeus.transaction.client.ClientUserTransactionImpl;
import jeus.transaction.client.InterposedTransactionManager;
import jeus.util.properties.JeusTMPropertyValues;

public class TxHelper {
    private TxHelper() {
    }

    public static TransactionManager getTransactionManager() {
        return TransactionManagerImpl.txManager;
    }

    public static UserTransaction getUserTransaction() {
        if (JeusTMPropertyValues.isClientTM) {
            return ClientUserTransactionImpl.userTx;
        }
        return UserTransactionImpl.userTx;
    }

    public static XAResource getTMXAResource() {
        return new TMXAResource();
    }

    public static XAResource getClientInterposedTransactionManager() {
        return TxHelper.getClientInterposedTransactionManager(null);
    }

    public static XAResource getClientInterposedTransactionManager(Hashtable environment) {
        return new InterposedTransactionManager(environment);
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return TransactionSynchronizationRegistryImpl.instance;
    }

    public static boolean isTransactionActive() {
        try {
            return TxHelper.getUserTransaction().getStatus() != 6;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getTransactionRemainingTimeout() {
        Coordinator coordinator = null;
        try {
            coordinator = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            return -1L;
        }
        if (coordinator == null) {
            throw new IllegalStateException("the current thread is not associated with a transaction");
        }
        return coordinator.getRemainingTimeout();
    }
}

