/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

public final class TxStatus {
    public static final byte NOT_SPECIFIED = -2;
    public static final byte UNKNOWN = -1;
    public static final byte COMMIT = 0;
    public static final byte ROLLBACK = 1;
    public static final byte READONLY = 2;
    public static final byte DONE = 3;
    public static final byte HEURISTIC = 4;
    public static final byte LOCALXA = 5;
    public static final byte COMMITWITHLOCALXA = 6;
    public static final byte READONLYWITHLOCALXA = 7;
    public static final byte TIMEOUTROLLBACK = 8;
    public static final byte COMMITTEDWITHLOCALXA = 9;

    public static String getState(byte code) {
        switch (code) {
            case -1: {
                return "unknown";
            }
            case 0: {
                return "commit";
            }
            case 1: {
                return "rollback";
            }
            case 2: {
                return "read only";
            }
            case 3: {
                return "done";
            }
            case 4: {
                return "heuristic";
            }
            case 5: {
                return "local xa";
            }
            case 6: {
                return "commit with local xa";
            }
            case 7: {
                return "read only with local xa";
            }
            case 8: {
                return "timeout rollback";
            }
            case 9: {
                return "committed with local xa";
            }
        }
        return "unspecified code value : " + code;
    }

    public static String getState(int code) {
        switch (code) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
        }
        return "invalid status code : " + code;
    }
}

