/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.net.AcceptorConnectionListener;
import jeus.net.NetworkControlPacket;
import jeus.net.ReplyListener;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.net.impl.SocketStream14;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TxStatus;
import jeus.transaction.XidImpl;
import jeus.transaction.comm.TMLinkManager;
import jeus.transaction.comm.TxControlMessage;
import jeus.transaction.comm.Worker;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.properties.JeusTMProperties;

public final class TMLink
implements AcceptorConnectionListener {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private static final byte[] magic = new byte[3];
    private static final byte[] value0 = new byte[1];
    private static final byte[] value1 = new byte[1];
    private final TMLinkManager manager;
    public TMInfo socketID;
    private SocketStream14 sockStream;

    public TMLink(TMLinkManager manager) {
        this.manager = manager;
        if (logger.isLoggable(JeusMessage_TM1._3001_LEVEL)) {
            logger.logp(JeusMessage_TM1._3001_LEVEL, "TMLink", "<init>", JeusMessage_TM1._3001, (Object)manager.getMyInfo());
        }
    }

    public final void registerResource(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3019_LEVEL)) {
            logger.logp(JeusMessage_TM1._3019_LEVEL, "TMLink", "registerResource", JeusMessage_TM1._3019, (Object)this.socketID.getGTID(ltid));
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)1);
            buffer.putLong(ltid);
            buffer.put((byte)(JeusTMProperties.reliableRegistration ? 1 : 0));
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3020, this.socketID.getGTID(ltid), ex);
        }
    }

    public final void prepare(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3021_LEVEL)) {
            logger.logp(JeusMessage_TM1._3021_LEVEL, "TMLink", "prepare", JeusMessage_TM1._3021, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)5);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3022, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void prepareResponse(long ltid, byte response) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3023_LEVEL)) {
            logger.logp(JeusMessage_TM1._3023_LEVEL, "TMLink", "prepareResponse", JeusMessage_TM1._3023, new Object[]{TxStatus.getState(response), this.socketID.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)6);
            buffer.putLong(ltid);
            buffer.put(response);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3024, new String[]{TxStatus.getState(response), this.socketID.getGTID(ltid)}, ex);
        }
    }

    public final void replayCompletion() throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3025_LEVEL)) {
            logger.logp(JeusMessage_TM1._3025_LEVEL, "TMLink", "replayCompletion", JeusMessage_TM1._3025, (Object)this.socketID);
        }
        try {
            TxControlMessage msg = new TxControlMessage(7);
            msg.setData(new Object[]{this.manager.getMyInfo()});
            this.sockStream.write((Object)msg);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3026, this.socketID.toString(), ex);
        }
    }

    public final void commit(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3029_LEVEL)) {
            logger.logp(JeusMessage_TM1._3029_LEVEL, "TMLink", "commit", JeusMessage_TM1._3029, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)9);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3030, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void commitResponse(long ltid, boolean done) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3031_LEVEL)) {
            logger.logp(JeusMessage_TM1._3031_LEVEL, "TMLink", "commitResponse", JeusMessage_TM1._3031, new Object[]{done ? "done" : "fail", this.socketID.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)10);
            buffer.putLong(ltid);
            buffer.put((byte)(done ? 1 : 0));
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3032, new String[]{done ? "done" : "fail", this.socketID.getGTID(ltid)}, ex);
        }
    }

    public final void rollback(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3033_LEVEL)) {
            logger.logp(JeusMessage_TM1._3033_LEVEL, "TMLink", "rollback", JeusMessage_TM1._3033, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)11);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3034, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void onePhaseCommit(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3035_LEVEL)) {
            logger.logp(JeusMessage_TM1._3035_LEVEL, "TMLink", "onePhaseCommit", JeusMessage_TM1._3035, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)12);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3036, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void onePhaseCommitResponse(long ltid, byte response) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3037_LEVEL)) {
            logger.logp(JeusMessage_TM1._3037_LEVEL, "TMLink", "onePhaseCommitResponse", JeusMessage_TM1._3037, new Object[]{TxStatus.getState(response), this.socketID.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)14);
            buffer.putLong(ltid);
            buffer.put(response);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3038, new String[]{TxStatus.getState(response), this.socketID.getGTID(ltid)}, ex);
        }
    }

    protected final void closeLink() {
        if (logger.isLoggable(JeusMessage_TM1._3039_LEVEL)) {
            logger.logp(JeusMessage_TM1._3039_LEVEL, "TMLink", "closeLink", JeusMessage_TM1._3039);
        }
        this.sockStream.destroy();
        if (logger.isLoggable(JeusMessage_TM1._3041_LEVEL)) {
            logger.logp(JeusMessage_TM1._3041_LEVEL, "TMLink", "closeLink", JeusMessage_TM1._3041);
        }
    }

    public final void remoteCommit(long ltid, boolean isCommit) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3042_LEVEL)) {
            logger.logp(JeusMessage_TM1._3042_LEVEL, "TMLink", "remoteCommit", JeusMessage_TM1._3042, new Object[]{isCommit ? "commit" : "rollback", this.socketID.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)15);
            buffer.putLong(ltid);
            buffer.put((byte)(!isCommit ? 1 : 0));
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3043, new String[]{isCommit ? "commit" : "rollback", this.socketID.getGTID(ltid)}, ex);
        }
    }

    public final void remoteCommitResponse(long ltid, byte response) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3044_LEVEL)) {
            logger.logp(JeusMessage_TM1._3044_LEVEL, "TMLink", "remoteCommitResponse", JeusMessage_TM1._3044, new Object[]{TxStatus.getState(response), this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)16);
            buffer.putLong(ltid);
            buffer.put(response);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3045, new String[]{TxStatus.getState(response), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void registered(long ltid, boolean successful) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3046_LEVEL)) {
            logger.logp(JeusMessage_TM1._3046_LEVEL, "TMLink", "registered", JeusMessage_TM1._3046, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)17);
            buffer.putLong(ltid);
            if (successful) {
                buffer.put((byte)1);
            } else {
                buffer.put((byte)0);
            }
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3047, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void commitLocalXAResource(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3048_LEVEL)) {
            logger.logp(JeusMessage_TM1._3048_LEVEL, "TMLink", "commitLocalXAResource", JeusMessage_TM1._3048, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)18);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3049, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void commitLocalXAResourceResponse(long ltid, boolean commit) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3050_LEVEL)) {
            logger.logp(JeusMessage_TM1._3050_LEVEL, "TMLink", "commitLocalXAResourceResponse", JeusMessage_TM1._3050, new Object[]{commit ? "commit" : "rollback", this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)19);
            buffer.putLong(ltid);
            buffer.put((byte)(!commit ? 1 : 0));
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3051, new String[]{commit ? "commit" : "rollback", this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void beforeCompletion(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3052_LEVEL)) {
            logger.logp(JeusMessage_TM1._3052_LEVEL, "TMLink", "beforeCompletion", JeusMessage_TM1._3052, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)20);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3053, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void beforeCompletionResponse(long ltid, byte response) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3054_LEVEL)) {
            logger.logp(JeusMessage_TM1._3054_LEVEL, "TMLink", "beforeCompletionResponse", JeusMessage_TM1._3054, new Object[]{TxStatus.getState(response), this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)21);
            buffer.putLong(ltid);
            buffer.put(response);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3055, new String[]{TxStatus.getState(response), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void flush(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3057_LEVEL)) {
            logger.logp(JeusMessage_TM1._3057_LEVEL, "TMLink", "flush", JeusMessage_TM1._3057, new Object[]{this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)22);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3058, new String[]{this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void requestFlush(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3059_LEVEL)) {
            logger.logp(JeusMessage_TM1._3059_LEVEL, "TMLink", "requestFlush", JeusMessage_TM1._3059, (Object)this.socketID.getGTID(ltid));
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)24);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3060, this.socketID.getGTID(ltid), ex);
        }
    }

    public final void flushResponse(long ltid, byte response) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3061_LEVEL)) {
            logger.logp(JeusMessage_TM1._3061_LEVEL, "TMLink", "flushResponse", JeusMessage_TM1._3061, new Object[]{TxStatus.getState(response), this.socketID.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)23);
            buffer.putLong(ltid);
            buffer.put(response);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3062, new String[]{TxStatus.getState(response), this.socketID.getGTID(ltid)}, ex);
        }
    }

    public final void flushRequestResponse(long ltid, byte response) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3063_LEVEL)) {
            logger.logp(JeusMessage_TM1._3063_LEVEL, "TMLink", "flushRequestResponse", JeusMessage_TM1._3063, new Object[]{TxStatus.getState(response), this.socketID, this.manager.getGTID(ltid)});
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)25);
            buffer.putLong(ltid);
            buffer.put(response);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3064, new String[]{TxStatus.getState(response), this.socketID.toString(), this.manager.getGTID(ltid)}, ex);
        }
    }

    public final void remoteXAPrepare(long ltid) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3066_LEVEL)) {
            logger.logp(JeusMessage_TM1._3066_LEVEL, "TMLink", "remoteXAPrepare", JeusMessage_TM1._3066);
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(9);
            buffer.put((byte)26);
            buffer.putLong(ltid);
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3067);
        }
    }

    public final void remoteXACommit(long ltid, boolean isCommit) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3068_LEVEL)) {
            logger.logp(JeusMessage_TM1._3066_LEVEL, "TMLink", "remoteXACommit", JeusMessage_TM1._3068);
        }
        try {
            ByteBuffer buffer = this.sockStream.getByteBuffer(10);
            buffer.put((byte)27);
            buffer.putLong(ltid);
            buffer.put((byte)(!isCommit ? 1 : 0));
            this.sockStream.write(buffer);
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3069, ex);
        }
    }

    public final void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        if (this.socketID == null || this.socketID.isServer()) {
            this.manager.pooledExecutorServer.execute(messageProcessor);
        } else {
            this.manager.pooledExecutorClient.execute(messageProcessor);
        }
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public final void connectionConnected(SocketStream sockStream) {
        this.sockStream = (SocketStream14)sockStream;
    }

    public final void connectionEstablished(SocketStream sockStream) {
        this.sockStream = (SocketStream14)sockStream;
    }

    public final void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        this.socketID = (TMInfo)sockStream.getSocketID();
        packet.setData((Object)new Integer(1));
        sockStream.write((Object)packet);
    }

    public final void connectionAccepted(SocketStream sockStream, int connectionType, Object data) {
        this.socketID = (TMInfo)sockStream.getSocketID();
    }

    public final void connectionClosed(Exception exception, SocketStream socketStream) {
        if (exception != null) {
            logger.log(Level.FINE, "exception occurred from TMLink connection : " + socketStream, (Throwable)exception);
        }
    }

    public final void receiveMessage(Object obj, SocketStream socketStream, Object controlInfo) {
        if (logger.isLoggable(JeusMessage_TM1._3016_LEVEL)) {
            logger.logp(JeusMessage_TM1._3016_LEVEL, "NonBlockingTMLink", "init", JeusMessage_TM1._3016);
        }
        try {
            Worker w = new Worker(this.manager.rootProxy, this.manager.subProxy);
            if (obj instanceof byte[]) {
                w.handleRequest(this, (byte[])obj);
            } else {
                w.handleRequest(this, obj);
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_TM1._3018_LEVEL)) {
                logger.logp(JeusMessage_TM1._3018_LEVEL, "NonBlockingTMLink", "handle", JeusMessage_TM1._3018, (Object)this.socketID, ex);
            }
            socketStream.destroy();
        }
    }

    public final Xid[] recover() throws XAException {
        try {
            MsgSync sync = new MsgSync(TMConfig.recoveryTO);
            ByteBuffer buffer = this.sockStream.getReqeustByteBuffer(1);
            buffer.put((byte)28);
            this.sockStream.write(buffer, (ReplyListener)sync);
            TxControlMessage msg = (TxControlMessage)sync.waitReply();
            Object[] result = msg.getData();
            if (result instanceof Xid[]) {
                return (Xid[])result;
            }
            ((Exception)result[0]).printStackTrace();
            throw new XAException(-7);
        }
        catch (XAException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.sockStream.destroy();
            ex.printStackTrace();
            throw new XAException(-3);
        }
    }

    public final void forget(Xid xid) throws XAException {
        try {
            MsgSync sync = new MsgSync(TMConfig.recoveryTO);
            TxControlMessage msg = new TxControlMessage(30);
            msg.setData(new Object[]{new XidImpl(xid)});
            this.sockStream.write((Object)msg, (ReplyListener)sync);
            TxControlMessage reply = (TxControlMessage)sync.waitReply();
            Object[] result = reply.getData();
            if (result != null) {
                ((Throwable)result[0]).printStackTrace();
                throw new XAException(-3);
            }
        }
        catch (Throwable e) {
            this.sockStream.destroy();
            e.printStackTrace();
            throw new XAException(-7);
        }
    }

    public final void writeReply(Object reply) throws IOException {
        this.sockStream.writeReply(reply);
    }

    public final int resourceCompletion(Xid xid, boolean isCommit) throws TMException {
        try {
            MsgSync sync = new MsgSync(0L);
            TxControlMessage msg = new TxControlMessage(29);
            msg.setData(new Object[]{new XidImpl(xid), isCommit});
            this.sockStream.write((Object)msg, (ReplyListener)sync);
            Integer returnCode = (Integer)sync.waitReply();
            return returnCode;
        }
        catch (Throwable e) {
            this.sockStream.destroy();
            throw new TMException(JeusMessage_TM1._3069, e);
        }
    }

    static {
        TMLink.magic[0] = 97;
        TMLink.magic[1] = 36;
        TMLink.magic[2] = 30;
        TMLink.value0[0] = 0;
        TMLink.value1[0] = 1;
    }
}

