/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.external;

import jeus.transaction.XidImpl;
import jeus.util.ByteUtil;
import jeus.util.logging.Utility;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.otid_t;

public final class OTSXid
extends XidImpl {
    private final PropagationContext ctx;
    public static final byte[] JEUS_TID_PREFIX = new byte[]{74, 69, 85, 83};

    public OTSXid(PropagationContext ctx) {
        otid_t otid = ctx.current.otid;
        int formatId = otid.formatID;
        byte[] gtid = new byte[otid.tid.length - otid.bqual_length];
        System.arraycopy(otid.tid, 0, gtid, 0, gtid.length);
        byte[] bq = new byte[otid.bqual_length];
        System.arraycopy(otid.tid, gtid.length, bq, 0, otid.bqual_length);
        this.setXid(gtid, bq, formatId);
        this.ctx = ctx;
    }

    public OTSXid(byte[] gtid, byte[] bq, int formatId) {
        super(gtid, bq, formatId);
        this.ctx = null;
    }

    public OTSXid(byte[] oid) {
        int index = 0;
        int formatID = ByteUtil.convertToInt((byte[])oid, (int)index);
        index += 4;
        int bqLength = ByteUtil.convertToInt((byte[])oid);
        byte[] gtid = new byte[oid.length - (index += 4) - bqLength];
        byte[] bq = new byte[bqLength];
        System.arraycopy(oid, index, gtid, 0, gtid.length);
        System.arraycopy(oid, index += gtid.length, bq, 0, bq.length);
        this.setXid(gtid, bq, formatID);
        this.ctx = null;
    }

    public final PropagationContext getPropagationContext() {
        return this.ctx;
    }

    public final String toString() {
        return "OTSXid[formatID : " + this.getFormatId() + ", tid : " + Utility.getDump((byte[])this.getGlobalTransactionId()) + ", bq : " + Utility.getDump((byte[])this.getBranchQualifier());
    }

    public byte[] getOTID() {
        byte[] gtid = this.getGlobalTransactionId();
        byte[] bq = this.getBranchQualifier();
        byte[] otid = new byte[8 + gtid.length + bq.length];
        int index = 0;
        ByteUtil.putInt((byte[])otid, (int)index, (int)this.getFormatId());
        ByteUtil.putInt((byte[])otid, (int)(index += 4), (int)bq.length);
        System.arraycopy(gtid, 0, otid, index += 4, gtid.length);
        System.arraycopy(bq, 0, otid, index += gtid.length, bq.length);
        return otid;
    }
}

