/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class GlobalTID {
    static GlobalTID NullGlobalTID = new GlobalTID(-1, -1, null);
    otid_t realTID = null;
    private String stringForm = null;
    private int hashCode = 0;
    private boolean hashed = false;

    public GlobalTID(otid_t otherTID) {
        this.realTID = otherTID;
    }

    GlobalTID(int formatID, int bqual_length, byte[] tid) {
        this.realTID = new otid_t(formatID, bqual_length, tid);
    }

    public GlobalTID(Xid xid) {
        int glen = xid.getGlobalTransactionId().length;
        int blen = xid.getBranchQualifier().length;
        byte[] xidRep = new byte[glen + blen];
        System.arraycopy(xid.getGlobalTransactionId(), 0, xidRep, 0, glen);
        System.arraycopy(xid.getBranchQualifier(), 0, xidRep, glen, blen);
        this.realTID = new otid_t(xid.getFormatId(), blen, xidRep);
    }

    GlobalTID(DataInputStream dataIn) {
        try {
            int formatID = dataIn.readInt();
            int bqualLength = dataIn.readInt();
            int bufferlen = dataIn.readUnsignedShort();
            byte[] tid = new byte[bufferlen];
            dataIn.read(tid);
            this.realTID = new otid_t(formatID, bqualLength, tid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    GlobalTID(byte[] bytes) {
        int formatID = (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
        int bqualLength = (bytes[4] & 0xFF) + ((bytes[5] & 0xFF) << 8) + ((bytes[6] & 0xFF) << 16) + ((bytes[7] & 0xFF) << 24);
        byte[] tid = new byte[bytes.length - 8];
        System.arraycopy(bytes, 8, tid, 0, tid.length);
        this.realTID = new otid_t(formatID, bqualLength, tid);
    }

    final GlobalTID copy() {
        GlobalTID result = new GlobalTID(this.realTID);
        result.hashed = this.hashed;
        result.hashCode = this.hashCode;
        result.stringForm = this.stringForm;
        return result;
    }

    final boolean isNull() {
        return this.realTID.formatID == -1;
    }

    public final boolean equals(Object other) {
        otid_t otherTID = null;
        if (other == null) {
            return false;
        }
        if (other instanceof otid_t) {
            otherTID = (otid_t)other;
        } else if (other instanceof GlobalTID) {
            otherTID = ((GlobalTID)other).realTID;
        } else {
            return false;
        }
        boolean result = false;
        if (this.realTID == otherTID) {
            return true;
        }
        if (this.realTID.formatID != otherTID.formatID) {
            return false;
        }
        int firstGTRID = this.realTID.tid.length - this.realTID.bqual_length;
        int secondGTRID = otherTID.tid.length - otherTID.bqual_length;
        if (firstGTRID != secondGTRID) {
            return false;
        }
        result = true;
        for (int pos = 0; pos < firstGTRID && result; ++pos) {
            result = this.realTID.tid[pos] == otherTID.tid[pos];
        }
        return result;
    }

    public final int hashCode() {
        if (this.hashed) {
            return this.hashCode;
        }
        this.hashCode = 0;
        if (this.realTID.tid != null) {
            for (int pos = 0; pos < this.realTID.tid.length; ++pos) {
                this.hashCode += this.realTID.tid[pos];
            }
        }
        this.hashCode += this.realTID.formatID + this.realTID.bqual_length;
        this.hashCode *= 1904362337;
        this.hashed = true;
        return this.hashCode;
    }

    public final String toString() {
        int currCharLow;
        int currCharHigh;
        int i;
        if (this.realTID.formatID == -1) {
            return "[NULL ID]";
        }
        if (this.stringForm != null) {
            return this.stringForm;
        }
        char[] buff = new char[this.realTID.tid.length * 2 + (this.realTID.bqual_length > 0 ? 1 : 0)];
        int pos = 0;
        int globalLen = this.realTID.tid.length - this.realTID.bqual_length;
        for (i = 0; i < globalLen; ++i) {
            currCharHigh = (this.realTID.tid[i] & 0xF0) >> 4;
            currCharLow = this.realTID.tid[i] & 0xF;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
        }
        if (this.realTID.bqual_length > 0) {
            buff[pos++] = 95;
            for (i = 0; i < this.realTID.bqual_length; ++i) {
                currCharHigh = (this.realTID.tid[i + globalLen] & 0xF0) >> 4;
                currCharLow = this.realTID.tid[i + globalLen] & 0xF;
                buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
                buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            }
        }
        this.stringForm = new String(buff);
        return this.stringForm;
    }

    final byte[] toBytes() {
        if (this.realTID.formatID == -1) {
            return null;
        }
        byte[] result = new byte[this.realTID.tid.length + 8];
        result[0] = (byte)this.realTID.formatID;
        result[1] = (byte)(this.realTID.formatID >> 8);
        result[2] = (byte)(this.realTID.formatID >> 16);
        result[3] = (byte)(this.realTID.formatID >> 24);
        result[4] = (byte)this.realTID.bqual_length;
        result[5] = (byte)(this.realTID.bqual_length >> 8);
        result[6] = (byte)(this.realTID.bqual_length >> 16);
        result[7] = (byte)(this.realTID.bqual_length >> 24);
        System.arraycopy(this.realTID.tid, 0, result, 8, this.realTID.tid.length);
        return result;
    }

    final void write(DataOutputStream dataOut) {
        try {
            dataOut.writeInt(this.realTID.formatID);
            dataOut.writeInt(this.realTID.bqual_length);
            dataOut.writeShort(this.realTID.tid.length);
            dataOut.write(this.realTID.tid, 0, this.realTID.tid.length);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

