/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import java.util.logging.Level;
import jeus.ejb.interop.ORBUtil;
import jeus.transaction.GTID;
import jeus.transaction.TMServer;
import jeus.transaction.TMXAResource;
import jeus.transaction.ThreadContexts;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_Manager1;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;

public class ReceiverImpl
implements Receiver {
    private static TMXAResource manager = TMXAResource.getTMXAResource();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");
    private static ThreadLocal shouldSetTxNull = new ThreadLocal();

    public void received_request(int i, PropagationContext pctx) {
        block11: {
            try {
                GTID propagatedGTID = this.getJeusGTID(pctx);
                if (propagatedGTID != null && TMServer.getTMInfo() != null && TMServer.getTMInfo().isGeneratedAtThisTM(propagatedGTID)) {
                    propagatedGTID.setLocal();
                    ThreadContexts.associateTransactionID(propagatedGTID);
                    shouldSetTxNull.set(Boolean.TRUE);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "set shouldSetTxNull to TRUE for local tx propagation");
                    }
                    break block11;
                }
                OTSXid xid = new OTSXid(pctx);
                boolean isContains = TMXAResource.contains(xid);
                if (manager.begin(xid)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "set shouldSetTxNull to TRUE for foreign tx");
                    }
                    shouldSetTxNull.set(Boolean.TRUE);
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "set shouldSetTxNull to NULL for foreign tx");
                    }
                    shouldSetTxNull.set(null);
                }
                GTID currentGTID = ThreadContexts.getAssociatedTransactionID();
                currentGTID.setExternalXid(xid);
                if (isContains) break block11;
                try {
                    ResourceImpl resource = new ResourceImpl(xid);
                    Resource res = resource.object();
                    RecoveryCoordinator recoveryCoord = pctx.current.coord.register_resource(res);
                    resource.setRecoveryCoordinator(recoveryCoord);
                }
                catch (Exception ex) {
                    if (logger.isLoggable(JeusMessage_Manager1._460_LEVEL)) {
                        logger.log(JeusMessage_Manager1._460_LEVEL, JeusMessage_Manager1._460, (Throwable)ex);
                    }
                    ex.printStackTrace();
                    throw new INTERNAL();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }

    private GTID getJeusGTID(PropagationContext ctx) {
        otid_t otid = ctx.current.otid;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "propagated gtid : {0}, , formatID : {1}, Thread : {2}, current thread gtid : {3}", new Object[]{Utility.getDump((byte[])otid.tid), new Integer(otid.formatID), Thread.currentThread(), ThreadContexts.getAssociatedTransactionID()});
        }
        for (int i = 0; i < OTSXid.JEUS_TID_PREFIX.length; ++i) {
            if (otid.tid[i] == OTSXid.JEUS_TID_PREFIX[i]) continue;
            return null;
        }
        return new GTID(otid.tid, OTSXid.JEUS_TID_PREFIX.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sending_reply(int i, PropagationContextHolder holder) {
        try {
            GTID gtid = ThreadContexts.getAssociatedTransactionID();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "send reply, gtid : " + ThreadContexts.getAssociatedTransactionID());
            }
            if (gtid == null || gtid.isInvalid()) {
                INVALID_TRANSACTION exc = new INVALID_TRANSACTION("no transaction or timeout : " + gtid, 0, CompletionStatus.COMPLETED_YES);
                Thread.dumpStack();
                throw exc;
            }
            RootCoordinator cood = ThreadContexts.getCoordinator(gtid.getLTID());
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "send reply, coord : " + cood);
            }
            if (cood == null) {
                INVALID_TRANSACTION exc = new INVALID_TRANSACTION("no transaction or timeout", 0, CompletionStatus.COMPLETED_YES);
                Thread.dumpStack();
                throw exc;
            }
            PropagationContext context = ((OTSXid)gtid.getExternalXid()).getPropagationContext();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "sending_reply context : " + context);
                if (context != null) {
                    logger.log(Level.FINER, "sending_reply tid : " + Utility.getDump((byte[])context.current.otid.tid));
                }
            }
            if (cood.isRollbackOnly() && this.getJeusGTID(context) == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "call coord rollback only");
                }
                try {
                    context.current.coord.rollback_only();
                }
                catch (Throwable exc) {
                    // empty catch block
                }
            }
            holder.value = new PropagationContext(0, new TransIdentity(null, null, context.current.otid), new TransIdentity[0], ORBUtil.implementation_specific_data);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "gtid : " + ThreadContexts.getAssociatedTransactionID() + ", send reply tx : " + Utility.getDump((byte[])((OTSXid)gtid.getExternalXid()).getPropagationContext().current.otid.tid));
            }
        }
        finally {
            if (shouldSetTxNull.get() != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "clear tx context according to shouldSetTxNull");
                }
                ThreadContexts.dissociateTransactionID();
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "NOT clear tx context according to shouldSetTxNull");
            }
        }
    }
}

