/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.impl;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import jeus.transaction.GTID;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.Configuration;
import jeus.transaction.ots.impl.RecoveryCoordinatorImpl;
import jeus.transaction.ots.jta.JTAConverter;
import jeus.transaction.ots.jta.JTASynchronization;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.CoordinatorPOA;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class CoordinatorImpl
extends CoordinatorPOA {
    private GTID gtid;
    private long timeout;
    private RootCoordinator coord;
    private Coordinator thisRef;
    private POA poa;
    private static final AtomicInteger resSequence = new AtomicInteger();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");
    private Vector recoveryCoordinatorList = new Vector();
    private boolean isIncarnate;

    public CoordinatorImpl(GTID gtid, long timeout, RootCoordinator coord) {
        this.gtid = gtid;
        this.timeout = timeout;
        this.coord = coord;
    }

    public CoordinatorImpl(byte[] oid) {
        this.isIncarnate = true;
        Thread.dumpStack();
    }

    public Status get_status() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_status called");
        return JTAConverter.getTxStatus(this.coord.getStatus());
    }

    public Status get_parent_status() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_parent_status called");
        return null;
    }

    public Status get_top_level_status() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_top_level_status called");
        return null;
    }

    public boolean is_same_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_same_transaction called");
        return false;
    }

    public boolean is_related_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_related_transaction called");
        return false;
    }

    public boolean is_ancestor_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_ancestor_transaction called");
        return false;
    }

    public boolean is_descendant_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_descendant_transaction called");
        return false;
    }

    public boolean is_top_level_transaction() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_top_level_transaction called");
        return false;
    }

    public int hash_transaction() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : hash_transaction called");
        return 0;
    }

    public int hash_top_level_tran() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : hash_top_level_tran called");
        return 0;
    }

    public RecoveryCoordinator register_resource(Resource r) throws Inactive {
        try {
            if (this.isIncarnate) {
                Thread.dumpStack();
            }
            if (logger.isLoggable(JeusMessage_Manager1._457_LEVEL)) {
                logger.log(JeusMessage_Manager1._457_LEVEL, JeusMessage_Manager1._457);
            }
            this.coord.registerResource(r);
            RecoveryCoordinatorImpl recoveryCoordImpl = new RecoveryCoordinatorImpl(this.gtid, resSequence.getAndIncrement());
            this.recoveryCoordinatorList.add(recoveryCoordImpl);
            return recoveryCoordImpl.object();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Manager1._448_LEVEL)) {
                logger.log(JeusMessage_Manager1._448_LEVEL, JeusMessage_Manager1._448, t);
            }
            return null;
        }
    }

    public void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        if (logger.isLoggable(JeusMessage_Manager1._458_LEVEL)) {
            logger.log(JeusMessage_Manager1._458_LEVEL, JeusMessage_Manager1._458);
        }
        this.coord.registerSynchronization(new JTASynchronization(sync));
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : register_subtran_aware called");
        throw new NotSubtransaction();
    }

    public void rollback_only() throws Inactive {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : rollback_only called");
        this.coord.setRollbackOnly();
    }

    public String get_transaction_name() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_transaction_name called");
        if (this.gtid != null) {
            return "GTID" + this.gtid.toString();
        }
        return "";
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : create_subtransaction called");
        throw new SubtransactionsUnavailable();
    }

    public PropagationContext get_txcontext() throws Unavailable {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_txcontext called");
        OTSXid xid = (OTSXid)this.coord.getExternalXid();
        if (xid != null) {
            return xid.getPropagationContext();
        }
        throw new Unavailable();
    }

    public void _release() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _release called");
    }

    public int _hash(int maximum) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _hash called");
        return 0;
    }

    public DomainManager[] _get_domain_managers() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _get_domain_managers");
        return new DomainManager[0];
    }

    public Object _duplicate() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _duplicate");
        return null;
    }

    public boolean _is_equivalent(Object other) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _is_equivalent");
        return false;
    }

    public Policy _get_policy(int policy_type) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _get_policy");
        return null;
    }

    public Request _request(String operation) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _request");
        return null;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _set_policy_override");
        return null;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _create_request");
        return null;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exclist, ContextList ctxlist) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _create_request");
        return null;
    }

    public final synchronized Coordinator object() {
        if (this.thisRef == null) {
            if (this.poa == null) {
                this.poa = Configuration.getPOA("OTSCoordinatorPOA");
            }
            try {
                this.poa.activate_object((Servant)this);
                this.thisRef = CoordinatorHelper.narrow(this.poa.servant_to_reference((Servant)this));
            }
            catch (Exception exc) {
                if (logger.isLoggable(JeusMessage_OTS0._1209_LEVEL)) {
                    logger.log(JeusMessage_OTS0._1209_LEVEL, JeusMessage_OTS0._1209, (Throwable)exc);
                }
                throw new INTERNAL("jts.create_coordinator_object_error");
            }
        }
        return this.thisRef;
    }

    public final synchronized void destroy() {
        block4: {
            if (this.poa != null && this.thisRef != null) {
                try {
                    this.poa.deactivate_object(this.poa.reference_to_id((Object)this.thisRef));
                    this.thisRef = null;
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(JeusMessage_OTS0._1210_LEVEL)) break block4;
                    logger.log(JeusMessage_OTS0._1210_LEVEL, JeusMessage_OTS0._1210);
                }
            }
        }
        for (int i = 0; i < this.recoveryCoordinatorList.size(); ++i) {
            RecoveryCoordinatorImpl recoveryCoordinator = (RecoveryCoordinatorImpl)this.recoveryCoordinatorList.get(i);
            recoveryCoordinator.destroy();
        }
    }
}

