/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.jta;

import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.resources.JeusXAResource;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager1;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Vote;

public class JTAResource
implements JeusXAResource {
    private Resource resource;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");

    public JTAResource(Resource rs) {
        this.resource = rs;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource instanceof JTAResource) {
            JTAResource jtaR = (JTAResource)xaResource;
            return this.resource._is_equivalent(jtaR.getRealResource());
        }
        return false;
    }

    public Object getRealResource() {
        return this.resource;
    }

    public Xid[] recover(int i) throws XAException {
        return new Xid[0];
    }

    public int prepare(Xid xid) throws XAException {
        Vote v;
        try {
            v = this.resource.prepare();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Manager1._463_LEVEL)) {
                logger.log(JeusMessage_Manager1._463_LEVEL, JeusMessage_Manager1._463, t);
            }
            throw new XAException("fail to prepare : " + t.toString());
        }
        switch (v.value()) {
            case 0: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 1: {
                throw new XAException(100);
            }
        }
        throw new XAException("fail to prepare");
    }

    public void forget(Xid xid) throws XAException {
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.resource.rollback();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Manager1._464_LEVEL)) {
                logger.log(JeusMessage_Manager1._464_LEVEL, JeusMessage_Manager1._464, t);
            }
            throw new XAException(t.toString());
        }
    }

    public void end(Xid xid, int i) throws XAException {
    }

    public void start(Xid xid, int i) throws XAException {
    }

    public void commit(Xid xid, boolean isOnePhase) throws XAException {
        try {
            if (isOnePhase) {
                this.resource.commit_one_phase();
            } else {
                this.resource.commit();
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINER, "Exception occurred in resource commit method", t);
            XAException xae = new XAException(t.toString());
            xae.errorCode = 101;
            throw xae;
        }
    }

    public void enforceEnd() {
    }

    public String getName() {
        return null;
    }

    public XAResourceFactory getXAResourceFactory() {
        return null;
    }

    public void setXAResourceFactory(XAResourceFactory xaResourceFactory) {
    }

    public void replaceXAResource(XAResource xaResource) {
    }
}

