/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.resources;

import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.TMServer;
import jeus.transaction.resources.JeusXAResource;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM2;

public final class LocalResource {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private String lock = new String("XAResourceLock");
    private XAResource resource;
    private final Xid xid;
    private final boolean isLocalXA;
    private AtomicInteger failCount = new AtomicInteger(0);

    public LocalResource(XAResource resource, Xid xid, boolean isLocalXA) {
        if (logger.isLoggable(JeusMessage_TM2._4401_LEVEL)) {
            logger.logp(JeusMessage_TM2._4401_LEVEL, "LocalResource", "<init>", JeusMessage_TM2._4401, new Object[]{resource, XidToString.getXidString(xid), isLocalXA ? "local transaction resource enlisted in xa context" : ""});
        }
        this.resource = resource;
        this.xid = xid;
        this.isLocalXA = isLocalXA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXAResource(XAResource resource) {
        if (logger.isLoggable(JeusMessage_TM2._4402_LEVEL)) {
            logger.logp(JeusMessage_TM2._4402_LEVEL, "LocalResource", "setXAResource", JeusMessage_TM2._4402, (Object)resource);
        }
        String string = this.lock;
        synchronized (string) {
            this.resource = resource;
        }
    }

    public XAResource getXAResource() {
        if (logger.isLoggable(JeusMessage_TM2._4403_LEVEL)) {
            logger.logp(JeusMessage_TM2._4403_LEVEL, "LocalResource", "getXAResource", JeusMessage_TM2._4403, (Object)this.resource);
        }
        return this.resource;
    }

    public Xid getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enforceEnd() {
        XAResource xaResource = null;
        String string = this.lock;
        synchronized (string) {
            xaResource = this.resource;
            if (logger.isLoggable(JeusMessage_TM2._4404_LEVEL)) {
                logger.logp(JeusMessage_TM2._4404_LEVEL, "LocalResource", "enforceEnd", JeusMessage_TM2._4404, (Object)xaResource);
            }
            if (xaResource instanceof JeusXAResource) {
                ((JeusXAResource)xaResource).enforceEnd();
            } else if (logger.isLoggable(JeusMessage_TM2._4423_LEVEL)) {
                logger.logp(JeusMessage_TM2._4423_LEVEL, "LocalResource", "enforceEnd", JeusMessage_TM2._4423, new Object[]{xaResource.getClass(), xaResource});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() {
        int response;
        if (this.isLocalXA) {
            if (logger.isLoggable(JeusMessage_TM2._4406_LEVEL)) {
                logger.logp(JeusMessage_TM2._4406_LEVEL, "LocalResource", "prepare", JeusMessage_TM2._4406);
            }
            return 5;
        }
        XAResource xaResource = null;
        try {
            String string = this.lock;
            synchronized (string) {
                xaResource = this.resource;
                if (logger.isLoggable(JeusMessage_TM2._4405_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4405_LEVEL, "LocalResource", "prepare", JeusMessage_TM2._4405, new Object[]{xaResource, XidToString.getXidString(this.xid)});
                }
                response = xaResource.prepare(this.xid);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof XAException) {
                XAException xae = (XAException)ex;
                if (xae.errorCode == -7 || xae.errorCode == -4) {
                    this.increaseFailCount();
                    TMServer.addFailedLocalResource(this, (byte)0);
                }
                if (logger.isLoggable(JeusMessage_TM2._4407_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4407_LEVEL, "LocalResource", "prepare", JeusMessage_TM2._4407, new Object[]{XidToString.getXAErrorCode(xae.errorCode), xaResource, XidToString.getXidString(this.xid)}, (Throwable)xae);
                }
            } else if (logger.isLoggable(JeusMessage_TM2._4408_LEVEL)) {
                logger.logp(JeusMessage_TM2._4408_LEVEL, "LocalResource", "prepare", JeusMessage_TM2._4408, new Object[]{xaResource, XidToString.getXidString(this.xid)}, ex);
            }
            return 1;
        }
        if (response == 0) {
            if (logger.isLoggable(JeusMessage_TM2._4409_LEVEL)) {
                logger.logp(JeusMessage_TM2._4409_LEVEL, "LocalResource", "prepare", JeusMessage_TM2._4409, (Object)xaResource);
            }
            return 0;
        }
        if (response == 3) {
            if (logger.isLoggable(JeusMessage_TM2._4410_LEVEL)) {
                logger.logp(JeusMessage_TM2._4410_LEVEL, "LocalResource", "prepare", JeusMessage_TM2._4410, (Object)xaResource);
            }
            return 2;
        }
        if (logger.isLoggable(JeusMessage_TM2._4424_LEVEL)) {
            logger.log(JeusMessage_TM2._4424_LEVEL, JeusMessage_TM2._4424, (Object)response);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte commit() {
        XAResource xaResource = null;
        try {
            String string = this.lock;
            synchronized (string) {
                xaResource = this.resource;
                if (logger.isLoggable(JeusMessage_TM2._4411_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4411_LEVEL, "LocalResource", "commit", JeusMessage_TM2._4411, new Object[]{xaResource, XidToString.getXidString(this.xid)});
                }
                xaResource.commit(this.xid, false);
            }
            if (logger.isLoggable(JeusMessage_TM2._4412_LEVEL)) {
                logger.logp(JeusMessage_TM2._4412_LEVEL, "LocalResource", "commit", JeusMessage_TM2._4412, (Object)xaResource);
            }
            return 3;
        }
        catch (Throwable ex) {
            if (ex instanceof XAException) {
                XAException xae = (XAException)ex;
                if (xae.errorCode == -7 || xae.errorCode == -4) {
                    this.increaseFailCount();
                    TMServer.addFailedLocalResource(this, (byte)1);
                }
                if (logger.isLoggable(JeusMessage_TM2._4413_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4413_LEVEL, "LocalResource", "commit", JeusMessage_TM2._4413, new Object[]{XidToString.getXAErrorCode(xae.errorCode), xaResource, XidToString.getXidString(this.xid)}, (Throwable)xae);
                }
            } else if (logger.isLoggable(JeusMessage_TM2._4414_LEVEL)) {
                logger.logp(JeusMessage_TM2._4414_LEVEL, "LocalResource", "commit", JeusMessage_TM2._4414, new Object[]{xaResource, XidToString.getXidString(this.xid)}, ex);
            }
            return 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte rollback(byte response) {
        XAResource xaResource = null;
        try {
            String string = this.lock;
            synchronized (string) {
                xaResource = this.resource;
                if (logger.isLoggable(JeusMessage_TM2._4415_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4415_LEVEL, "LocalResource", "rollback", JeusMessage_TM2._4415, new Object[]{xaResource, XidToString.getXidString(this.xid)});
                }
                xaResource.rollback(this.xid);
            }
            if (logger.isLoggable(JeusMessage_TM2._4416_LEVEL)) {
                logger.logp(JeusMessage_TM2._4416_LEVEL, "LocalResource", "rollback", JeusMessage_TM2._4416, (Object)xaResource);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof XAException) {
                XAException xae = (XAException)ex;
                if (xae.errorCode == -7 || xae.errorCode == -4) {
                    this.increaseFailCount();
                    TMServer.addFailedLocalResource(this, (byte)2);
                }
                if (logger.isLoggable(JeusMessage_TM2._4417_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4417_LEVEL, "LocalResource", "rollback", JeusMessage_TM2._4417, new Object[]{XidToString.getXAErrorCode(xae.errorCode), xaResource, XidToString.getXidString(this.xid)}, (Throwable)xae);
                }
            } else if (logger.isLoggable(JeusMessage_TM2._4418_LEVEL)) {
                logger.logp(JeusMessage_TM2._4418_LEVEL, "LocalResource", "rollback", JeusMessage_TM2._4418, new Object[]{xaResource, XidToString.getXidString(this.xid)}, ex);
            }
            response = (byte)4;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte onePhaseCommit() {
        XAResource xaResource = null;
        try {
            String string = this.lock;
            synchronized (string) {
                xaResource = this.resource;
                if (logger.isLoggable(JeusMessage_TM2._4419_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4419_LEVEL, "LocalResource", "onePhaseCommit", JeusMessage_TM2._4419, new Object[]{xaResource, XidToString.getXidString(this.xid)});
                }
                xaResource.commit(this.xid, true);
            }
            if (logger.isLoggable(JeusMessage_TM2._4420_LEVEL)) {
                logger.logp(JeusMessage_TM2._4420_LEVEL, "LocalResource", "onePhaseCommit", JeusMessage_TM2._4420, (Object)xaResource);
            }
            return 0;
        }
        catch (Throwable ex) {
            if (ex instanceof XAException) {
                int code;
                XAException xae = (XAException)ex;
                if (xae.errorCode == -7 || xae.errorCode == -4) {
                    this.increaseFailCount();
                    TMServer.addFailedLocalResource(this, (byte)3);
                }
                if (logger.isLoggable(JeusMessage_TM2._4421_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4421_LEVEL, "LocalResource", "onePhaseCommit", JeusMessage_TM2._4421, new Object[]{XidToString.getXAErrorCode(xae.errorCode), xaResource, XidToString.getXidString(this.xid)}, (Throwable)xae);
                }
                if ((code = ((XAException)ex).errorCode) == 100 || code == 101 || code == 102 || code == 107 || code == 103 || code == 104 || code == 105 || code == 100 || code == 106 || code == 107) {
                    return 1;
                }
            } else if (logger.isLoggable(JeusMessage_TM2._4422_LEVEL)) {
                logger.logp(JeusMessage_TM2._4422_LEVEL, "LocalResource", "onePhaseCommit", JeusMessage_TM2._4422, new Object[]{xaResource, XidToString.getXidString(this.xid)}, ex);
            }
            return 4;
        }
    }

    public String toString() {
        return this.resource.toString();
    }

    public String getName() {
        String name = null;
        if (this.resource != null) {
            if (this.resource instanceof JeusXAResource) {
                name = ((JeusXAResource)this.resource).getName();
            }
            if (name == null) {
                name = this.resource.toString();
            }
        }
        return name;
    }

    public boolean isLocalXA() {
        return this.isLocalXA;
    }

    public int increaseFailCount() {
        return this.failCount.incrementAndGet();
    }

    public int getFailCount() {
        return this.failCount.get();
    }
}

