/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.resources;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.resources.JeusXAResource;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM4;

public class XAResourceWrapper
implements JeusXAResource {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    protected XAResource resource;
    protected boolean inTx;
    protected Xid xid;
    private XAResourceFactory xaResourceFactory;

    public XAResourceWrapper(XAResource resource) {
        if (logger.isLoggable(JeusMessage_TM4._6201_LEVEL)) {
            logger.logp(JeusMessage_TM4._6201_LEVEL, "XAResourceWrapper", "<init>", JeusMessage_TM4._6201, (Object)resource);
        }
        this.resource = resource;
    }

    public void enforceEnd() {
        if (logger.isLoggable(JeusMessage_TM4._6202_LEVEL)) {
            logger.logp(JeusMessage_TM4._6202_LEVEL, "XAResourceWrapper", "enforceEnd", JeusMessage_TM4._6202);
        }
        try {
            if (this.inTx) {
                this.end(this.xid, 0x4000000);
            }
        }
        catch (Throwable t) {
            logger.logp(JeusMessage_TM4._6203_LEVEL, "XAResourceWrapper", "enforceEnd", JeusMessage_TM4._6203, t);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.resource.commit(xid, onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void end(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6204_LEVEL)) {
            logger.logp(JeusMessage_TM4._6204_LEVEL, "XAResourceWrapper", "end", JeusMessage_TM4._6204, new Object[]{xid, String.valueOf(flags)});
        }
        try {
            this.resource.end(xid, flags);
        }
        finally {
            this.inTx = false;
        }
        if (logger.isLoggable(JeusMessage_TM4._6205_LEVEL)) {
            logger.logp(JeusMessage_TM4._6205_LEVEL, "XAResourceWrapper", "end", JeusMessage_TM4._6205);
        }
    }

    public final void forget(Xid xid) throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6206_LEVEL)) {
            logger.logp(JeusMessage_TM4._6206_LEVEL, "XAResourceWrapper", "forget", JeusMessage_TM4._6206, (Object)xid);
        }
        this.resource.forget(xid);
    }

    public final int getTransactionTimeout() throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6207_LEVEL)) {
            logger.logp(JeusMessage_TM4._6207_LEVEL, "XAResourceWrapper", "getTransactionTimeout", JeusMessage_TM4._6207);
        }
        int timeout = this.resource.getTransactionTimeout();
        if (logger.isLoggable(JeusMessage_TM4._6208_LEVEL)) {
            logger.logp(JeusMessage_TM4._6208_LEVEL, "XAResourceWrapper", "getTransactionTimeout", JeusMessage_TM4._6208, (Object)String.valueOf(timeout));
        }
        return timeout;
    }

    public final boolean isSameRM(XAResource xares) throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6209_LEVEL)) {
            logger.logp(JeusMessage_TM4._6209_LEVEL, "XAResourceWrapper", "isSameRM", JeusMessage_TM4._6209, (Object)xares);
        }
        if (!(xares instanceof XAResourceWrapper)) {
            return false;
        }
        boolean equal = this.resource.isSameRM(((XAResourceWrapper)xares).resource);
        if (logger.isLoggable(JeusMessage_TM4._6210_LEVEL)) {
            logger.logp(JeusMessage_TM4._6210_LEVEL, "XAResourceWrapper", "isSameRM", JeusMessage_TM4._6210, new Object[]{equal ? "" : "not ", xares});
        }
        return equal;
    }

    public int prepare(Xid xid) throws XAException {
        return this.resource.prepare(xid);
    }

    public final Xid[] recover(int flag) throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6211_LEVEL)) {
            logger.logp(JeusMessage_TM4._6211_LEVEL, "XAResourceWrapper", "recover", JeusMessage_TM4._6211, (Object)String.valueOf(flag));
        }
        Xid[] xids = this.resource.recover(flag);
        if (logger.isLoggable(JeusMessage_TM4._6212_LEVEL)) {
            logger.logp(JeusMessage_TM4._6212_LEVEL, "XAResourceWrapper", "recover", JeusMessage_TM4._6212, (Object)String.valueOf(xids.length));
        }
        return xids;
    }

    public void rollback(Xid xid) throws XAException {
        this.resource.rollback(xid);
    }

    public final boolean setTransactionTimeout(int seconds) throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6213_LEVEL)) {
            logger.logp(JeusMessage_TM4._6213_LEVEL, "XAResourceWrapper", "setTransactionTimeout", JeusMessage_TM4._6213, (Object)String.valueOf(seconds));
        }
        boolean set = this.resource.setTransactionTimeout(seconds);
        if (logger.isLoggable(JeusMessage_TM4._6214_LEVEL)) {
            logger.logp(JeusMessage_TM4._6214_LEVEL, "XAResourceWrapper", "setTransactionTimeout", JeusMessage_TM4._6214, new Object[]{set ? "" : "not ", String.valueOf(seconds)});
        }
        return set;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(JeusMessage_TM4._6215_LEVEL)) {
            logger.logp(JeusMessage_TM4._6215_LEVEL, "XAResourceWrapper", "start", JeusMessage_TM4._6215, new Object[]{xid, String.valueOf(flags)});
        }
        this.resource.start(xid, flags);
        this.inTx = true;
        this.xid = xid;
        if (logger.isLoggable(JeusMessage_TM4._6216_LEVEL)) {
            logger.logp(JeusMessage_TM4._6216_LEVEL, "XAResourceWrapper", "start", JeusMessage_TM4._6216);
        }
    }

    public XAResource getDelegate() {
        return this.resource;
    }

    public final boolean inTx() {
        if (logger.isLoggable(JeusMessage_TM4._6217_LEVEL)) {
            logger.logp(JeusMessage_TM4._6217_LEVEL, "XAResourceWrapper", "inTx", JeusMessage_TM4._6217, (Object)(this.inTx ? "" : "not "));
        }
        return this.inTx;
    }

    public Xid getXID() {
        if (logger.isLoggable(JeusMessage_TM4._6218_LEVEL)) {
            logger.logp(JeusMessage_TM4._6218_LEVEL, "XAResourceWrapper", "getXID", JeusMessage_TM4._6218, (Object)this.xid);
        }
        return this.xid;
    }

    public String toString() {
        return this.resource.toString();
    }

    public String getName() {
        return null;
    }

    public XAResourceFactory getXAResourceFactory() {
        return this.xaResourceFactory;
    }

    public void setXAResourceFactory(XAResourceFactory xaResourceFactory) {
        this.xaResourceFactory = xaResourceFactory;
    }

    public void replaceXAResource(XAResource xaResource) {
        this.resource = xaResource;
    }
}

