/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.sub;

import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.PreparedTimerEntry;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.collector.FlushRequestResponseCollector;
import jeus.transaction.collector.RegResponseCollector;
import jeus.transaction.sub.RootCoordinatorDelegate;
import jeus.util.ScheduledExecutor;
import jeus.util.message.JeusMessage_TM0;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.message.JeusMessage_TM4;

public final class SubCoordinator
extends Coordinator {
    private RootCoordinatorDelegate root;
    private final RegResponseCollector regCollector = new RegResponseCollector();
    private final FlushRequestResponseCollector frCollector = new FlushRequestResponseCollector();
    private boolean resourceRegistered;
    private boolean isRegistered;
    private final long regTO = 120000L;
    private final long preparedTO = TMConfig.preparedTO;
    private PreparedTimerEntry preparedTimer;

    public SubCoordinator(RootCoordinatorDelegate root, GTID gtid, long timeout) {
        super(gtid, timeout);
        if (logger.isLoggable(JeusMessage_TM1._3601_LEVEL)) {
            logger.logp(JeusMessage_TM1._3601_LEVEL, "Coordinator", "<init>", JeusMessage_TM1._3601, new Object[]{"sub", gtid, String.valueOf(timeout)});
        }
        this.root = root;
    }

    protected void beforeRegisterResource() {
        if (!this.resourceRegistered) {
            if (logger.isLoggable(JeusMessage_TM1._3606_LEVEL)) {
                logger.logp(JeusMessage_TM1._3606_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3606, new Object[]{this.root, this.gtid});
            }
            this.registerToRootCoordinator();
        }
    }

    public void registerToRootCoordinator() {
        block3: {
            if (logger.isLoggable(JeusMessage_TM1._3602_LEVEL)) {
                logger.logp(JeusMessage_TM1._3602_LEVEL, "Coordinator", "registerToRootCoordinator", JeusMessage_TM1._3602, new Object[]{this.root, this.gtid});
            }
            try {
                this.root.registerResource();
                this.resourceRegistered = true;
            }
            catch (TMException ex) {
                if (!logger.isLoggable(JeusMessage_TM1._3604_LEVEL)) break block3;
                logger.logp(JeusMessage_TM1._3604_LEVEL, "Coordinator", "registerToRootCoordinator", JeusMessage_TM1._3604, (Object)this.root, (Throwable)((Object)ex));
            }
        }
    }

    public void checkRegistration() {
        if (logger.isLoggable(JeusMessage_TM1._3620_LEVEL)) {
            logger.logp(JeusMessage_TM1._3620_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3620, (Object)this.root);
        }
        if (this.regCollector != null) {
            if (logger.isLoggable(JeusMessage_TM1._3621_LEVEL)) {
                logger.logp(JeusMessage_TM1._3621_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3621, new Object[]{String.valueOf(120000L), this.root});
            }
            this.isRegistered = this.regCollector.check(120000L);
            if (logger.isLoggable(JeusMessage_TM1._3622_LEVEL)) {
                logger.logp(JeusMessage_TM1._3622_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3622, new Object[]{this.root, String.valueOf(this.isRegistered)});
            }
            if (!this.isRegistered) {
                this.rollback();
            }
        } else if (logger.isLoggable(JeusMessage_TM1._3623_LEVEL)) {
            logger.logp(JeusMessage_TM1._3623_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3623);
        }
    }

    public void registered(boolean isSuccessful) {
        if (logger.isLoggable(JeusMessage_TM1._3624_LEVEL)) {
            logger.logp(JeusMessage_TM1._3624_LEVEL, "Coordinator", "registered", JeusMessage_TM1._3624, (Object)this.root);
        }
        if (this.regCollector != null) {
            this.regCollector.received(isSuccessful);
        }
    }

    public boolean isRegCheckRequired() {
        if (logger.isLoggable(JeusMessage_TM1._3625_LEVEL)) {
            logger.logp(JeusMessage_TM1._3625_LEVEL, "Coordinator", "isRegCheckRequired", JeusMessage_TM1._3625, new Object[]{this.root, !this.isRegistered});
        }
        return !this.isRegistered;
    }

    protected byte setReadOnlyStatus() {
        if (this.localXAResource != null) {
            return 7;
        }
        return 2;
    }

    protected boolean postPrepare(boolean rollback) {
        if (logger.isLoggable(JeusMessage_TM0._2812_LEVEL)) {
            logger.logp(JeusMessage_TM0._2812_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2812);
        }
        TMServer.addIncompleteSubTx(this);
        this.setPreparedTimer();
        this.isPrepareCalled = true;
        return rollback;
    }

    protected byte postCommit(byte response) {
        if (response == 3) {
            this.removeIncompletedSubTx();
        }
        return response;
    }

    protected byte preRollback() {
        TMServer.removeIncompleteSubTx(this);
        return 1;
    }

    protected void innerDestroy() {
        ThreadContexts.removeCoordinator(this.gtid);
        TMServer.disconnectContext();
        if (this.preparedTimer != null) {
            this.preparedTimer.cancel();
            this.preparedTimer = null;
        }
        this.root = null;
    }

    protected void innerFlush() throws TMException {
        boolean result;
        if (logger.isLoggable(JeusMessage_TM1._3780_LEVEL)) {
            logger.logp(JeusMessage_TM1._3780_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3780, new Object[]{this.root, this.gtid});
        }
        this.root.requestFlush();
        try {
            if (logger.isLoggable(JeusMessage_TM1._3781_LEVEL)) {
                logger.logp(JeusMessage_TM1._3781_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3781, new Object[]{String.valueOf(this.prepareTO), this.root, this.gtid});
            }
            result = this.frCollector.waiting(this.prepareTO);
        }
        catch (TMException ex) {
            if (logger.isLoggable(JeusMessage_TM1._3782_LEVEL)) {
                logger.logp(JeusMessage_TM1._3782_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3782, new Object[]{this.root, this.gtid}, (Throwable)((Object)ex));
            }
            throw ex;
        }
        if (result) {
            throw new TMException(JeusMessage_TM1._3783, new String[]{this.root.toString(), this.gtid.toString()});
        }
    }

    protected byte setCommitStatus() {
        if (this.localXAResource != null) {
            if (logger.isLoggable(JeusMessage_TM1._3673_LEVEL)) {
                logger.logp(JeusMessage_TM1._3673_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3673, (Object)this.gtid);
            }
            return 6;
        }
        if (logger.isLoggable(JeusMessage_TM1._3674_LEVEL)) {
            logger.logp(JeusMessage_TM1._3674_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3674, new Object[]{"sub", this.gtid});
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparedTimeout(PreparedTimerEntry entry) {
        if (logger.isLoggable(JeusMessage_TM1._3688_LEVEL)) {
            logger.logp(JeusMessage_TM1._3688_LEVEL, "Coordinator", "preparedTimeout", JeusMessage_TM1._3688, (Object)this.gtid);
        }
        Object object = this.statusSync;
        synchronized (object) {
            if (this.preparedTimer != entry) {
                return;
            }
            if (this.status == 2) {
                if (logger.isLoggable(JeusMessage_TM1._3690_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3690_LEVEL, "Coordinator", "preparedTimeout", JeusMessage_TM1._3690, (Object)this.gtid);
                }
                JTAStatisticsProvider.incrementPreparedTimeOutCount();
                JTAStatisticsProvider.incrementTimeOutCount();
                if (this.localXAResource != null) {
                    TMServer.removeIncompleteSubTx(this);
                    this.rollback();
                    this.destroy();
                }
            } else if (logger.isLoggable(JeusMessage_TM1._3689_LEVEL)) {
                logger.logp(JeusMessage_TM1._3689_LEVEL, "Coordinator", "preparedTimeout", JeusMessage_TM1._3689, (Object)this.gtid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPreparedTimer() {
        if (logger.isLoggable(JeusMessage_TM1._3680_LEVEL)) {
            logger.logp(JeusMessage_TM1._3680_LEVEL, "Coordinator", "setPreparedTimer", JeusMessage_TM1._3680, (Object)this.gtid);
        }
        Object object = this.statusSync;
        synchronized (object) {
            if (logger.isLoggable(JeusMessage_TM1._3681_LEVEL)) {
                logger.logp(JeusMessage_TM1._3681_LEVEL, "Coordinator", "setPreparedTimer", JeusMessage_TM1._3681, new Object[]{String.valueOf(this.preparedTO), this.gtid});
            }
            if (logger.isLoggable(JeusMessage_TM3._5201_LEVEL)) {
                long time = System.currentTimeMillis() + this.preparedTO;
                logger.logp(JeusMessage_TM3._5201_LEVEL, "TimerEntry", "<init>", JeusMessage_TM3._5201, new Object[]{this, String.valueOf(time)});
            }
            this.preparedTimer = new PreparedTimerEntry(this);
            ScheduledExecutor.getInstance().schedule(this.preparedTimer, this.preparedTO);
        }
    }

    public void requestFlushResponse(byte response) {
        if (logger.isLoggable(JeusMessage_TM1._3789_LEVEL)) {
            logger.logp(JeusMessage_TM1._3789_LEVEL, "Coordinator", "requestFlushResponse", JeusMessage_TM1._3789, (Object)TxStatus.getState(response));
        }
        this.frCollector.received(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disablePreparedTO(int st) {
        if (logger.isLoggable(JeusMessage_TM1._3683_LEVEL)) {
            logger.logp(JeusMessage_TM1._3683_LEVEL, "Coordinator", "disablePreparedTO", JeusMessage_TM1._3683, (Object)this.gtid);
        }
        Object object = this.statusSync;
        synchronized (object) {
            if (this.status == 2) {
                if (logger.isLoggable(JeusMessage_TM1._3685_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3685_LEVEL, "Coordinator", "disablePreparedTO", JeusMessage_TM1._3685, (Object)this.gtid);
                }
                this.status = st;
                if (this.preparedTimer != null) {
                    this.preparedTimer.cancel();
                    if (logger.isLoggable(JeusMessage_TM1._3687_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3687_LEVEL, "Coordinator", "disablePreparedTO", JeusMessage_TM1._3687, (Object)this.gtid);
                    }
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte commitLocalXAResource() {
        if (SubCoordinator.logger.isLoggable(JeusMessage_TM1._3741_LEVEL)) {
            SubCoordinator.logger.logp(JeusMessage_TM1._3741_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3741, new Object[]{this.localXAResource, this.gtid});
        }
        var1_1 = this.statusSync;
        synchronized (var1_1) {
            block20: {
                block19: {
                    if (this.status != 2) {
                        if (SubCoordinator.logger.isLoggable(JeusMessage_TM1._3742_LEVEL)) {
                            SubCoordinator.logger.logp(JeusMessage_TM1._3742_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3742, (Object)this.gtid);
                        }
                        return 1;
                    }
                    result = this.localXAResource.onePhaseCommit();
                    if (result != 0) ** GOTO lbl33
                    if (SubCoordinator.logger.isLoggable(JeusMessage_TM1._3743_LEVEL)) {
                        SubCoordinator.logger.logp(JeusMessage_TM1._3743_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3743, new Object[]{this.localXAResource, this.gtid});
                    }
                    if (this.localResources.size() != 1) break block19;
                    if (SubCoordinator.logger.isLoggable(JeusMessage_TM4._6307_LEVEL)) {
                        SubCoordinator.logger.logp(JeusMessage_TM4._6307_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM4._6307, new Object[]{this.gtid});
                    }
                    this.disablePreparedTO(8);
                    TMServer.removeIncompleteSubTx(this);
                    this.afterCompletion(3);
                    this.status = 3;
                    var3_4 = 9;
                    this.localXAResource = null;
                    return var3_4;
                }
                if (this.preparedTimer != null) {
                    this.preparedTimer.cancel();
                }
                this.setPreparedTimer();
                break block20;
lbl33:
                // 1 sources

                if (SubCoordinator.logger.isLoggable(JeusMessage_TM1._3744_LEVEL)) {
                    SubCoordinator.logger.logp(JeusMessage_TM1._3744_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3744, new Object[]{this.localXAResource, this.gtid});
                }
            }
            var3_5 = result;
            this.localXAResource = null;
            return var3_5;
            {
                catch (Throwable t) {
                    try {
                        if (SubCoordinator.logger.isLoggable(JeusMessage_TM1._3745_LEVEL)) {
                            SubCoordinator.logger.logp(JeusMessage_TM1._3745_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3745, new Object[]{this.localXAResource, this.gtid}, t);
                        }
                        var3_6 = 1;
                        this.localXAResource = null;
                    }
                    catch (Throwable var4_7) {
                        this.localXAResource = null;
                        throw var4_7;
                    }
                    return var3_6;
                }
            }
        }
    }

    public void removeIncompletedSubTx() {
        TMServer.removeIncompleteSubTx(this);
    }
}

