/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import jeus.transaction.util.XidToString;

public class XidHashTable
implements Map {
    private final Map strToValueTable;
    private final Map strToXidTable;
    private volatile transient Set keySet = null;
    private volatile transient Set entrySet = null;

    public XidHashTable(int capacity) {
        this.strToValueTable = new Hashtable(capacity);
        this.strToXidTable = new Hashtable(capacity);
    }

    public XidHashTable() {
        this.strToValueTable = new Hashtable();
        this.strToXidTable = new Hashtable();
    }

    public synchronized Object get(Object key) {
        if (!(key instanceof Xid)) {
            throw new RuntimeException("This table supports only Xid-type key");
        }
        Xid xid = (Xid)key;
        String strkey = XidToString.getXidString(xid);
        return this.strToValueTable.get(strkey);
    }

    public synchronized Object put(Object key, Object value) {
        if (!(key instanceof Xid)) {
            throw new RuntimeException("This table supports only Xid-type key");
        }
        Xid xid = (Xid)key;
        String keystr = XidToString.getXidString(xid);
        this.strToXidTable.put(keystr, xid);
        return this.strToValueTable.put(keystr, value);
    }

    public synchronized int size() {
        return this.strToValueTable.size();
    }

    public synchronized void clear() {
        this.strToValueTable.clear();
        this.strToXidTable.clear();
    }

    public synchronized boolean isEmpty() {
        return this.strToValueTable.isEmpty();
    }

    public synchronized boolean containsKey(Object key) {
        if (!(key instanceof Xid)) {
            throw new RuntimeException("This table supports only Xid-type key");
        }
        Xid xid = (Xid)key;
        String keystr = XidToString.getXidString(xid);
        return this.strToValueTable.containsKey(keystr);
    }

    public synchronized boolean containsValue(Object value) {
        return this.strToValueTable.containsValue(value);
    }

    public synchronized Collection values() {
        return this.strToValueTable.values();
    }

    public synchronized void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized Object remove(Object key) {
        if (!(key instanceof Xid)) {
            throw new RuntimeException("putAll is not supported for XidHashTable");
        }
        Xid xid = (Xid)key;
        String keystr = XidToString.getXidString(xid);
        this.strToXidTable.remove(keystr);
        return this.strToValueTable.remove(keystr);
    }

    public synchronized Object getByString(String str) {
        return this.strToValueTable.get(str);
    }

    public synchronized Object getXidByString(String str) {
        return this.strToXidTable.get(str);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class XidEntry
    implements Map.Entry {
        private Object key;
        private Object value;
        private Object xidStr;

        public XidEntry(Object key, Object value, Object xidStr) {
            this.key = key;
            this.value = value;
            this.xidStr = xidStr;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return XidHashTable.this.strToValueTable.put(this.xidStr, value);
        }
    }

    private class EntryIterator
    implements Iterator {
        private Iterator i;
        private Object currentXidStr;

        private EntryIterator() {
            this.i = XidHashTable.this.strToXidTable.keySet().iterator();
        }

        public void remove() {
            XidHashTable.this.strToValueTable.remove(this.currentXidStr);
            XidHashTable.this.strToXidTable.remove(this.currentXidStr);
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            this.currentXidStr = this.i.next();
            return new XidEntry(XidHashTable.this.strToXidTable.get(this.currentXidStr), XidHashTable.this.strToValueTable.get(this.currentXidStr), this.currentXidStr);
        }
    }

    private class KeyIterator
    implements Iterator {
        private Iterator i;
        private Object currentXidStr;

        private KeyIterator() {
            this.i = XidHashTable.this.strToXidTable.keySet().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            XidHashTable xidHashTable = XidHashTable.this;
            synchronized (xidHashTable) {
                XidHashTable.this.strToValueTable.remove(this.currentXidStr);
                XidHashTable.this.strToXidTable.remove(this.currentXidStr);
            }
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            this.currentXidStr = this.i.next();
            return XidHashTable.this.strToXidTable.get(this.currentXidStr);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return XidHashTable.this.strToValueTable.size();
        }

        public boolean contains(Object o) {
            return XidHashTable.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return XidHashTable.this.remove(o) != null;
        }

        public void clear() {
            XidHashTable.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public int size() {
            return XidHashTable.this.strToValueTable.size();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return XidHashTable.this.containsKey(((Map.Entry)o).getKey());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return XidHashTable.this.remove(((Map.Entry)o).getKey()) != null;
        }

        public void clear() {
            XidHashTable.this.clear();
        }
    }
}

