/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.Hashtable;
import java.util.Map;
import jeus.util.JeusRootClassLoader;

public final class JDBCDriverChecker {
    public static String ORACLE = "oracle.jdbc.xa.OracleXid";
    public static String DB2 = "com.ibm.db2.jcc.DB2DataSource";
    private static final Map<String, Boolean> checkedTable = new Hashtable<String, Boolean>();

    public static boolean checkDriverLoaded(String vendorClassName) {
        Boolean alreadyChecked = checkedTable.get(vendorClassName);
        if (alreadyChecked == null) {
            try {
                JeusRootClassLoader.loader.loadClass(vendorClassName);
                alreadyChecked = Boolean.TRUE;
            }
            catch (Throwable t) {
                alreadyChecked = Boolean.FALSE;
            }
            checkedTable.put(vendorClassName, alreadyChecked);
        }
        return alreadyChecked;
    }
}

