/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.util.ScheduleTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledExecutor {
    private static ScheduledExecutor instance = new ScheduledExecutor();
    private static final int THREAD_NUM = 4;
    private ScheduledExecutorService scheduledExecutor;

    public static ScheduledExecutor getInstance() {
        return instance;
    }

    private ScheduledExecutor() {
    }

    private synchronized ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null || this.scheduledExecutor.isShutdown()) {
            this.scheduledExecutor = Executors.newScheduledThreadPool(4, new DaemonThreadFactory("SchedulingService"));
        }
        return this.scheduledExecutor;
    }

    void remove(ScheduledFuture future) {
        if (this.scheduledExecutor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)this.scheduledExecutor).remove((Runnable)((Object)future));
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getScheduledExecutor().schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.getScheduledExecutor().schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutor().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getScheduledExecutor().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public ScheduledFuture<?> schedule(ScheduleTask command, long delay) {
        ScheduledFuture<?> future = this.schedule(command, delay, TimeUnit.MILLISECONDS);
        command.setSchedulerExecutor(this);
        command.setFuture(future);
        return future;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ScheduleTask command, long initialDelay, long delay) {
        ScheduledFuture<?> future = this.scheduleWithFixedDelay(command, initialDelay, delay, TimeUnit.MILLISECONDS);
        command.setSchedulerExecutor(this);
        command.setFuture(future);
        return future;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ScheduleTask command, long initialDelay, long period) {
        ScheduledFuture<?> future = this.scheduleAtFixedRate(command, initialDelay, period, TimeUnit.MILLISECONDS);
        command.setSchedulerExecutor(this);
        command.setFuture(future);
        return future;
    }

    public synchronized void cancelAll() {
        if (this.scheduledExecutor != null && !this.scheduledExecutor.isShutdown()) {
            this.scheduledExecutor.shutdown();
            this.scheduledExecutor = null;
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        final String namePrefix;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        public DaemonThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + "-" + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

