/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

public class SimpleHashtable {
    protected int degree;
    protected Element[] lists;
    protected Object[] syncs;
    protected int size = 0;

    public SimpleHashtable(int degree) {
        this.degree = degree;
        this.lists = new Element[degree];
        this.syncs = new Object[degree];
        for (int i = 0; i < degree; ++i) {
            this.lists[i] = null;
            this.syncs[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object put(Object obj, Object value) {
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.degree;
        Object object = this.syncs[index];
        synchronized (object) {
            Element e;
            Element curr = this.lists[index];
            while (curr != null) {
                if (hash == curr.hash && obj.equals(curr.key)) {
                    Object old = curr.value;
                    curr.value = value;
                    return old;
                }
                curr = curr.next;
            }
            this.lists[index] = e = new Element(this.lists[index], obj, value, hash);
            ++this.size;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object remove(Object obj) {
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.degree;
        Object old = null;
        Object object = this.syncs[index];
        synchronized (object) {
            Element curr = this.lists[index];
            Element prev = null;
            while (curr != null) {
                if (hash == curr.hash && obj.equals(curr.key)) {
                    old = curr.value;
                    if (prev != null) {
                        prev.next = curr.next;
                    } else {
                        this.lists[index] = curr.next;
                    }
                    --this.size;
                }
                prev = curr;
                curr = curr.next;
            }
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Object obj) {
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.degree;
        Object object = this.syncs[index];
        synchronized (object) {
            Element curr = this.lists[index];
            while (curr != null) {
                if (hash == curr.hash && obj.equals(curr.key)) {
                    return curr.value;
                }
                curr = curr.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(Object obj) {
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.degree;
        Object object = this.syncs[index];
        synchronized (object) {
            Element curr = this.lists[index];
            while (curr != null) {
                if (hash == curr.hash && obj.equals(curr.value)) {
                    return true;
                }
                curr = curr.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsKey(Object obj) {
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.degree;
        Object object = this.syncs[index];
        synchronized (object) {
            Element curr = this.lists[index];
            while (curr != null) {
                if (hash == curr.hash && obj.equals(curr.key)) {
                    return true;
                }
                curr = curr.next;
            }
            return false;
        }
    }

    public final void removeAll() {
        for (int i = 0; i < this.degree; ++i) {
            this.lists[i] = null;
            this.syncs[i] = null;
        }
    }

    public final Object[] elements() {
        Object[] elements = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.degree; ++i) {
            Element curr = this.lists[i];
            while (curr != null && index < this.size) {
                elements[index] = curr.value;
                ++index;
                curr = curr.next;
            }
        }
        if (index < this.size) {
            Object[] newElements = new Object[index];
            System.arraycopy(elements, 0, newElements, 0, index);
            return newElements;
        }
        return elements;
    }

    public final int size() {
        return this.size;
    }

    public static final class Element {
        public Element next;
        public Object key;
        public Object value;
        public int hash;

        public Element(Element next, Object key, Object value, int hash) {
            this.next = next;
            this.key = key;
            this.value = value;
            this.hash = hash;
        }
    }
}

