/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import jeus.net.impl.NodeInfo;
import jeus.server.JeusServerException;
import jeus.server.NodeControllerStub;
import jeus.util.JeusPort;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;

public class VirtualDNS {
    protected static Boolean enabledBySystemProperty;
    protected static boolean enabled;
    private static long lastModified;
    private static final File propertiesFile;
    static Hashtable nodeInfoMap;
    static Hashtable revers_dns;
    protected static final JeusLogger logger;
    public static String LOCAL_VIRTUALNAME;
    static boolean useDifferentPorts;
    private static VirtualDNS vhostLoader;

    public static String getVirtualHostName(String host) {
        try {
            vhostLoader.load();
        }
        catch (Throwable e) {
            // empty catch block
        }
        String result = (String)revers_dns.get(host);
        if (result == null) {
            int index = host.lastIndexOf(":");
            if (index > 0) {
                String hostName = host.substring(0, index);
                try {
                    host = JeusNetPropertyValues.getByName((String)hostName).getHostAddress() + host.substring(index);
                    result = (String)revers_dns.get(host);
                    if (result != null) {
                        return result;
                    }
                    return hostName;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return hostName;
                }
            }
            String hostName = host;
            try {
                host = JeusNetPropertyValues.getByName((String)host).getHostAddress() + JeusPort.JeusBase;
                result = (String)revers_dns.get(host);
                if (result != null) {
                    return result;
                }
                result = (String)revers_dns.get(hostName);
                if (result != null) {
                    return result;
                }
                return hostName;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return hostName;
            }
        }
        return result;
    }

    public static String getRealNodeName(String host) {
        try {
            vhostLoader.load();
            NodeInfo real_host = (NodeInfo)nodeInfoMap.get(host);
            if (real_host == null) {
                return host + ":" + JeusPort.JeusBase;
            }
            return real_host.getRealNodeName();
        }
        catch (Throwable t) {
            return host + ":" + JeusPort.JeusBase;
        }
    }

    public static String getHostName(String nodeName) {
        try {
            vhostLoader.load();
            NodeInfo real_host = (NodeInfo)nodeInfoMap.get(nodeName);
            if (real_host == null) {
                return nodeName;
            }
            return real_host.getHost();
        }
        catch (Throwable t) {
            return nodeName;
        }
    }

    public static String getVirtualNameFromServer(String real_node) {
        NodeControllerStub stub = new NodeControllerStub();
        try {
            stub.connectTo(real_node);
            String string = stub.getHostName();
            return string;
        }
        catch (JeusServerException e) {
            throw new JeusRuntimeException((Throwable)((Object)e));
        }
        finally {
            stub.disconnect();
        }
    }

    public static void main(String[] args) {
    }

    public static NodeInfo getNodeInfo(String host) {
        try {
            vhostLoader.load();
            NodeInfo real_host = (NodeInfo)nodeInfoMap.get(host);
            if (real_host == null) {
                return new NodeInfo(host, JeusPort.JeusBase);
            }
            return real_host;
        }
        catch (Throwable t) {
            return new NodeInfo(host, JeusPort.JeusBase);
        }
    }

    public static void setLocalNode(String node) {
        NodeInfo nodeInfo = VirtualDNS.getNodeInfo(node);
        JeusPort.setBasePort(nodeInfo.getBasePort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        Boolean bl = enabledBySystemProperty = JeusProperties.VHOST_ENABLED == null ? null : Boolean.valueOf(JeusProperties.VHOST_ENABLED);
        if (enabledBySystemProperty != null && !enabledBySystemProperty.booleanValue()) {
            return;
        }
        if (propertiesFile.exists()) {
            long modified = propertiesFile.lastModified();
            if (modified > lastModified) {
                lastModified = modified;
                Properties properties = new Properties();
                FileInputStream in = new FileInputStream(propertiesFile);
                try {
                    properties.load(in);
                }
                finally {
                    in.close();
                }
                revers_dns.clear();
                nodeInfoMap.clear();
                try {
                    enabled = enabledBySystemProperty != null ? enabledBySystemProperty.booleanValue() : Boolean.valueOf(properties.getProperty("jeus.vhost.enabled", "false")).booleanValue();
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "", (Throwable)ex);
                }
                if (enabled) {
                    Enumeration<?> keys = properties.propertyNames();
                    while (keys.hasMoreElements()) {
                        String key = ((String)keys.nextElement()).trim();
                        if (key.startsWith("jeus.vhost.")) continue;
                        String virtualNode = key;
                        String realNode = properties.getProperty(key).trim();
                        this.addNode(realNode, virtualNode);
                    }
                }
            }
        } else {
            this.loadFromVhostXML();
        }
    }

    private void addNode(String realNode, String virtualNode) {
        int port;
        String node;
        revers_dns.put(realNode, virtualNode);
        int idx = realNode.indexOf(":");
        if (idx == -1) {
            node = realNode;
            port = JeusPort.JeusBase;
        } else {
            node = realNode.substring(0, idx);
            port = Integer.parseInt(realNode.substring(idx + 1));
            if (port != JeusPort.JeusBase) {
                useDifferentPorts = true;
            }
        }
        NodeInfo nodeInfo = new NodeInfo(node, port);
        nodeInfoMap.put(virtualNode, nodeInfo);
    }

    protected void loadFromVhostXML() throws Exception {
    }

    public static VirtualDNS getVhostLoader() {
        return vhostLoader;
    }

    static {
        propertiesFile = new File(JeusProperties.VHOST_PROPERTIES_PATH);
        nodeInfoMap = new Hashtable();
        revers_dns = new Hashtable();
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
        try {
            Class<?> c = VirtualDNS.class.getClassLoader().loadClass("jeus.util.ServerVirtualDNS");
            vhostLoader = (VirtualDNS)c.newInstance();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Manager1._523_LEVEL)) {
                logger.log(JeusMessage_Manager1._523_LEVEL, JeusMessage_Manager1._523);
            }
            vhostLoader = new VirtualDNS();
        }
        try {
            vhostLoader.load();
            LOCAL_VIRTUALNAME = (String)revers_dns.get(JeusNetPropertyValues.LOCAL_HOSTNAME + ":" + JeusPort.JeusBase);
            if (LOCAL_VIRTUALNAME == null && (LOCAL_VIRTUALNAME = (String)revers_dns.get(JeusNetPropertyValues.LOCAL_HOSTADDRESS + ":" + JeusPort.JeusBase)) == null && (LOCAL_VIRTUALNAME = (String)revers_dns.get("127.0.0.1:" + JeusPort.JeusBase)) == null) {
                if (JeusPropertyValues.JEUS_CATEGORY != 0) {
                    if (nodeInfoMap.get(JeusNetPropertyValues.LOCAL_HOSTNAME) != null) {
                        logger.log(JeusMessage_Manager1._524_LEVEL, JeusMessage_Manager1._524, new Object[]{JeusNetPropertyValues.LOCAL_HOSTNAME, JeusNetPropertyValues.LOCAL_HOSTADDRESS, "127.0.0.1", revers_dns, nodeInfoMap});
                        throw new JeusRuntimeException("This manager is not in the vhost.properties, but the node name " + JeusNetPropertyValues.LOCAL_HOSTNAME + " is used for a virtual name specified in the xml file, maybe base port is not set correctly");
                    }
                    if (useDifferentPorts) {
                        throw new JeusRuntimeException("This manager is not in the vhost.properties, but the base ports of other nodes in the properties file are not the same with one another so that they cannot connect to this node, check vhost.properties, local hostname : " + JeusNetPropertyValues.LOCAL_HOSTNAME + ", local host address : " + JeusNetPropertyValues.LOCAL_HOSTADDRESS + ", local loopback address : " + "127.0.0.1" + ", reverse dns : " + revers_dns);
                    }
                }
                LOCAL_VIRTUALNAME = JeusNetPropertyValues.LOCAL_HOSTNAME;
            }
            if (JeusPropertyValues.JEUS_CATEGORY == 1 && logger.isLoggable(JeusMessage_Manager1._518_LEVEL)) {
                logger.log(JeusMessage_Manager1._518_LEVEL, JeusMessage_Manager1._518, new Object[]{enabled, revers_dns});
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new JeusRuntimeException(ex);
        }
    }
}

