/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AntJeusAppCompiler
extends Task {
    private String taskClassName = "jeus.tool.compiler.AppCompilerBootstrapper";
    private boolean keepGenerated;
    private boolean jspmap;
    private File clienViewJar;
    private File ejbJar;
    private File jeusEjbDD;
    private String name;
    private File targetFile;
    private String classpath;
    private String classpathRef;
    private Reference reference;
    private File jeusHome;

    public void execute() {
        if (this.jeusHome == null) {
            String jeusHome = System.getProperty("jeus.home");
            if (jeusHome == null) {
                throw new BuildException("Jeushome : " + jeusHome + " is not valid directory.");
            }
            this.jeusHome = new File(jeusHome);
        }
        if (!this.jeusHome.isDirectory()) {
            throw new BuildException("Jeushome : " + this.jeusHome.getPath() + " is not valid directory.");
        }
        String jvmArgs = "-Djeus.home=" + this.jeusHome.getAbsolutePath();
        Java task = (Java)this.getProject().createTask("java");
        task.setTaskName(this.getTaskName());
        task.setFork(true);
        task.setClassname(this.taskClassName);
        task.createJvmarg().setLine(jvmArgs);
        if (this.keepGenerated) {
            task.createArg().setValue("-keep");
        }
        if (this.jspmap) {
            task.createArg().setValue("-jspmap");
        }
        if (this.clienViewJar != null) {
            task.createArg().setValue("-client");
            task.createArg().setValue(this.clienViewJar.getAbsolutePath());
        }
        if (this.ejbJar != null) {
            task.createArg().setValue("-ejb-jar");
            task.createArg().setValue(this.ejbJar.getAbsolutePath());
        }
        if (this.jeusEjbDD != null) {
            task.createArg().setValue("-jeus-ejb-dd");
            task.createArg().setValue(this.jeusEjbDD.getAbsolutePath());
        }
        if (this.name != null) {
            task.createArg().setValue("-n");
            task.createArg().setValue(this.name);
        }
        task.createArg().setValue(this.targetFile.getAbsolutePath());
        task.createJvmarg().setValue("-Djava.endorsed.dirs=" + this.jeusHome + File.separator + "lib" + File.separator + "endorsed");
        String classpathToSet = null;
        if (this.classpath != null) {
            classpathToSet = this.classpath;
        }
        if (this.classpathRef != null) {
            classpathToSet = (classpathToSet != null ? classpathToSet + ";" : "") + this.reference.getProject().getReferences().get(this.classpathRef);
        }
        task.createJvmarg().setValue("-Djeus.server.classpath=" + classpathToSet);
        File bootstrapPath = new File(this.jeusHome, "lib" + File.separator + "system" + File.separator + "bootstrap.jar");
        Path classPath = new Path(this.getProject());
        classPath.setLocation(bootstrapPath);
        task.setClasspath(classPath);
        if (task.executeJava() != 0) {
            throw new BuildException("Error Occured");
        }
    }

    public void setJeusHome(File jeusHome) {
        this.jeusHome = jeusHome;
    }

    public void setKeep(boolean keepGenerated) {
        this.keepGenerated = keepGenerated;
    }

    public void setJspmap(boolean jspmap) {
        this.jspmap = jspmap;
    }

    public void setClient(File clientViewJar) {
        this.clienViewJar = clientViewJar;
    }

    public void setEjbJar(File ejbJar) {
        this.ejbJar = ejbJar;
    }

    public void setJeusEjbDD(File jeusEjbDD) {
        this.jeusEjbDD = jeusEjbDD;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTarget(File target) {
        this.targetFile = target;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setClasspathRef(String refid) {
        this.classpathRef = refid;
        this.reference = new Reference(this.getProject(), refid);
    }
}

