/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.TargetImpl;
import jeus.deploy.status.ProgressHandler;
import jeus.util.ant.JeusTaskBase;
import org.apache.tools.ant.BuildException;

public class AntJeusDeploy
extends JeusTaskBase {
    private String targetName;
    private String srcPath;
    private String planPath;
    private String serverUri;
    private String userName;
    private String passwd;
    private boolean onlyDistribute = false;
    private boolean fastDeploy;
    private boolean autoSourceDistribute;
    private boolean twoPhaseDistribute;

    public void setDeployURI(String su) {
        this.serverUri = su;
    }

    public void setUser(String user) {
        this.userName = user;
    }

    public void setPassword(String pass) {
        this.passwd = pass;
    }

    public void setModulePath(String sp) {
        this.srcPath = sp;
    }

    public void setTargetNames(String tn) {
        this.targetName = tn;
    }

    public void setPlanPath(String path) {
        this.planPath = path;
    }

    public void setOnlyDistribute(boolean onlyDistribute) {
        this.onlyDistribute = onlyDistribute;
    }

    public void setFastDeploy(boolean fastDeploy) {
        this.fastDeploy = fastDeploy;
    }

    public void setAutoSourceDistribute(boolean autoSourceDistribute) {
        this.autoSourceDistribute = autoSourceDistribute;
    }

    public void setTwoPhase(boolean twoPhaseDistribute) {
        this.twoPhaseDistribute = twoPhaseDistribute;
    }

    protected void doExecute() throws BuildException {
        try {
            JeusDeploymentManager jdm;
            try {
                System.setProperty("jeus.home", this.getProject().getProperty("jeus.home"));
                System.setProperty("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
                System.setProperty("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
                String[] decomposedUri = JeusDeploymentManager.decomposeUri(this.serverUri);
                System.setProperty("java.naming.provider.url", decomposedUri[0]);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            try {
                jdm = new JeusDeploymentManager(this.serverUri, this.userName, this.passwd);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            Target[] targetList = jdm.getTargets();
            if (targetList == null || targetList.length == 0) {
                throw new BuildException("Unable to find available targets.");
            }
            if (this.targetName != null && !this.targetName.trim().equals("")) {
                Vector<TargetImpl> severalTargets = new Vector<TargetImpl>();
                Set givenTargetNames = this.getParsedTargets(this.targetName);
                for (int i = 0; i < targetList.length; ++i) {
                    TargetImpl targetImpl = (TargetImpl)targetList[i];
                    if (!givenTargetNames.contains(targetImpl.getContainerName())) continue;
                    severalTargets.add(targetImpl);
                }
                if (severalTargets.size() == 0) {
                    throw new BuildException("Sorry, specified Target is not available..");
                }
                targetList = severalTargets.toArray(new TargetImpl[severalTargets.size()]);
            }
            ProgressHandler progressHandler = new ProgressHandler();
            File planFile = null;
            if (this.planPath != null) {
                planFile = new File(this.planPath);
            }
            ProgressObject progress = jdm.deploy(targetList, new File(this.srcPath), planFile, this.fastDeploy, this.onlyDistribute, this.twoPhaseDistribute, this.autoSourceDistribute);
            progress.addProgressListener((ProgressListener)progressHandler);
            try {
                progressHandler.join();
            }
            catch (Exception e) {
                // empty catch block
            }
            StateType completionState = progressHandler.getCompletionState();
            if (completionState.getValue() != StateType.COMPLETED.getValue()) {
                throw new BuildException("[ERROR] Distribution Failed.");
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private Set getParsedTargets(String targetString) {
        String[] targets = targetString.split(",");
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = targets[i].trim();
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(targets));
        return set;
    }
}

