/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant;

import jeus.security.base.Subject;
import jeus.security.util.LoginUtil;
import jeus.server.NodeControllerStub;
import jeus.util.SecurityUtil;
import jeus.util.VirtualDNS;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntJeusDown
extends Task {
    private String node;
    private String real_node;
    private boolean jeusexit;
    private String username;
    private String password;
    private NodeControllerStub stub;

    public void execute() throws BuildException {
        SecurityUtil.installClientSecurity(this.node);
        LoginUtil.loginWithRuntimeException(Subject.makeSubject("SYSTEM_DOMAIN", this.username, this.password));
        try {
            this.stub = new NodeControllerStub();
            if (!this.openConnection()) {
                return;
            }
            if (this.stub.down()) {
                System.out.println(this.node + " down successful");
                if (this.jeusexit) {
                    if (this.stub.exit()) {
                        System.out.println(this.node + " jeusexit successful");
                    } else {
                        System.out.println(this.node + " jeusexit failed");
                    }
                }
            } else {
                System.out.println(this.node + " down failed");
            }
            this.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public void setNode(String node) {
        System.setProperty("jeus.home", this.getProject().getProperty("jeus.home"));
        this.node = node;
        this.real_node = VirtualDNS.getRealNodeName(node);
    }

    public void setJeusexit(boolean jeusexit) {
        this.jeusexit = jeusexit;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void closeConnection() {
        try {
            this.stub.disconnect();
            this.stub.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean openConnection() {
        try {
            this.stub.connectTo(this.real_node);
            return true;
        }
        catch (Throwable t) {
            System.out.println("fail to connect to " + this.node);
            return false;
        }
    }
}

