/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.cnet.classftp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jeus.servlet.util.JSVByteArrayOutputStream;
import jeus.util.cnet.classftp.Handler;

public class ClassFTPClassLoader
extends ClassLoader {
    private URL url;
    private boolean isJar;
    private byte[] jarContent;
    private String urlString;

    public ClassFTPClassLoader(URL u, ClassLoader parent, String urlString) {
        super(parent);
        this.url = u;
        this.isJar = u.getFile().endsWith("jar");
        this.urlString = urlString;
    }

    public String getUrlString() {
        return this.urlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block21: {
            String realName = name.replace('.', '/') + ".class";
            if (this.isJar) {
                ZipEntry entry;
                if (this.jarContent == null) {
                    ClassFTPClassLoader classFTPClassLoader = this;
                    synchronized (classFTPClassLoader) {
                        if (this.jarContent == null) {
                            URLConnection con = this.url.openConnection();
                            InputStream in = con.getInputStream();
                            int len = con.getContentLength();
                            if (len <= 0) {
                                this.jarContent = new byte[0];
                            } else {
                                this.jarContent = new byte[len];
                                DataInputStream din = new DataInputStream(in);
                                din.readFully(this.jarContent);
                            }
                        }
                    }
                }
                if (this.jarContent.length == 0) {
                    throw new IOException(this.url + " has no content");
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(this.jarContent);
                ZipInputStream zin = new ZipInputStream(bin);
                boolean found = false;
                JSVByteArrayOutputStream baos = null;
                while ((entry = zin.getNextEntry()) != null) {
                    int b;
                    if (!entry.getName().equals(realName)) continue;
                    baos = new JSVByteArrayOutputStream();
                    while (zin.available() != 0 && (b = zin.read()) != -1) {
                        baos.write(b);
                    }
                    baos.close();
                    found = true;
                    break;
                }
                zin.closeEntry();
                zin.close();
                bin.close();
                if (found) {
                    return this.defineClass(name, baos.getByteArray(), 0, baos.getCount());
                }
                throw new ClassNotFoundException(name + " from the URL " + this.urlString);
            }
            String ClassName = realName.substring(realName.lastIndexOf("/") + 1);
            if (!this.url.toString().endsWith(ClassName)) {
                int index2;
                int index1 = this.url.toString().lastIndexOf(47);
                if (index1 < (index2 = this.url.toString().lastIndexOf(92))) {
                    index1 = index2;
                }
                this.url = new URL(null, this.url.toString().substring(0, index1 + 1) + ClassName, new Handler());
            }
            URLConnection con = this.url.openConnection();
            DataInputStream in = new DataInputStream(con.getInputStream());
            try {
                int len = con.getContentLength();
                if (len <= 0) {
                    throw new ClassNotFoundException(name);
                }
                byte[] data = new byte[len];
                in.readFully(data);
                clazz = this.defineClass(name, data, 0, data.length);
                if (in == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(name, ioe);
                }
            }
            in.close();
        }
        return clazz;
    }
}

